/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding;

import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.BranchingProcess;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Condition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Event;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.ICoRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ConditionConditionCoRelation<LETTER, PLACE>
implements ICoRelation<LETTER, PLACE> {
    private static final boolean EXTENDED_ASSERTION_CHECKING = true;
    private long mQueryCounterYes;
    private long mQueryCounterNo;
    private final HashRelation<Condition<LETTER, PLACE>, Condition<LETTER, PLACE>> mCoRelatedConditions = new HashRelation();
    private final BranchingProcess<LETTER, PLACE> mBranchingProcess;

    public ConditionConditionCoRelation(BranchingProcess<LETTER, PLACE> branchingProcess) {
        this.mBranchingProcess = branchingProcess;
    }

    @Override
    public long getQueryCounterYes() {
        return this.mQueryCounterYes;
    }

    @Override
    public long getQueryCounterNo() {
        return this.mQueryCounterNo;
    }

    @Override
    public void initialize(Set<Condition<LETTER, PLACE>> set) {
        for (Condition<LETTER, PLACE> condition : set) {
            this.mCoRelatedConditions.addAllPairs(condition, set);
            this.mCoRelatedConditions.removePair(condition, condition);
        }
    }

    @Override
    public void update(Event<LETTER, PLACE> event) {
        if (event.getTransition() == null) {
            assert (event.getPredecessorConditions().isEmpty()) : "not initial event";
            return;
        }
        for (Condition<LETTER, PLACE> object2 : event.getSuccessorConditions()) {
            if (!event.getPredecessorConditions().contains(object2)) {
                this.mCoRelatedConditions.addAllPairs(object2, event.getConditionMark().getConditions());
                this.mCoRelatedConditions.removePair(object2, object2);
                continue;
            }
            this.mCoRelatedConditions.addAllPairs(object2, event.getSuccessorConditions());
            this.mCoRelatedConditions.removePair(object2, object2);
        }
        List list = event.getPredecessorConditions().stream().map(arg_0 -> this.mCoRelatedConditions.getImage(arg_0)).collect(Collectors.toList());
        Set set = DataStructureUtils.intersection(list);
        set.forEach(condition -> {
            boolean bl = this.mCoRelatedConditions.addAllPairs(condition, event.getSuccessorConditions());
        });
        event.getSuccessorConditions().forEach(condition -> {
            boolean bl = this.mCoRelatedConditions.addAllPairs(condition, (Collection)set);
        });
    }

    @Override
    public boolean isInCoRelation(Condition<LETTER, PLACE> condition, Condition<LETTER, PLACE> condition2) {
        boolean bl = this.mCoRelatedConditions.containsPair(condition, condition2);
        if (bl) {
            ++this.mQueryCounterYes;
        } else {
            ++this.mQueryCounterNo;
        }
        return bl;
    }

    public boolean isInIrreflexiveCoRelation(Event<LETTER, PLACE> event, Event<LETTER, PLACE> event2) {
        if (event == event2) {
            return false;
        }
        if (this.mBranchingProcess.getDummyRoot() == event || this.mBranchingProcess.getDummyRoot() == event2) {
            return false;
        }
        Set<Condition<LETTER, PLACE>> set = event.getPredecessorConditions();
        Set<Condition<LETTER, PLACE>> set2 = event2.getPredecessorConditions();
        for (Condition condition : set) {
            if (!set2.contains(condition) && this.isCoset(set2, condition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isInCoRelation(Condition<LETTER, PLACE> condition, Event<LETTER, PLACE> event) {
        if (event.getPredecessorConditions().contains(condition)) {
            return false;
        }
        return this.isCoset(event.getPredecessorConditions(), condition);
    }

    @Override
    public boolean isCoset(Collection<Condition<LETTER, PLACE>> collection, Condition<LETTER, PLACE> condition) {
        for (Condition<LETTER, PLACE> condition2 : collection) {
            if (this.isInCoRelation(condition, condition2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.mCoRelatedConditions.toString();
    }

    @Override
    public Set<Condition<LETTER, PLACE>> computeCoRelatatedConditions(Condition<LETTER, PLACE> condition) {
        Set set = this.mCoRelatedConditions.getImage(condition);
        assert (set.equals(this.computeCoRelatatedConditionsInefficient(condition))) : "inconsistent co-relation information";
        return set;
    }

    @Override
    public Set<Condition<LETTER, PLACE>> computeNonCutoffCoRelatatedConditions(Condition<LETTER, PLACE> condition2) {
        Set<Condition<LETTER, PLACE>> set = this.mCoRelatedConditions.getImage(condition2).stream().filter(condition -> !condition.getPredecessorEvent().isCutoffEvent()).collect(Collectors.toSet());
        return set;
    }

    private Set<Condition<LETTER, PLACE>> computeCoRelatatedConditionsInefficient(Condition<LETTER, PLACE> condition) {
        HashSet<Condition<LETTER, PLACE>> hashSet = new HashSet<Condition<LETTER, PLACE>>();
        for (Condition<LETTER, PLACE> condition2 : this.mBranchingProcess.getConditions()) {
            if (!this.isInCoRelation(condition, condition2)) continue;
            hashSet.add(condition2);
        }
        return hashSet;
    }

    @Override
    public int computeMaximalDegree() {
        Function<Condition, Integer> function = condition -> this.mCoRelatedConditions.getImage(condition).size();
        Integer n = this.mCoRelatedConditions.getDomain().stream().map(function).max(Integer::compare).orElse(0);
        return n;
    }

    @Override
    public Set<Condition<LETTER, PLACE>> computeCoRelatatedConditions(Condition<LETTER, PLACE> condition2, PLACE PLACE) {
        return this.mCoRelatedConditions.getImage(condition2).stream().filter(condition -> condition.getPlace().equals(PLACE)).collect(Collectors.toSet());
    }

    @Override
    public Set<Event<LETTER, PLACE>> computeCoRelatatedEvents(Event<LETTER, PLACE> event) {
        assert (false) : "have to be implemented ";
        return null;
    }

    @Override
    public Set<Event<LETTER, PLACE>> computeCoRelatatedEvents(Condition<LETTER, PLACE> condition) {
        assert (false) : "have to be implemented ";
        return null;
    }
}

