/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.models.annotation;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ModernAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Overapprox
extends ModernAnnotations {
    private static final long serialVersionUID = -575969312624287029L;
    @Visualizable
    private final Map<String, ILocation> mReason2Loc;

    public Overapprox(Map<String, ILocation> map) {
        this.mReason2Loc = map;
    }

    public Overapprox(String string, ILocation iLocation) {
        this(Collections.singletonMap(string, iLocation));
    }

    @Visualizable
    private Set<String> getReasonForOverapproximation() {
        return this.mReason2Loc.keySet();
    }

    public Map<String, ILocation> getOverapproximatedLocations() {
        return this.mReason2Loc;
    }

    public static HashRelation<String, ILocation> getOverapproximations(List<? extends IElement> list) {
        HashRelation hashRelation = new HashRelation();
        for (IElement iElement : list) {
            Overapprox overapprox = Overapprox.getAnnotation(iElement);
            if (overapprox == null) continue;
            for (Map.Entry<String, ILocation> entry : overapprox.getOverapproximatedLocations().entrySet()) {
                hashRelation.addPair((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        return hashRelation;
    }

    public static <TE extends IElement> HashRelation<String, ILocation> getOverapproximations(IProgramExecution<TE, ?> iProgramExecution) {
        HashRelation hashRelation = new HashRelation();
        Iterator iterator = iProgramExecution.iterator();
        while (iterator.hasNext()) {
            IElement iElement = (IElement)((AtomicTraceElement)iterator.next()).getTraceElement();
            Overapprox overapprox = Overapprox.getAnnotation(iElement);
            if (overapprox == null) continue;
            for (Map.Entry<String, ILocation> entry : overapprox.getOverapproximatedLocations().entrySet()) {
                hashRelation.addPair((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        return hashRelation;
    }

    public String toString() {
        return "Overapprox: " + String.valueOf(this.mReason2Loc);
    }

    public IAnnotations annotate(IElement iElement) {
        return iElement.getPayload().getAnnotations().put(Overapprox.class.getName(), this);
    }

    public static Overapprox getAnnotation(IElement iElement) {
        return (Overapprox)ModelUtils.getAnnotation((IElement)iElement, Overapprox.class);
    }

    public IAnnotations merge(IAnnotations iAnnotations) {
        if (iAnnotations == this || iAnnotations == null) {
            return this;
        }
        if (!(iAnnotations instanceof Overapprox)) {
            return super.merge(iAnnotations);
        }
        Overapprox overapprox = (Overapprox)iAnnotations;
        HashMap<String, ILocation> hashMap = new HashMap<String, ILocation>(this.mReason2Loc);
        for (Map.Entry<String, ILocation> entry : overapprox.mReason2Loc.entrySet()) {
            ILocation iLocation = hashMap.putIfAbsent(entry.getKey(), entry.getValue());
        }
        return new Overapprox(hashMap);
    }
}

