/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.IDfsOrder;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.IPersistentSetChoice;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.multireduction.ISleepMapStateFactory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MultiPersistentSetChoice<L, S>
implements IPersistentSetChoice<L, S> {
    private final List<IPersistentSetChoice<L, S>> mUnderlying;
    private final ISleepMapStateFactory<L, ?, S> mSleepMapFactory;

    public MultiPersistentSetChoice(List<IPersistentSetChoice<L, S>> list, ISleepMapStateFactory<L, ?, S> iSleepMapStateFactory) {
        this.mUnderlying = list;
        this.mSleepMapFactory = iSleepMapStateFactory;
    }

    @Override
    public Set<L> persistentSet(S s) {
        Set set = null;
        Iterator<IPersistentSetChoice<L, S>> iterator = this.mUnderlying.iterator();
        int n = this.mSleepMapFactory.getBudget(s);
        int n2 = 0;
        while (n2 < n) {
            assert (iterator.hasNext()) : "Budget exceeds number of persistent set computations";
            Set set2 = iterator.next().persistentSet(s);
            if (set2 != null) {
                set = set == null ? set2 : DataStructureUtils.intersection(set, set2);
            }
            ++n2;
        }
        return set;
    }

    @Override
    public boolean ensuresCompatibility(IDfsOrder<L, S> iDfsOrder) {
        assert (this.mUnderlying.stream().allMatch(iPersistentSetChoice -> iPersistentSetChoice.ensuresCompatibility(iDfsOrder)));
        return true;
    }
}

