/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinArSolve;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.TableauxRow;
import java.math.BigInteger;

public class MatrixEntry {
    private final LinArSolve mSolver;
    private final TableauxRow mRow;
    private final int mPosition;

    public MatrixEntry(LinArSolve linArSolve, TableauxRow tableauxRow, int n) {
        this.mSolver = linArSolve;
        this.mRow = tableauxRow;
        this.mPosition = n;
    }

    public LinVar getColumn() {
        return (LinVar)this.mSolver.mLinvars.get(this.mRow.getRawIndex(this.mPosition));
    }

    public LinVar getRow() {
        return (LinVar)this.mSolver.mLinvars.get(this.mRow.getRawIndex(0));
    }

    public BigInteger getCoeff() {
        return this.mRow.getRawCoeff(this.mPosition);
    }

    public BigInteger getHeadCoeff() {
        assert (this.mPosition != 0);
        return this.mRow.getRawCoeff(0);
    }

    public String toString() {
        if (this.mPosition == 0) {
            return this.mRow.toString();
        }
        return "[" + String.valueOf(this.getRow()) + "/" + String.valueOf(this.getColumn()) + "]->" + String.valueOf(this.getCoeff());
    }
}

