/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.proofs;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUtils;
import de.uni_freiburg.informatik.ultimate.lib.proofs.ISpecification;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PrePostConditionSpecification<S>
implements ISpecification {
    private final Map<S, IPredicate> mInitialStates;
    private final Predicate<S> mIsFinalState;
    private final IPredicate mPostcondition;

    public PrePostConditionSpecification(Map<S, IPredicate> map, Predicate<S> predicate, IPredicate iPredicate) {
        this.mInitialStates = map;
        this.mIsFinalState = predicate;
        this.mPostcondition = Objects.requireNonNull(iPredicate);
    }

    public static <LOC extends IcfgLocation> PrePostConditionSpecification<LOC> forIcfg(IIcfg<LOC> iIcfg, IPredicateUnifier iPredicateUnifier) {
        ModifiableGlobalsTable modifiableGlobalsTable = iIcfg.getCfgSmtToolkit().getModifiableGlobalsTable();
        Script script = iIcfg.getCfgSmtToolkit().getManagedScript().getScript();
        Map map = iIcfg.getInitialNodes().stream().collect(Collectors.toMap(Function.identity(), icfgLocation -> PredicateUtils.computeInitialPredicateForProcedure((ModifiableGlobalsTable)modifiableGlobalsTable, (Script)script, (String)icfgLocation.getProcedure(), (BasicPredicateFactory)iPredicateUnifier.getPredicateFactory())));
        return PrePostConditionSpecification.forIcfg(iIcfg, map, iPredicateUnifier.getFalsePredicate());
    }

    public static <LOC extends IcfgLocation> PrePostConditionSpecification<LOC> forIcfg(IIcfg<LOC> iIcfg, Map<LOC, IPredicate> map, IPredicate iPredicate) {
        return new PrePostConditionSpecification<IcfgLocation>(map, icfgLocation -> IcfgUtils.isErrorLocation((IIcfg)iIcfg, (IcfgLocation)icfgLocation), iPredicate);
    }

    public Collection<S> getInitialStates() {
        return this.mInitialStates.keySet();
    }

    public boolean isFinalState(S s) {
        return this.mIsFinalState.test(s);
    }

    public IPredicate getPrecondition(S s) {
        return this.mInitialStates.get(s);
    }

    public IPredicate getPostcondition() {
        return this.mPostcondition;
    }

    public boolean isUnreachabilitySpecification() {
        return SmtUtils.isFalseLiteral((Term)this.mPostcondition.getFormula());
    }
}

