/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.lassoranker;

import de.uni_freiburg.informatik.ultimate.core.lib.preferences.UltimatePreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.PreferenceType;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.UltimatePreferenceItem;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lassoranker.AnalysisType;
import de.uni_freiburg.informatik.ultimate.lassoranker.DefaultLassoRankerPreferences;
import de.uni_freiburg.informatik.ultimate.lassoranker.ILassoRankerPreferences;
import de.uni_freiburg.informatik.ultimate.lassoranker.LassoRankerPreferences;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.DefaultNonTerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.INonTerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.NonTerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.DefaultTerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.ITerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.lassoranker.Activator;

public class PreferencesInitializer
extends UltimatePreferenceInitializer {
    public static final boolean s_simplify_result = true;
    public static final boolean s_enable_affine_template = true;
    public static final boolean s_enable_nested_template = true;
    public static final int s_nested_template_size = 4;
    public static final boolean s_enable_multiphase_template = true;
    public static final int s_multiphase_template_size = 2;
    public static final boolean s_enable_lex_template = true;
    public static final int s_lex_template_size = 2;
    public static final boolean s_enable_piecewise_template = true;
    public static final int s_piecewise_template_size = 2;
    public static final boolean s_enable_parallel_template = true;
    public static final int s_multilex_template_size = 2;
    public static final boolean s_enable_multilex_template = false;
    public static final int s_parallel_template_size = 2;
    public static final String LABEL_enable_partitioneer = "Enable LassoPartitioneer";
    public static final String LABEL_nontermination_analysis = "Nontermination analysis";
    public static final String LABEL_nontermination_number_gevs = "Number of generalized eigenvectors";
    public static final String LABEL_nontermination_nilpotent_components = "Allow nilpotent components";
    public static final String LABEL_nontermination_bounded_executions = "Allow bounded nonterminating executions";
    public static final String LABEL_termination_analysis = "Termination analysis";
    public static final String LABEL_numstrict_invariants = "Number of strict supporting invariants";
    public static final String LABEL_numnon_strict_invariants = "Number of non-strict supporting invariants";
    public static final String LABEL_nondecreasing_invariants = "Only non-decreasing invariants";
    public static final String LABEL_compute_integral_hull = "Compute integral hull";
    public static final String LABEL_annotate_terms = "Add annotations to SMT terms";
    public static final String LABEL_simplify_result = "Simplify discovered termination arguments";
    public static final String LABEL_enable_affine_template = "Affine template";
    public static final String LABEL_enable_nested_template = "Nested template";
    public static final String LABEL_nested_template_size = "Nested template size";
    public static final String LABEL_enable_multiphase_template = "Multiphase template";
    public static final String LABEL_multiphase_template_size = "Multiphase template size";
    public static final String LABEL_enable_lex_template = "Lexicographic template";
    public static final String LABEL_lex_template_size = "Lexicographic template size";
    public static final String LABEL_enable_piecewise_template = "Piecewise template";
    public static final String LABEL_piecewise_template_size = "Piecewise template size";
    public static final String LABEL_enable_parallel_template = "Parallel template";
    public static final String LABEL_parallel_template_size = "Parallel template size";
    public static final String LABEL_enable_multilex_template = "Multilex template";
    public static final String LABEL_multilex_template_size = "Multilex template size";
    public static final String LABEL_use_external_solver = "Use external SMT solver";
    public static final String LABEL_smt_solver_command = "SMT solver command";
    public static final String LABEL_dump_smt_script = "Dump SMT script to file";
    public static final String LABEL_path_of_dumped_script = "Path of dumped script";

    public PreferencesInitializer() {
        super(Activator.PLUGIN_ID, "LassoRanker");
    }

    protected UltimatePreferenceItem<?>[] initDefaultPreferences() {
        DefaultLassoRankerPreferences defaultLassoRankerPreferences = new DefaultLassoRankerPreferences();
        DefaultTerminationAnalysisSettings defaultTerminationAnalysisSettings = new DefaultTerminationAnalysisSettings();
        DefaultNonTerminationAnalysisSettings defaultNonTerminationAnalysisSettings = new DefaultNonTerminationAnalysisSettings();
        return new UltimatePreferenceItem[]{new UltimatePreferenceItem(LABEL_enable_partitioneer, (Object)defaultLassoRankerPreferences.isEnablePartitioneer(), PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_nontermination_analysis, (Object)defaultNonTerminationAnalysisSettings.getAnalysis(), PreferenceType.Combo, (Object[])AnalysisType.values()), new UltimatePreferenceItem(LABEL_nontermination_number_gevs, (Object)defaultNonTerminationAnalysisSettings.getNumberOfGevs(), PreferenceType.Integer), new UltimatePreferenceItem(LABEL_nontermination_nilpotent_components, (Object)defaultNonTerminationAnalysisSettings.isNilpotentComponents(), PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_nontermination_bounded_executions, (Object)defaultNonTerminationAnalysisSettings.isAllowBounded(), PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_termination_analysis, (Object)defaultTerminationAnalysisSettings.getAnalysis(), PreferenceType.Combo, (Object[])AnalysisType.values()), new UltimatePreferenceItem(LABEL_numstrict_invariants, (Object)defaultTerminationAnalysisSettings.getNumStrictInvariants(), PreferenceType.Integer), new UltimatePreferenceItem(LABEL_numnon_strict_invariants, (Object)defaultTerminationAnalysisSettings.getNumNonStrictInvariants(), PreferenceType.Integer), new UltimatePreferenceItem(LABEL_nondecreasing_invariants, (Object)defaultTerminationAnalysisSettings.isNonDecreasingInvariants(), PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_compute_integral_hull, (Object)defaultLassoRankerPreferences.isComputeIntegralHull(), PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_annotate_terms, (Object)defaultLassoRankerPreferences.isAnnotateTerms(), PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_simplify_result, (Object)true, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_enable_affine_template, (Object)true, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_enable_nested_template, (Object)true, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_nested_template_size, (Object)4, PreferenceType.Integer), new UltimatePreferenceItem(LABEL_enable_multiphase_template, (Object)true, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_multiphase_template_size, (Object)2, PreferenceType.Integer), new UltimatePreferenceItem(LABEL_enable_lex_template, (Object)true, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_lex_template_size, (Object)2, PreferenceType.Integer), new UltimatePreferenceItem(LABEL_enable_piecewise_template, (Object)true, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_piecewise_template_size, (Object)2, PreferenceType.Integer), new UltimatePreferenceItem(LABEL_enable_parallel_template, (Object)true, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_parallel_template_size, (Object)2, PreferenceType.Integer), new UltimatePreferenceItem(LABEL_enable_multilex_template, (Object)false, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_multilex_template_size, (Object)2, PreferenceType.Integer), new UltimatePreferenceItem(LABEL_use_external_solver, (Object)true, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_smt_solver_command, (Object)defaultLassoRankerPreferences.getExternalSolverCommand(), PreferenceType.String), new UltimatePreferenceItem(LABEL_dump_smt_script, (Object)defaultLassoRankerPreferences.isDumpSmtSolverScript(), PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_path_of_dumped_script, (Object)defaultLassoRankerPreferences.getPathOfDumpedScript(), PreferenceType.String)};
    }

    public static LassoRankerPreferences getLassoRankerPreferences(IUltimateServiceProvider iUltimateServiceProvider) {
        final IPreferenceProvider iPreferenceProvider = iUltimateServiceProvider.getPreferenceProvider(Activator.PLUGIN_ID);
        return new LassoRankerPreferences((ILassoRankerPreferences)new DefaultLassoRankerPreferences(){

            public boolean isEnablePartitioneer() {
                return iPreferenceProvider.getBoolean(PreferencesInitializer.LABEL_enable_partitioneer);
            }

            public boolean isComputeIntegralHull() {
                return iPreferenceProvider.getBoolean(PreferencesInitializer.LABEL_compute_integral_hull);
            }

            public boolean isAnnotateTerms() {
                return iPreferenceProvider.getBoolean(PreferencesInitializer.LABEL_annotate_terms);
            }

            public boolean isDumpSmtSolverScript() {
                return iPreferenceProvider.getBoolean(PreferencesInitializer.LABEL_dump_smt_script);
            }

            public boolean isExternalSolver() {
                return iPreferenceProvider.getBoolean(PreferencesInitializer.LABEL_use_external_solver);
            }

            public String getExternalSolverCommand() {
                return iPreferenceProvider.getString(PreferencesInitializer.LABEL_smt_solver_command);
            }

            public String getPathOfDumpedScript() {
                return iPreferenceProvider.getString(PreferencesInitializer.LABEL_path_of_dumped_script);
            }
        });
    }

    public static TerminationAnalysisSettings getTerminationAnalysisSettings(IUltimateServiceProvider iUltimateServiceProvider) {
        final IPreferenceProvider iPreferenceProvider = iUltimateServiceProvider.getPreferenceProvider(Activator.PLUGIN_ID);
        return new TerminationAnalysisSettings((ITerminationAnalysisSettings)new DefaultTerminationAnalysisSettings(){

            public AnalysisType getAnalysis() {
                return (AnalysisType)iPreferenceProvider.getEnum(PreferencesInitializer.LABEL_termination_analysis, AnalysisType.class);
            }

            public int getNumStrictInvariants() {
                return iPreferenceProvider.getInt(PreferencesInitializer.LABEL_numstrict_invariants);
            }

            public int getNumNonStrictInvariants() {
                return iPreferenceProvider.getInt(PreferencesInitializer.LABEL_numnon_strict_invariants);
            }

            public boolean isNonDecreasingInvariants() {
                return iPreferenceProvider.getBoolean(PreferencesInitializer.LABEL_nondecreasing_invariants);
            }

            public boolean isSimplifyTerminationArgument() {
                return iPreferenceProvider.getBoolean(PreferencesInitializer.LABEL_simplify_result);
            }

            public boolean isSimplifySupportingInvariants() {
                return iPreferenceProvider.getBoolean(PreferencesInitializer.LABEL_simplify_result);
            }
        });
    }

    public static NonTerminationAnalysisSettings getNonTerminationAnalysisSettings(IUltimateServiceProvider iUltimateServiceProvider) {
        final IPreferenceProvider iPreferenceProvider = iUltimateServiceProvider.getPreferenceProvider(Activator.PLUGIN_ID);
        return new NonTerminationAnalysisSettings((INonTerminationAnalysisSettings)new DefaultNonTerminationAnalysisSettings(){

            public AnalysisType getAnalysis() {
                return (AnalysisType)iPreferenceProvider.getEnum(PreferencesInitializer.LABEL_nontermination_analysis, AnalysisType.class);
            }

            public int getNumberOfGevs() {
                return iPreferenceProvider.getInt(PreferencesInitializer.LABEL_nontermination_number_gevs);
            }

            public boolean isNilpotentComponents() {
                return iPreferenceProvider.getBoolean(PreferencesInitializer.LABEL_nontermination_nilpotent_components);
            }

            public boolean isAllowBounded() {
                return iPreferenceProvider.getBoolean(PreferencesInitializer.LABEL_nontermination_bounded_executions);
            }
        });
    }
}

