/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNetSuccessorProvider;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.Marking;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.BoundedPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.ISuccessorTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.SimpleSuccessorTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.SuccessorTransitionProviderSplit;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.DifferenceSynchronizationInformation;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DifferencePetriNet<LETTER, PLACE>
implements IPetriNetSuccessorProvider<LETTER, PLACE> {
    private final AutomataLibraryServices mServices;
    private final IPetriNetSuccessorProvider<LETTER, PLACE> mMinuend;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, PLACE> mSubtrahend;
    private final Map<Transition<LETTER, PLACE>, Transition<LETTER, PLACE>> mNew2Old = new HashMap<Transition<LETTER, PLACE>, Transition<LETTER, PLACE>>();
    private final Map<Transition<LETTER, PLACE>, PLACE> mNewTransition2AutomatonPredecessorState = new HashMap<Transition<LETTER, PLACE>, PLACE>();
    private final HashRelation<Transition<LETTER, PLACE>, PLACE> mBlockingConfigurations = new HashRelation();
    private final Set<PLACE> mMinuendPlaces = new HashSet<PLACE>();
    private final Set<PLACE> mSubtrahendStates = new HashSet<PLACE>();
    private final NestedMap2<Transition<LETTER, PLACE>, PLACE, Transition<LETTER, PLACE>> mInputTransition2State2OutputTransition = new NestedMap2();
    private int mNumberOfConstructedTransitions;
    private final Set<LETTER> mUniversalLoopers;
    private final BoundedPetriNet<LETTER, PLACE> mYetConstructedResult;

    public DifferencePetriNet(AutomataLibraryServices automataLibraryServices, IPetriNetSuccessorProvider<LETTER, PLACE> iPetriNetSuccessorProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, PLACE> iNwaOutgoingLetterAndTransitionProvider, Set<LETTER> set) {
        this.mServices = automataLibraryServices;
        this.mMinuend = iPetriNetSuccessorProvider;
        this.mSubtrahend = iNwaOutgoingLetterAndTransitionProvider;
        this.mUniversalLoopers = set;
        this.mYetConstructedResult = new BoundedPetriNet(this.mServices, this.mMinuend.getAlphabet(), false);
    }

    @Override
    public Set<PLACE> getInitialPlaces() {
        Iterator iterator = this.mSubtrahend.getInitialStates().iterator();
        if (!iterator.hasNext()) {
            throw new UnsupportedOperationException("Subtrahend has no initial states! We could soundly return the minuend as result (implement this if required). However we presume that in most cases, such a subtrahend was passed accidentally");
        }
        HashSet<PLACE> hashSet = new HashSet<PLACE>(this.mMinuend.getInitialPlaces());
        Object STATE = iterator.next();
        hashSet.add(STATE);
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("subtrahend not deterministic");
        }
        if (this.mSubtrahend.isFinal(STATE)) {
            return Collections.emptySet();
        }
        this.addSubtrahendState(STATE);
        for (PLACE PLACE : this.mMinuend.getInitialPlaces()) {
            this.addMinuendPlace(PLACE);
        }
        return hashSet;
    }

    private void addMinuendPlace(PLACE PLACE) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4 = this.mMinuendPlaces.add(PLACE);
        if (bl4 && !(bl3 = this.mYetConstructedResult.addPlace(PLACE, bl2 = this.mMinuend.getInitialPlaces().contains(PLACE), bl = this.mMinuend.isAccepting(PLACE)))) {
            throw new AssertionError((Object)("Must not add place twice: " + String.valueOf(PLACE)));
        }
    }

    private void addSubtrahendState(PLACE PLACE) {
        boolean bl;
        boolean bl2;
        boolean bl3 = this.mSubtrahendStates.add(PLACE);
        if (bl3 && !(bl2 = this.mYetConstructedResult.addPlace(PLACE, bl = this.mSubtrahend.isInitial(PLACE), false))) {
            throw new AssertionError((Object)("Must not add place twice: " + String.valueOf(PLACE)));
        }
    }

    @Override
    public Collection<ISuccessorTransitionProvider<LETTER, PLACE>> getSuccessorTransitionProviders(Set<PLACE> set, Set<PLACE> set2) {
        if (set.isEmpty()) {
            return Collections.emptySet();
        }
        assert (set2.containsAll(set)) : "some must place is not may place";
        Pair<Set<PLACE>, Set<PLACE>> pair = this.split(set);
        Set set3 = (Set)pair.getFirst();
        Set set4 = (Set)pair.getSecond();
        Pair<Set<PLACE>, Set<PLACE>> pair2 = this.split(set2);
        Set set5 = (Set)pair2.getFirst();
        Set set6 = (Set)pair2.getSecond();
        Collection<ISuccessorTransitionProvider<LETTER, PLACE>> collection = set4.isEmpty() ? this.mMinuend.getSuccessorTransitionProviders(set3, set5) : this.mMinuend.getSuccessorTransitionProviders(set5, set5);
        boolean bl = this.mUniversalLoopers != null;
        ArrayList<ISuccessorTransitionProvider<LETTER, PLACE>> arrayList = new ArrayList<ISuccessorTransitionProvider<LETTER, PLACE>>();
        for (ISuccessorTransitionProvider<LETTER, PLACE> iSuccessorTransitionProvider : collection) {
            Iterator iterator;
            Object object;
            SuccessorTransitionProviderSplit<LETTER, PLACE> successorTransitionProviderSplit;
            boolean bl2 = DataStructureUtils.haveEmptyIntersection(iSuccessorTransitionProvider.getPredecessorPlaces(), (Set)set3);
            if (bl) {
                successorTransitionProviderSplit = new SuccessorTransitionProviderSplit<LETTER, PLACE>(iSuccessorTransitionProvider, this.mUniversalLoopers);
                if (successorTransitionProviderSplit.getSuccTransProviderLetterInSet() != null && !bl2) {
                    arrayList.add(new SimpleSuccessorTransitionProviderWithUsageInformation(successorTransitionProviderSplit.getSuccTransProviderLetterInSet().getTransitions()));
                }
                if (successorTransitionProviderSplit.getSuccTransProviderLetterNotInSet() == null) continue;
                object = bl2 ? set4 : set6;
                Iterator iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    iterator = iterator2.next();
                    arrayList.add(new DifferenceSuccessorTransitionProvider(successorTransitionProviderSplit.getSuccTransProviderLetterNotInSet(), iterator));
                }
                continue;
            }
            successorTransitionProviderSplit = bl2 ? set4 : set6;
            iterator = successorTransitionProviderSplit.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                arrayList.add(new DifferenceSuccessorTransitionProvider(iSuccessorTransitionProvider, object));
            }
        }
        return arrayList;
    }

    private Pair<Set<PLACE>, Set<PLACE>> split(Set<PLACE> set) {
        Pair pair = new Pair(new HashSet(), new HashSet());
        for (PLACE PLACE : set) {
            if (this.mMinuendPlaces.contains(PLACE)) {
                ((Set)pair.getFirst()).add(PLACE);
                continue;
            }
            if (!this.mSubtrahendStates.contains(PLACE)) continue;
            ((Set)pair.getSecond()).add(PLACE);
        }
        return pair;
    }

    @Override
    public boolean isAccepting(Marking<PLACE> marking) {
        Object object2;
        HashSet<PLACE> hashSet = new HashSet<PLACE>();
        for (Object object2 : marking) {
            if (!this.mMinuendPlaces.contains(object2)) continue;
            hashSet.add(object2);
        }
        object2 = new Marking(ImmutableSet.of(hashSet));
        return this.mMinuend.isAccepting(object2);
    }

    public BoundedPetriNet<LETTER, PLACE> getYetConstructedPetriNet() {
        return this.mYetConstructedResult;
    }

    public Map<Transition<LETTER, PLACE>, Transition<LETTER, PLACE>> getTransitionBacktranslation() {
        return Collections.unmodifiableMap(this.mNew2Old);
    }

    @Override
    public Set<LETTER> getAlphabet() {
        return this.mMinuend.getAlphabet();
    }

    @Override
    public int size() {
        return -1;
    }

    @Override
    public String sizeInformation() {
        return "will be constructed on-demand";
    }

    @Override
    public IElement transformToUltimateModel(AutomataLibraryServices automataLibraryServices) throws AutomataOperationCanceledException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAccepting(PLACE PLACE) {
        if (this.mSubtrahendStates.contains(PLACE)) {
            return false;
        }
        return this.mMinuend.isAccepting(PLACE);
    }

    public DifferenceSynchronizationInformation<LETTER, PLACE> computeDifferenceSynchronizationInformation() {
        return this.computeDifferenceSynchronizationInformation(this.mNew2Old.keySet(), false);
    }

    public DifferenceSynchronizationInformation<LETTER, PLACE> computeDifferenceSynchronizationInformation(Set<Transition<LETTER, PLACE>> set, boolean bl) {
        HashSet<LETTER> hashSet = new HashSet<LETTER>();
        HashRelation hashRelation = new HashRelation();
        HashRelation hashRelation2 = new HashRelation();
        HashRelation hashRelation3 = new HashRelation();
        HashSet hashSet2 = new HashSet();
        for (Transition<LETTER, PLACE> transition : this.mNew2Old.keySet()) {
            Transition<LETTER, PLACE> transition2 = this.mNew2Old.get(transition);
            assert (transition2 != null) : "Unknown transition: " + String.valueOf(transition);
            PLACE PLACE = this.mNewTransition2AutomatonPredecessorState.get(transition);
            if (PLACE == null) {
                if (!set.contains(transition)) continue;
                hashSet2.add(transition2);
                continue;
            }
            PLACE PLACE2 = NestedWordAutomataUtils.getSuccessorState(this.mSubtrahend, PLACE, transition.getSymbol());
            boolean bl2 = PLACE.equals(PLACE2);
            if (!set.contains(transition)) {
                if (bl2) continue;
                hashRelation3.addPair(transition2, PLACE);
                hashSet.add(transition2.getSymbol());
                continue;
            }
            hashSet2.add(transition2);
            if (bl2) {
                hashRelation.addPair(transition2, PLACE);
                continue;
            }
            hashRelation2.addPair(transition2, PLACE);
            hashSet.add(transition2.getSymbol());
        }
        hashRelation3.addAll(this.mBlockingConfigurations);
        for (Transition<LETTER, PLACE> transition : this.mBlockingConfigurations.getDomain()) {
            hashSet.add(transition.getSymbol());
        }
        return new DifferenceSynchronizationInformation(hashSet, hashRelation, hashRelation2, hashSet2, hashRelation3, true, bl);
    }

    private class DifferenceSuccessorTransitionProvider
    implements ISuccessorTransitionProvider<LETTER, PLACE> {
        private final ISuccessorTransitionProvider<LETTER, PLACE> mPetriNetPredecessors;
        private final PLACE mAutomatonPredecessor;
        private final ImmutableSet<PLACE> mAllPredecessors;

        public DifferenceSuccessorTransitionProvider(ISuccessorTransitionProvider<LETTER, PLACE> iSuccessorTransitionProvider, PLACE PLACE) {
            this.mPetriNetPredecessors = iSuccessorTransitionProvider;
            this.mAutomatonPredecessor = PLACE;
            LinkedHashSet linkedHashSet = new LinkedHashSet(iSuccessorTransitionProvider.getPredecessorPlaces());
            linkedHashSet.add(PLACE);
            this.mAllPredecessors = ImmutableSet.of(linkedHashSet);
        }

        @Override
        public Set<PLACE> getPredecessorPlaces() {
            return this.mAllPredecessors;
        }

        @Override
        public Collection<Transition<LETTER, PLACE>> getTransitions() {
            ArrayList arrayList = new ArrayList();
            for (Transition transition : this.mPetriNetPredecessors.getTransitions()) {
                Transition transition2 = this.getOrConstructTransition(transition, this.mAutomatonPredecessor);
                if (transition2 == null) continue;
                arrayList.add(transition2);
            }
            return arrayList;
        }

        private Transition<LETTER, PLACE> getOrConstructTransition(Transition<LETTER, PLACE> transition, PLACE PLACE) {
            Transition transition2 = (Transition)DifferencePetriNet.this.mInputTransition2State2OutputTransition.get(transition, PLACE);
            if (transition2 == null) {
                Object PLACE2 = NestedWordAutomataUtils.getSuccessorState(DifferencePetriNet.this.mSubtrahend, PLACE, transition.getSymbol());
                if (DifferencePetriNet.this.mSubtrahend.isFinal(PLACE2)) {
                    DifferencePetriNet.this.mBlockingConfigurations.addPair(transition, PLACE);
                    return null;
                }
                LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
                for (Object e : transition.getSuccessors()) {
                    DifferencePetriNet.this.addMinuendPlace(e);
                    linkedHashSet.add(e);
                }
                DifferencePetriNet.this.addSubtrahendState(PLACE2);
                linkedHashSet.add(PLACE2);
                int n = DifferencePetriNet.this.mNumberOfConstructedTransitions++;
                transition2 = DifferencePetriNet.this.mYetConstructedResult.addTransition(transition.getSymbol(), this.mAllPredecessors, ImmutableSet.of(linkedHashSet), n);
                DifferencePetriNet.this.mInputTransition2State2OutputTransition.put(transition, PLACE, transition2);
                DifferencePetriNet.this.mNewTransition2AutomatonPredecessorState.put(transition2, PLACE);
                Transition transition3 = DifferencePetriNet.this.mNew2Old.put(transition2, transition);
                assert (transition3 == null) : "Cannot add transition twice.";
            }
            return transition2;
        }
    }

    private class SimpleSuccessorTransitionProviderWithUsageInformation
    extends SimpleSuccessorTransitionProvider<LETTER, PLACE> {
        public SimpleSuccessorTransitionProviderWithUsageInformation(Collection<Transition<LETTER, PLACE>> collection) {
            super(collection);
        }

        @Override
        public Collection<Transition<LETTER, PLACE>> getTransitions() {
            ArrayList arrayList = new ArrayList();
            for (Transition transition : super.getTransitions()) {
                Transition transition2 = this.getOrConstructTransitionCopy(transition);
                arrayList.add(transition2);
            }
            return arrayList;
        }

        private Transition<LETTER, PLACE> getOrConstructTransitionCopy(Transition<LETTER, PLACE> transition) {
            Transition transition2 = (Transition)DifferencePetriNet.this.mInputTransition2State2OutputTransition.get(transition, null);
            if (transition2 == null) {
                LinkedHashSet linkedHashSet = new LinkedHashSet();
                for (Object e : transition.getSuccessors()) {
                    DifferencePetriNet.this.addMinuendPlace(e);
                    linkedHashSet.add(e);
                }
                int n = DifferencePetriNet.this.mNumberOfConstructedTransitions++;
                transition2 = DifferencePetriNet.this.mYetConstructedResult.addTransition(transition.getSymbol(), transition.getPredecessors(), ImmutableSet.of(linkedHashSet), n);
                DifferencePetriNet.this.mInputTransition2State2OutputTransition.put(transition, null, transition2);
                Transition transition3 = DifferencePetriNet.this.mNew2Old.put(transition2, transition);
                assert (transition3 == null) : "Cannot add transition twice.";
            }
            return transition2;
        }
    }
}

