/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithSeverity;

public class AutomataScriptInterpreterOverallResult
extends AbstractResult
implements IResultWithSeverity {
    private final OverallResult mOverallResult;
    private final String mErrorMessage;

    public AutomataScriptInterpreterOverallResult(String string, OverallResult overallResult, String string2) {
        super(string);
        if (string2 == null && overallResult == OverallResult.EXCEPTION_OR_ERROR) {
            throw new UnsupportedOperationException("provide error message if there was an error");
        }
        if (string2 != null && overallResult != OverallResult.EXCEPTION_OR_ERROR && overallResult != OverallResult.TIMEOUT) {
            throw new UnsupportedOperationException("provide error message only if there was an error or timeout");
        }
        this.mOverallResult = overallResult;
        this.mErrorMessage = string2;
    }

    public String getShortDescription() {
        return switch (this.mOverallResult) {
            case OverallResult.ALL_ASSERTIONS_HOLD -> "Finished interpretation of automata script.";
            case OverallResult.EXCEPTION_OR_ERROR -> "Interpretation of automata script failed.";
            case OverallResult.NO_ASSERTION -> "Finished interpretation of automata script.";
            case OverallResult.SOME_ASSERTION_FAILED -> "Some assert statements have been evaluated to false.";
            case OverallResult.TIMEOUT -> "Timeout during interpretation of automata script.";
            case OverallResult.OUT_OF_MEMORY -> "Run out of memory during interpretation of automata script.";
            default -> throw new MatchException(null, null);
        };
    }

    public String getLongDescription() {
        switch (this.mOverallResult) {
            case ALL_ASSERTIONS_HOLD: {
                return "All assert statements have been evaluated to true.";
            }
            case NO_ASSERTION: {
                return " You have not used any assert statement in your automata script. Assert statements can be used to check Boolean results.";
            }
        }
        return this.getShortDescription();
    }

    public IResultWithSeverity.Severity getSeverity() {
        return switch (this.mOverallResult) {
            case OverallResult.ALL_ASSERTIONS_HOLD -> IResultWithSeverity.Severity.INFO;
            case OverallResult.EXCEPTION_OR_ERROR -> IResultWithSeverity.Severity.ERROR;
            case OverallResult.NO_ASSERTION -> IResultWithSeverity.Severity.INFO;
            case OverallResult.SOME_ASSERTION_FAILED -> IResultWithSeverity.Severity.ERROR;
            case OverallResult.TIMEOUT -> IResultWithSeverity.Severity.WARNING;
            case OverallResult.OUT_OF_MEMORY -> IResultWithSeverity.Severity.WARNING;
            default -> throw new MatchException(null, null);
        };
    }

    public OverallResult getOverallResult() {
        return this.mOverallResult;
    }

    public String getErrorMessage() {
        if (this.mErrorMessage == null) {
            throw new UnsupportedOperationException("there is no error message, because there was no error");
        }
        return this.mErrorMessage;
    }

    public static enum OverallResult {
        ALL_ASSERTIONS_HOLD,
        NO_ASSERTION,
        SOME_ASSERTION_FAILED,
        EXCEPTION_OR_ERROR,
        TIMEOUT,
        OUT_OF_MEMORY;

    }
}

