/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IEpsilonNestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IOutgoingTransitionlet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.CachingHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.ChainingHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.NwaHoareProofProducer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.NwaCegarLoop;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryRefinement;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateParsingWrapperScript;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.transitionappender.AbstractInterpolantAutomaton;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TAPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TraceAbstractionPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.TermParseUtils;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.statistics.Benchmark;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsElement;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsData;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;

public class ReuseCegarLoop<L extends IIcfgTransition<?>>
extends NwaCegarLoop<L> {
    public static boolean USE_AUTOMATA_WITH_UNMATCHED_PREDICATES = false;
    protected final List<Pair<AbstractInterpolantAutomaton<L>, IPredicateUnifier>> mFloydHoareAutomataFromOtherErrorLocations;
    protected final List<INestedWordAutomaton<String, String>> mRawFloydHoareAutomataFromFile;
    protected List<ReuseAutomaton> mFloydHoareAutomataFromFile;
    protected final ReuseStatisticsGenerator mReuseStats;
    private boolean mStatsAlreadyAggregated = false;

    public ReuseCegarLoop(DebugIdentifier debugIdentifier, INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, IIcfg<?> iIcfg, CfgSmtToolkit cfgSmtToolkit, PredicateFactory predicateFactory, TAPreferences tAPreferences, Set<? extends IcfgLocation> set, NwaHoareProofProducer<L> nwaHoareProofProducer, IUltimateServiceProvider iUltimateServiceProvider, List<Pair<AbstractInterpolantAutomaton<L>, IPredicateUnifier>> list, List<INestedWordAutomaton<String, String>> list2, Class<L> clazz, PredicateFactoryRefinement predicateFactoryRefinement) {
        super(debugIdentifier, iNestedWordAutomaton, iIcfg, cfgSmtToolkit, predicateFactory, tAPreferences, set, nwaHoareProofProducer, iUltimateServiceProvider, clazz, predicateFactoryRefinement);
        this.mFloydHoareAutomataFromOtherErrorLocations = list;
        this.mRawFloydHoareAutomataFromFile = list2;
        this.mFloydHoareAutomataFromFile = new ArrayList<ReuseAutomaton>();
        this.mReuseStats = new ReuseStatisticsGenerator();
    }

    @Override
    protected void initialize() throws AutomataLibraryException {
        super.initialize();
        this.mLogger.info((Object)("Constructing FH automata from " + this.mRawFloydHoareAutomataFromFile.size() + " parsed reuse automata"));
        this.mReuseStats.continueTime();
        PredicateParsingWrapperScript predicateParsingWrapperScript = new PredicateParsingWrapperScript(this.mCsToolkit);
        for (INestedWordAutomaton<String, String> iNestedWordAutomaton : this.mRawFloydHoareAutomataFromFile) {
            if (iNestedWordAutomaton.getFinalStates().isEmpty()) {
                throw new AssertionError((Object)"A Floyd-Hoare automaton without accepting states is useless.");
            }
            this.buildFloydHoareAutomaton(predicateParsingWrapperScript, iNestedWordAutomaton);
        }
        this.mReuseStats.addAutomataFromPreviousErrorLocation(this.mFloydHoareAutomataFromOtherErrorLocations.size());
        this.mReuseStats.stopTime();
    }

    private void buildFloydHoareAutomaton(PredicateParsingWrapperScript predicateParsingWrapperScript, INestedWordAutomaton<String, String> iNestedWordAutomaton) {
        Object object;
        Pair<HashRelation<String, String>, HashRelation<String, String>> pair;
        Object object2;
        HashMap<String, Set<L>> hashMap = new HashMap<String, Set<L>>();
        VpAlphabet vpAlphabet = ((INestedWordAutomaton)this.mAbstraction).getVpAlphabet();
        ReuseCegarLoop.addLettersToStringMap(hashMap, vpAlphabet.getCallAlphabet());
        ReuseCegarLoop.addLettersToStringMap(hashMap, vpAlphabet.getInternalAlphabet());
        ReuseCegarLoop.addLettersToStringMap(hashMap, vpAlphabet.getReturnAlphabet());
        this.countReusedAndRemovedLetters((VpAlphabet<String>)iNestedWordAutomaton.getVpAlphabet(), hashMap);
        NestedWordAutomaton nestedWordAutomaton = new NestedWordAutomaton(new AutomataLibraryServices(this.getServices()), vpAlphabet, (IEmptyStackStateFactory)this.mPredicateFactoryInterpolantAutomata);
        PredicateUnifier predicateUnifier = new PredicateUnifier(this.mLogger, this.getServices(), this.mCsToolkit.getManagedScript(), (BasicPredicateFactory)this.mPredicateFactory, this.mCsToolkit.getSymbolTable(), SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, new IPredicate[0]);
        boolean bl = iNestedWordAutomaton instanceof IEpsilonNestedWordAutomaton;
        if (bl) {
            object2 = (IEpsilonNestedWordAutomaton)iNestedWordAutomaton;
            pair = ReuseCegarLoop.constructImpliesExpliesStrings((IEpsilonNestedWordAutomaton<String, String>)object2);
        } else {
            pair = null;
        }
        object2 = iNestedWordAutomaton.getStates();
        HashMap<String, Term> hashMap2 = new HashMap<String, Term>();
        HashMap<Term, String> hashMap3 = new HashMap<Term, String>();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            object = this.parseTerm(predicateParsingWrapperScript, string);
            if (object == null) continue;
            hashMap2.put(string, (Term)object);
            hashMap3.put((Term)object, string);
        }
        int n = hashMap3.size();
        int n2 = object2.size() - n;
        object = new HashMap();
        HashMap<IPredicate, String> hashMap4 = new HashMap<IPredicate, String>();
        IPredicate object32 = predicateUnifier.getTruePredicate();
        Object object3 = (String)hashMap3.get(object32.getFormula());
        this.addState(iNestedWordAutomaton, nestedWordAutomaton, (HashMap<String, IPredicate>)object, hashMap4, object32, (String)object3);
        IPredicate n3 = predicateUnifier.getFalsePredicate();
        object3 = (String)hashMap3.get(n3.getFormula());
        this.addState(iNestedWordAutomaton, nestedWordAutomaton, (HashMap<String, IPredicate>)object, hashMap4, n3, (String)object3);
        for (Map.Entry entry : hashMap3.entrySet()) {
            IPredicate iPredicate;
            String string = (String)entry.getValue();
            Term term = (Term)entry.getKey();
            if (term == predicateUnifier.getTruePredicate().getFormula() || term == predicateUnifier.getFalsePredicate().getFormula()) continue;
            if (bl) {
                Pair<HashMap<IPredicate, IncrementalPlicationChecker.Validity>, HashMap<IPredicate, IncrementalPlicationChecker.Validity>> pair2 = ReuseCegarLoop.constructImpliesExpliesRelations(nestedWordAutomaton.getStates(), string, hashMap4, pair);
                iPredicate = predicateUnifier.constructNewPredicate(term, (Map)pair2.getFirst(), (Map)pair2.getSecond());
            } else {
                iPredicate = predicateUnifier.getOrConstructPredicate(term);
            }
            this.addState(iNestedWordAutomaton, nestedWordAutomaton, (HashMap<String, IPredicate>)object, hashMap4, iPredicate, string);
        }
        int n4 = n2 + n;
        if (!USE_AUTOMATA_WITH_UNMATCHED_PREDICATES && n2 > 0) {
            this.mReuseStats.addDroppedAutomata(1);
            return;
        }
        this.mReuseStats.addReusedStates(n);
        this.mReuseStats.addUselessPredicates(n2);
        this.mReuseStats.addTotalStates(n4);
        this.addTransitionsFromRawAutomaton(nestedWordAutomaton, iNestedWordAutomaton, hashMap, (Map<String, IPredicate>)object, hashMap4);
        object3 = new ReuseAutomaton(nestedWordAutomaton, vpAlphabet, (IPredicateUnifier)predicateUnifier);
        this.mFloydHoareAutomataFromFile.add((ReuseAutomaton)object3);
        this.mReuseStats.addAutomataFromFile(1);
    }

    private void addState(INestedWordAutomaton<String, String> iNestedWordAutomaton, NestedWordAutomaton<L, IPredicate> nestedWordAutomaton, HashMap<String, IPredicate> hashMap, HashMap<IPredicate, String> hashMap2, IPredicate iPredicate, String string) {
        hashMap.put(string, iPredicate);
        hashMap2.put(iPredicate, string);
        boolean bl = iNestedWordAutomaton.isInitial((Object)string);
        boolean bl2 = iNestedWordAutomaton.isFinal((Object)string);
        nestedWordAutomaton.addState(bl, bl2, (Object)iPredicate);
    }

    private static Pair<HashMap<IPredicate, IncrementalPlicationChecker.Validity>, HashMap<IPredicate, IncrementalPlicationChecker.Validity>> constructImpliesExpliesRelations(Set<IPredicate> set, String string, HashMap<IPredicate, String> hashMap, Pair<HashRelation<String, String>, HashRelation<String, String>> pair) {
        HashRelation hashRelation = (HashRelation)pair.getFirst();
        HashRelation hashRelation2 = (HashRelation)pair.getSecond();
        HashMap<IPredicate, IncrementalPlicationChecker.Validity> hashMap2 = new HashMap<IPredicate, IncrementalPlicationChecker.Validity>();
        HashMap<IPredicate, IncrementalPlicationChecker.Validity> hashMap3 = new HashMap<IPredicate, IncrementalPlicationChecker.Validity>();
        for (IPredicate iPredicate : set) {
            String string2 = hashMap.get(iPredicate);
            if (hashRelation.containsPair((Object)string, (Object)string2)) {
                hashMap2.put(iPredicate, IncrementalPlicationChecker.Validity.VALID);
            } else {
                hashMap2.put(iPredicate, IncrementalPlicationChecker.Validity.INVALID);
            }
            if (hashRelation2.containsPair((Object)string, (Object)string2)) {
                hashMap3.put(iPredicate, IncrementalPlicationChecker.Validity.VALID);
                continue;
            }
            hashMap3.put(iPredicate, IncrementalPlicationChecker.Validity.INVALID);
        }
        return new Pair(hashMap2, hashMap3);
    }

    private static Pair<HashRelation<String, String>, HashRelation<String, String>> constructImpliesExpliesStrings(IEpsilonNestedWordAutomaton<String, String> iEpsilonNestedWordAutomaton) {
        String string2;
        HashRelation hashRelation = new HashRelation();
        HashRelation hashRelation2 = new HashRelation();
        for (String string2 : iEpsilonNestedWordAutomaton.getStates()) {
            for (String string3 : iEpsilonNestedWordAutomaton.epsilonSuccessors((Object)string2)) {
                hashRelation.addPair((Object)string2, (Object)string3);
                hashRelation2.addPair((Object)string3, (Object)string2);
            }
        }
        string2 = new Pair((Object)hashRelation, (Object)hashRelation2);
        return string2;
    }

    @Override
    public IStatisticsDataProvider getCegarLoopBenchmark() {
        assert (!this.mStatsAlreadyAggregated);
        this.mStatsAlreadyAggregated = true;
        this.mFloydHoareAutomataFromFile.forEach(reuseAutomaton -> {
            this.mReuseStats.reportHtcStats(reuseAutomaton.getEdgeCheckerBenchmark());
            this.mReuseStats.reportPredicateUnifierStats(reuseAutomaton.getPredicateUnifier().getPredicateUnifierBenchmark());
        });
        this.mCegarLoopBenchmark.addReuseStats(this.mReuseStats);
        return super.getCegarLoopBenchmark();
    }

    private static final <LETTER> void addLettersToStringMap(Map<String, Set<LETTER>> map, Set<LETTER> set) {
        for (LETTER LETTER : set) {
            String string = LETTER.toString();
            Set<LETTER> set2 = map.get(string);
            if (set2 == null) {
                HashSet<LETTER> hashSet = new HashSet<LETTER>();
                hashSet.add(LETTER);
                map.put(string, hashSet);
                continue;
            }
            set2.add(LETTER);
        }
    }

    private final void countReusedAndRemovedLetters(VpAlphabet<String> vpAlphabet, Map<String, Set<L>> map) {
        int n = 0;
        int n2 = 0;
        HashSet hashSet = new HashSet(vpAlphabet.getInternalAlphabet());
        hashSet.addAll(vpAlphabet.getReturnAlphabet());
        hashSet.addAll(vpAlphabet.getCallAlphabet());
        for (String string : hashSet) {
            if (map.containsKey(string)) {
                ++n2;
                continue;
            }
            ++n;
        }
        int n3 = n + n2;
        this.mReuseStats.addReusedLetters(n2);
        this.mReuseStats.addTotalLetters(n3);
    }

    private final void addTransitionsFromRawAutomaton(NestedWordAutomaton<L, IPredicate> nestedWordAutomaton, INestedWordAutomaton<String, String> iNestedWordAutomaton, Map<String, Set<L>> map, Map<String, IPredicate> map2, Map<IPredicate, String> map3) {
        int n = 0;
        int n2 = 0;
        Set set = nestedWordAutomaton.getStates();
        for (IPredicate iPredicate : set) {
            Pair<Set<L>, IPredicate> pair;
            String string = map3.get(iPredicate);
            for (OutgoingCallTransition outgoingCallTransition : iNestedWordAutomaton.callSuccessors((Object)string)) {
                pair = this.filterTransitions((IOutgoingTransitionlet<String, String>)outgoingCallTransition, map, map2, set);
                if (pair == null) {
                    ++n;
                    continue;
                }
                for (IIcfgTransition iIcfgTransition : (Set)pair.getFirst()) {
                    nestedWordAutomaton.addCallTransition((Object)iPredicate, (Object)iIcfgTransition, (Object)((IPredicate)pair.getSecond()));
                    ++n2;
                }
            }
            for (OutgoingCallTransition outgoingCallTransition : iNestedWordAutomaton.internalSuccessors((Object)string)) {
                pair = this.filterTransitions((IOutgoingTransitionlet<String, String>)outgoingCallTransition, map, map2, set);
                if (pair == null) {
                    ++n;
                    continue;
                }
                for (IIcfgTransition iIcfgTransition : (Set)pair.getFirst()) {
                    nestedWordAutomaton.addInternalTransition((Object)iPredicate, (Object)iIcfgTransition, (Object)((IPredicate)pair.getSecond()));
                    ++n2;
                }
            }
            for (OutgoingCallTransition outgoingCallTransition : iNestedWordAutomaton.returnSuccessors((Object)string)) {
                IIcfgTransition iIcfgTransition;
                pair = this.filterTransitions((IOutgoingTransitionlet<String, String>)outgoingCallTransition, map, map2, set);
                if (pair == null) {
                    ++n;
                    continue;
                }
                iIcfgTransition = map2.get(outgoingCallTransition.getHierPred());
                if (!set.contains(iIcfgTransition)) {
                    ++n;
                    continue;
                }
                for (IIcfgTransition iIcfgTransition2 : (Set)pair.getFirst()) {
                    nestedWordAutomaton.addReturnTransition((Object)iPredicate, (Object)iIcfgTransition, (Object)iIcfgTransition2, (Object)((IPredicate)pair.getSecond()));
                    ++n2;
                }
            }
        }
        int n3 = n + n2;
        this.mReuseStats.addReusedTransitions(n2);
        this.mReuseStats.addTotalTransitions(n3);
    }

    private Pair<Set<L>, IPredicate> filterTransitions(IOutgoingTransitionlet<String, String> iOutgoingTransitionlet, Map<String, Set<L>> map, Map<String, IPredicate> map2, Set<IPredicate> set) {
        Set<L> set2 = map.get(iOutgoingTransitionlet.getLetter());
        if (set2 == null) {
            return null;
        }
        String string = (String)iOutgoingTransitionlet.getSucc();
        IPredicate iPredicate = map2.get(string);
        if (!set.contains(iPredicate)) {
            return null;
        }
        return new Pair(set2, (Object)iPredicate);
    }

    private Term parseTerm(PredicateParsingWrapperScript predicateParsingWrapperScript, String string) {
        Term term;
        try {
            String string2 = this.removeSerialNumber(string);
            term = TermParseUtils.parseTerm((Script)predicateParsingWrapperScript, (String)string2);
        }
        catch (Exception exception) {
            this.mLogger.warn((Object)("Exception during parsing of " + string + ": " + exception.getMessage()));
            return null;
        }
        return term;
    }

    private String removeSerialNumber(String string) {
        String[] stringArray = string.split("#", 2);
        if (stringArray.length == 1) {
            this.mLogger.warn((Object)("String " + string + " doesn't have a # symbol in it. Kepping entire string."));
            return stringArray[0];
        }
        if (stringArray.length == 2) {
            return stringArray[1];
        }
        this.mLogger.warn((Object)"Unexpected result from String's split function. String parsing failed.");
        throw new UnsupportedOperationException("String parsing failed");
    }

    public final class ReuseAutomaton {
        private final boolean mUseEnhancement;
        private final IPredicateUnifier mPredicateUnifier;
        private final NestedWordAutomaton<L, IPredicate> mAutomaton;
        private final VpAlphabet<L> mAbstractionAlphabet;
        private AbstractInterpolantAutomaton<L> mEnhancedAutomaton;
        private IHoareTripleChecker mHtc;

        private ReuseAutomaton(NestedWordAutomaton<L, IPredicate> nestedWordAutomaton, VpAlphabet<L> vpAlphabet, IPredicateUnifier iPredicateUnifier) {
            this.mPredicateUnifier = iPredicateUnifier;
            this.mAutomaton = nestedWordAutomaton;
            this.mAbstractionAlphabet = vpAlphabet;
            this.mUseEnhancement = ReuseCegarLoop.this.mPref.getFloydHoareAutomataReuseEnhancement() != TraceAbstractionPreferenceInitializer.FloydHoareAutomataReuseEnhancement.NONE;
        }

        public INwaOutgoingLetterAndTransitionProvider<L, IPredicate> getAutomaton() {
            if (this.mUseEnhancement) {
                return this.getEnhancedInterpolantAutomaton();
            }
            return this.mAutomaton;
        }

        public IHoareTripleChecker getHtc() {
            if (!this.mUseEnhancement) {
                throw new UnsupportedOperationException("You should not need a Hoare Triple Checker in this mode");
            }
            if (this.mHtc == null) {
                this.mHtc = this.constructHtc();
            }
            return this.mHtc;
        }

        private IHoareTripleChecker constructHtc() {
            TraceAbstractionPreferenceInitializer.FloydHoareAutomataReuseEnhancement floydHoareAutomataReuseEnhancement = ReuseCegarLoop.this.mPref.getFloydHoareAutomataReuseEnhancement();
            return switch (floydHoareAutomataReuseEnhancement) {
                case TraceAbstractionPreferenceInitializer.FloydHoareAutomataReuseEnhancement.AS_USUAL -> HoareTripleCheckerUtils.constructEfficientHoareTripleCheckerWithCaching((IUltimateServiceProvider)ReuseCegarLoop.this.getServices(), (HoareTripleCheckerUtils.HoareTripleChecks)ReuseCegarLoop.this.mPref.getHoareTripleChecks(), (CfgSmtToolkit)ReuseCegarLoop.this.mCsToolkit, (IPredicateUnifier)this.getPredicateUnifier());
                case TraceAbstractionPreferenceInitializer.FloydHoareAutomataReuseEnhancement.ONLY_NEW_LETTERS -> this.constructEfficientIgnoringHtc(false);
                case TraceAbstractionPreferenceInitializer.FloydHoareAutomataReuseEnhancement.ONLY_NEW_LETTERS_SOLVER -> this.constructEfficientIgnoringHtc(true);
                case TraceAbstractionPreferenceInitializer.FloydHoareAutomataReuseEnhancement.NONE -> throw new UnsupportedOperationException("Illegal mode: " + String.valueOf((Object)floydHoareAutomataReuseEnhancement));
                default -> throw new MatchException(null, null);
            };
        }

        private IHoareTripleChecker constructEfficientIgnoringHtc(boolean bl) throws AssertionError {
            Set set = this.constructOldAlphabet();
            Predicate<IAction> predicate = set::contains;
            ChainingHoareTripleChecker chainingHoareTripleChecker = HoareTripleCheckerUtils.constructSdHoareTripleChecker((ILogger)ReuseCegarLoop.this.mLogger, (CfgSmtToolkit)ReuseCegarLoop.this.mCsToolkit, (IPredicateUnifier)this.getPredicateUnifier());
            if (!bl) {
                chainingHoareTripleChecker = chainingHoareTripleChecker.actionsProtectedBy(predicate);
            }
            chainingHoareTripleChecker = chainingHoareTripleChecker.andThen((IHoareTripleChecker)HoareTripleCheckerUtils.constructSmtHoareTripleChecker((ILogger)ReuseCegarLoop.this.mLogger, (HoareTripleCheckerUtils.HoareTripleChecks)HoareTripleCheckerUtils.HoareTripleChecks.INCREMENTAL, (CfgSmtToolkit)ReuseCegarLoop.this.mCsToolkit, (IPredicateUnifier)this.getPredicateUnifier()));
            return new CachingHoareTripleChecker(ReuseCegarLoop.this.getServices(), (IHoareTripleChecker)chainingHoareTripleChecker, this.getPredicateUnifier());
        }

        private Set<L> constructOldAlphabet() {
            return DataStructureUtils.union((Set[])new Set[]{DataStructureUtils.intersection((Set)this.mAbstractionAlphabet.getInternalAlphabet(), (Set)this.mAutomaton.getVpAlphabet().getInternalAlphabet()), DataStructureUtils.intersection((Set)this.mAbstractionAlphabet.getCallAlphabet(), (Set)this.mAutomaton.getVpAlphabet().getCallAlphabet()), DataStructureUtils.intersection((Set)this.mAbstractionAlphabet.getReturnAlphabet(), (Set)this.mAutomaton.getVpAlphabet().getReturnAlphabet())});
        }

        public IStatisticsDataProvider getEdgeCheckerBenchmark() {
            if (this.mHtc == null) {
                return new HoareTripleCheckerStatisticsGenerator();
            }
            return this.mHtc.getStatistics();
        }

        public IPredicateUnifier getPredicateUnifier() {
            return this.mPredicateUnifier;
        }

        private INwaOutgoingLetterAndTransitionProvider<L, IPredicate> getEnhancedInterpolantAutomaton() {
            if (this.mEnhancedAutomaton == null) {
                this.mEnhancedAutomaton = ReuseCegarLoop.this.constructInterpolantAutomatonForOnDemandEnhancement(this.mAutomaton, this.getPredicateUnifier(), this.getHtc(), TAPreferences.InterpolantAutomatonEnhancement.PREDICATE_ABSTRACTION);
            }
            return this.mEnhancedAutomaton;
        }
    }

    public static enum ReuseStatisticsDefinitions implements IStatisticsElement
    {
        REUSED_STATES(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        TOTAL_STATES(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        REUSED_LETTERS(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        TOTAL_LETTERS(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        REUSED_TRANSITIONS(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        TOTAL_TRANSITIONS(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        BEFORE_DIFF_TRANS(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        AFTER_DIFF_TRANS(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        BEFORE_ACCEPT_TRANS(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        AFTER_ACCEPT_TRANS(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        USELESS_PREDICATES(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        NONREUSE_ITERATIONS(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        AUTOMATA_FROM_FILE(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        AUTOMATA_FROM_PREV_ERROR_LOC(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        REUSE_PREDICATE_UNIFIER(IStatisticsDataProvider.class, StatisticsType.STATISTICS_DATA_AGGREGATION, StatisticsType.KEY_BEFORE_DATA),
        REUSE_HTC(IStatisticsDataProvider.class, StatisticsType.STATISTICS_DATA_AGGREGATION, StatisticsType.KEY_BEFORE_DATA),
        REUSE_TIME(Integer.class, StatisticsType.LONG_ADDITION, StatisticsType.KEY_BEFORE_NANOS),
        DROPPED_AUTOMATA(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA);

        private final Class<?> mClazz;
        private final Function<Object, Function<Object, Object>> mAggr;
        private final Function<String, Function<Object, String>> mPrettyprinter;

        private ReuseStatisticsDefinitions(Class<?> clazz, Function<Object, Function<Object, Object>> function, Function<String, Function<Object, String>> function2) {
            this.mClazz = clazz;
            this.mAggr = function;
            this.mPrettyprinter = function2;
        }

        public Object aggregate(Object object, Object object2) {
            return this.mAggr.apply(object).apply(object2);
        }

        public String prettyprint(Object object) {
            return this.mPrettyprinter.apply(CoreUtil.getUpperToCamelCase((String)this.name())).apply(object);
        }
    }

    public static final class ReuseStatisticsGenerator
    implements IStatisticsDataProvider {
        private final StatisticsData mPredicateUnifierStats = new StatisticsData();
        private final Benchmark mTime;
        private final StatisticsData mHtcStats = new StatisticsData();
        private boolean mRunning = false;
        private int mAutomataFromFile;
        private int mAutomataFromPreviousErrorLocation;
        private int mReusedStates;
        private int mTotalStates;
        private int mReusedLetters;
        private int mTotalLetters;
        private int mReusedTransitions;
        private int mTotalTransitions;
        private int mNonReuseIterations;
        private int mBeforeDiffTransitions;
        private int mAfterDiffTransitions;
        private int mBeforeAcceptanceTransitions;
        private int mAfterAcceptanceTransitions;
        private int mUselessPredicates;
        private int mDroppedAutomata;

        public ReuseStatisticsGenerator() {
            this.mTime = new Benchmark();
            this.mTime.register(String.valueOf((Object)ReuseStatisticsDefinitions.REUSE_TIME));
            this.mAutomataFromFile = 0;
            this.mAutomataFromPreviousErrorLocation = 0;
            this.mReusedStates = 0;
            this.mTotalStates = 0;
            this.mReusedLetters = 0;
            this.mTotalLetters = 0;
            this.mReusedTransitions = 0;
            this.mTotalTransitions = 0;
            this.mNonReuseIterations = 0;
            this.mBeforeDiffTransitions = 0;
            this.mAfterDiffTransitions = 0;
            this.mBeforeAcceptanceTransitions = 0;
            this.mAfterAcceptanceTransitions = 0;
            this.mUselessPredicates = 0;
            this.mDroppedAutomata = 0;
        }

        public void reportPredicateUnifierStats(IStatisticsDataProvider iStatisticsDataProvider) {
            this.mPredicateUnifierStats.aggregateBenchmarkData(iStatisticsDataProvider);
        }

        public void reportHtcStats(IStatisticsDataProvider iStatisticsDataProvider) {
            this.mHtcStats.aggregateBenchmarkData(iStatisticsDataProvider);
        }

        public void addAutomataFromFile(int n) {
            this.mAutomataFromFile += n;
        }

        public void addAutomataFromPreviousErrorLocation(int n) {
            this.mAutomataFromPreviousErrorLocation += n;
        }

        public void addTotalStates(int n) {
            this.mTotalStates += n;
        }

        public void addReusedStates(int n) {
            this.mReusedStates += n;
        }

        public void addTotalLetters(int n) {
            this.mTotalLetters += n;
        }

        public void addReusedLetters(int n) {
            this.mReusedLetters += n;
        }

        public void addTotalTransitions(int n) {
            this.mTotalTransitions += n;
        }

        public void addReusedTransitions(int n) {
            this.mReusedTransitions += n;
        }

        public void addBeforeDiffTransitions(int n) {
            this.mBeforeDiffTransitions += n;
        }

        public void addAfterDiffTransitions(int n) {
            this.mAfterDiffTransitions += n;
        }

        public void addBeforeAcceptanceTransitions(int n) {
            this.mBeforeAcceptanceTransitions += n;
        }

        public void addAfterAcceptanceTransitions(int n) {
            this.mAfterAcceptanceTransitions += n;
        }

        public void addUselessPredicates(int n) {
            this.mUselessPredicates += n;
        }

        public void addDroppedAutomata(int n) {
            this.mDroppedAutomata += n;
        }

        public void announceNextNonreuseIteration() {
            ++this.mNonReuseIterations;
        }

        public long getTime() {
            return (long)this.mTime.getElapsedTime(String.valueOf((Object)ReuseStatisticsDefinitions.REUSE_TIME), TimeUnit.NANOSECONDS);
        }

        public void continueTime() {
            assert (!this.mRunning) : "Timing already running";
            this.mRunning = true;
            this.mTime.unpause(String.valueOf((Object)ReuseStatisticsDefinitions.REUSE_TIME));
        }

        public void stopTime() {
            assert (this.mRunning) : "Timing not running";
            this.mRunning = false;
            this.mTime.pause(String.valueOf((Object)ReuseStatisticsDefinitions.REUSE_TIME));
        }

        public Collection<String> getKeys() {
            return ReuseStatisticsType.getInstance().getKeys();
        }

        public Object getValue(String string) {
            ReuseStatisticsDefinitions reuseStatisticsDefinitions = ReuseStatisticsDefinitions.valueOf(string);
            return switch (reuseStatisticsDefinitions) {
                case ReuseStatisticsDefinitions.REUSE_PREDICATE_UNIFIER -> this.mPredicateUnifierStats;
                case ReuseStatisticsDefinitions.REUSE_TIME -> Long.valueOf(this.getTime());
                case ReuseStatisticsDefinitions.NONREUSE_ITERATIONS -> Integer.valueOf(this.mNonReuseIterations);
                case ReuseStatisticsDefinitions.REUSE_HTC -> this.mHtcStats;
                case ReuseStatisticsDefinitions.AUTOMATA_FROM_FILE -> Integer.valueOf(this.mAutomataFromFile);
                case ReuseStatisticsDefinitions.AUTOMATA_FROM_PREV_ERROR_LOC -> Integer.valueOf(this.mAutomataFromPreviousErrorLocation);
                case ReuseStatisticsDefinitions.REUSED_STATES -> Integer.valueOf(this.mReusedStates);
                case ReuseStatisticsDefinitions.TOTAL_STATES -> Integer.valueOf(this.mTotalStates);
                case ReuseStatisticsDefinitions.REUSED_LETTERS -> Integer.valueOf(this.mReusedLetters);
                case ReuseStatisticsDefinitions.REUSED_TRANSITIONS -> Integer.valueOf(this.mReusedTransitions);
                case ReuseStatisticsDefinitions.TOTAL_LETTERS -> Integer.valueOf(this.mTotalLetters);
                case ReuseStatisticsDefinitions.TOTAL_TRANSITIONS -> Integer.valueOf(this.mTotalTransitions);
                case ReuseStatisticsDefinitions.AFTER_DIFF_TRANS -> Integer.valueOf(this.mAfterDiffTransitions);
                case ReuseStatisticsDefinitions.BEFORE_DIFF_TRANS -> Integer.valueOf(this.mBeforeDiffTransitions);
                case ReuseStatisticsDefinitions.AFTER_ACCEPT_TRANS -> Integer.valueOf(this.mAfterAcceptanceTransitions);
                case ReuseStatisticsDefinitions.BEFORE_ACCEPT_TRANS -> Integer.valueOf(this.mBeforeAcceptanceTransitions);
                case ReuseStatisticsDefinitions.USELESS_PREDICATES -> Integer.valueOf(this.mUselessPredicates);
                case ReuseStatisticsDefinitions.DROPPED_AUTOMATA -> Integer.valueOf(this.mDroppedAutomata);
                default -> throw new MatchException(null, null);
            };
        }

        public IStatisticsType getBenchmarkType() {
            return ReuseStatisticsType.getInstance();
        }
    }

    public static final class ReuseStatisticsType
    extends StatisticsType<ReuseStatisticsDefinitions> {
        private static final ReuseStatisticsType INSTANCE = new ReuseStatisticsType();

        public ReuseStatisticsType() {
            super(ReuseStatisticsDefinitions.class);
        }

        public static ReuseStatisticsType getInstance() {
            return INSTANCE;
        }
    }
}

