/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.EprClause;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashSet;
import java.util.HashSet;
import java.util.Set;

public class EprClauseManager {
    private final ScopedHashSet<EprClause> mEprClauses = new ScopedHashSet();
    ScopedHashMap<DPLLAtom, HashSet<EprClause>> mDPLLAtomToClauses = new ScopedHashMap();
    private final EprTheory mEprTheory;

    public EprClauseManager(EprTheory eprTheory) {
        this.mEprTheory = eprTheory;
    }

    public void push() {
        this.mEprClauses.beginScope();
        this.mDPLLAtomToClauses.beginScope();
    }

    public void pop() {
        for (EprClause eprClause : this.mEprClauses.currentScope()) {
            eprClause.disposeOfClause();
        }
        this.mEprClauses.endScope();
        this.mDPLLAtomToClauses.endScope();
    }

    public Iterable<EprClause> getAllClauses() {
        return this.mEprClauses;
    }

    public void updateAtomToClauses(DPLLAtom dPLLAtom, EprClause eprClause) {
        HashSet<EprClause> hashSet = (HashSet<EprClause>)this.mDPLLAtomToClauses.get((Object)dPLLAtom);
        if (hashSet == null) {
            hashSet = new HashSet<EprClause>();
            this.mDPLLAtomToClauses.put((Object)dPLLAtom, hashSet);
        }
        hashSet.add(eprClause);
    }

    public Clause createEprClause(Set<Literal> set) {
        EprClause eprClause = this.mEprTheory.getEprClauseFactory().getEprClause(set);
        this.mEprTheory.getLogger().debug("EPRDEBUG: (EprClauseManager) creating new EprClause: " + String.valueOf(eprClause));
        this.registerEprClause(eprClause);
        return null;
    }

    public void registerEprClause(EprClause eprClause) {
        this.mEprClauses.add((Object)eprClause);
        for (ClauseLiteral clauseLiteral : eprClause.getLiterals()) {
            this.updateAtomToClauses(clauseLiteral.getLiteral().getAtom(), eprClause);
        }
    }

    public String toString() {
        return "EprClauseManager, Clauses: " + String.valueOf(this.mEprClauses);
    }
}

