/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLType;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import java.util.List;
import java.util.function.Predicate;

public final class Declaration
extends ACSLNode {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(Declaration.class);
    ACSLType type;
    String name;

    public Declaration(ACSLType aCSLType, String string) {
        this.type = aCSLType;
        this.name = string;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Declaration: " + String.valueOf(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Declaration").append('[');
        stringBuffer.append(this.type);
        stringBuffer.append(',').append(this.name);
        return stringBuffer.append(']').toString();
    }

    public ACSLType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        list.add(this.type);
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (aCSLVisitor.visit(this) && this.type != null) {
            this.type.accept(aCSLVisitor);
        }
    }

    @Override
    public Declaration accept(ACSLTransformer aCSLTransformer) {
        Declaration declaration = aCSLTransformer.transform(this);
        if (declaration != this) {
            return declaration;
        }
        ACSLType aCSLType = null;
        if (this.type != null) {
            aCSLType = this.type.accept(aCSLTransformer);
        }
        if (this.type != aCSLType) {
            return new Declaration(aCSLType, this.name);
        }
        return this;
    }
}

