/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.appgraph;

import de.uni_freiburg.informatik.ultimate.core.lib.models.ModifiableExplicitEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.plugins.generator.appgraph.AppEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.appgraph.AppHyperEdge;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AnnotatedProgramPoint
extends ModifiableExplicitEdgesMultigraph<AnnotatedProgramPoint, AppEdge, AnnotatedProgramPoint, AppEdge> {
    private static final long serialVersionUID = -4398335480646555023L;
    private final IPredicate mPredicate;
    private final IcfgLocation mProgramPoint;
    private final boolean mIsErrorLoc;
    private final Set<AppHyperEdge> mOutgoingHyperEdges;
    private final Set<AnnotatedProgramPoint> mCopies;
    private final Set<AnnotatedProgramPoint> mNewCopies;
    private AnnotatedProgramPoint mCloneSource;
    private final int mNodeID;

    public AnnotatedProgramPoint(IPredicate iPredicate, IcfgLocation icfgLocation, boolean bl, int n) {
        this.mPredicate = iPredicate;
        this.mProgramPoint = icfgLocation;
        this.mIsErrorLoc = bl;
        this.mNodeID = n;
        this.mOutgoingHyperEdges = new HashSet<AppHyperEdge>();
        this.mCopies = new HashSet<AnnotatedProgramPoint>();
        this.mNewCopies = new HashSet<AnnotatedProgramPoint>();
        this.mCloneSource = null;
    }

    public AnnotatedProgramPoint(IPredicate iPredicate, IcfgLocation icfgLocation, boolean bl) {
        this(iPredicate, icfgLocation, bl, 0);
    }

    public AnnotatedProgramPoint(AnnotatedProgramPoint annotatedProgramPoint) {
        this(annotatedProgramPoint.mPredicate, annotatedProgramPoint.mProgramPoint, annotatedProgramPoint.mIsErrorLoc, annotatedProgramPoint.mNodeID);
    }

    public AnnotatedProgramPoint(AnnotatedProgramPoint annotatedProgramPoint, IPredicate iPredicate) {
        this(iPredicate, annotatedProgramPoint.mProgramPoint, annotatedProgramPoint.mIsErrorLoc, annotatedProgramPoint.mNodeID);
    }

    public AnnotatedProgramPoint(AnnotatedProgramPoint annotatedProgramPoint, IPredicate iPredicate, boolean bl, int n) {
        this(iPredicate, annotatedProgramPoint.mProgramPoint, annotatedProgramPoint.mIsErrorLoc, n);
        if (bl) {
            for (AppEdge appEdge : annotatedProgramPoint.getOutgoingEdges()) {
                if (appEdge instanceof AppHyperEdge) {
                    this.connectOutgoingReturn(((AppHyperEdge)appEdge).getHier(), (IIcfgReturnTransition)appEdge.getStatement(), (AnnotatedProgramPoint)appEdge.getTarget());
                    continue;
                }
                this.connectOutgoing(appEdge.getStatement(), (AnnotatedProgramPoint)appEdge.getTarget());
            }
            for (AppHyperEdge appHyperEdge : annotatedProgramPoint.getOutgoingHyperEdges()) {
                ((AnnotatedProgramPoint)appHyperEdge.getSource()).connectOutgoingReturn(this, (IIcfgReturnTransition)appHyperEdge.getStatement(), (AnnotatedProgramPoint)appHyperEdge.getTarget());
            }
            annotatedProgramPoint.mCopies.add(this);
            this.mCloneSource = annotatedProgramPoint;
        }
    }

    public Set<AnnotatedProgramPoint> getNextClones() {
        return this.mCopies;
    }

    public IPredicate getPredicate() {
        return this.mPredicate;
    }

    public boolean isErrorLocation() {
        return this.mIsErrorLoc;
    }

    public IcfgLocation getProgramPoint() {
        return this.mProgramPoint;
    }

    public Set<AppHyperEdge> getOutgoingHyperEdges() {
        return this.mOutgoingHyperEdges;
    }

    public AnnotatedProgramPoint getParentCopy() {
        return this.mCloneSource;
    }

    public String toString() {
        String string = Integer.toHexString(System.identityHashCode((Object)this));
        return this.mProgramPoint.toString() + string.substring(Math.max(string.length() - 3, 0)) + ":" + this.mPredicate.getFormula().toString();
    }

    public void connectOutgoing(IIcfgTransition<IcfgLocation> iIcfgTransition, AnnotatedProgramPoint annotatedProgramPoint) {
        assert (!(iIcfgTransition instanceof IIcfgReturnTransition));
        AppEdge appEdge = new AppEdge(this, iIcfgTransition, annotatedProgramPoint);
        this.mOutgoingEdges.add(appEdge);
        annotatedProgramPoint.mIncomingEdges.add(appEdge);
    }

    public void connectOutgoingReturn(AnnotatedProgramPoint annotatedProgramPoint, IIcfgReturnTransition<?, ?> iIcfgReturnTransition, AnnotatedProgramPoint annotatedProgramPoint2) {
        AppHyperEdge appHyperEdge = new AppHyperEdge(this, annotatedProgramPoint, iIcfgReturnTransition, annotatedProgramPoint2);
        annotatedProgramPoint.mOutgoingHyperEdges.add(appHyperEdge);
        this.mOutgoingEdges.add(appHyperEdge);
        annotatedProgramPoint2.mIncomingEdges.add(appHyperEdge);
    }

    public AppEdge getEdge(AnnotatedProgramPoint annotatedProgramPoint) {
        for (AppEdge appEdge : this.mOutgoingEdges) {
            if (appEdge.getTarget() != annotatedProgramPoint) continue;
            return appEdge;
        }
        return null;
    }

    public void isolateNode() {
        AppEdge[] appEdgeArray;
        AppEdge[] appEdgeArray2 = appEdgeArray = this.getIncomingEdges().toArray(new AppEdge[0]);
        int n = appEdgeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AppEdge appEdge = appEdgeArray2[n2];
            appEdge.disconnect();
            ++n2;
        }
        if (this.mCloneSource != null) {
            this.mCloneSource.mCopies.remove((Object)this);
        }
    }

    public void addCopy(AnnotatedProgramPoint annotatedProgramPoint) {
        this.mNewCopies.add(annotatedProgramPoint);
    }

    public void updateCopies() {
        this.mCopies.addAll(this.mNewCopies);
        this.mNewCopies.clear();
    }

    public void setCloneSource(AnnotatedProgramPoint annotatedProgramPoint) {
        this.mCloneSource = annotatedProgramPoint;
    }

    public List<AnnotatedProgramPoint> getCopies() {
        ArrayList<AnnotatedProgramPoint> arrayList = new ArrayList<AnnotatedProgramPoint>(this.mCopies);
        arrayList.addAll(this.mNewCopies);
        return arrayList;
    }

    public List<AnnotatedProgramPoint> getNewCopies() {
        ArrayList<AnnotatedProgramPoint> arrayList = new ArrayList<AnnotatedProgramPoint>(this.mNewCopies);
        return arrayList;
    }

    public AnnotatedProgramPoint getLabel() {
        return this;
    }

    public int getNodeId() {
        return this.mNodeID;
    }
}

