/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.model.models;

import java.io.File;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ModelType
implements Serializable {
    private static final long serialVersionUID = -2922069733243189149L;
    private int mSize;
    private final String mCreator;
    private Date mCreated;
    private long mLastModified;
    private String mLastModifier;
    private final Type mType;
    private int mIteration;
    private boolean mTouched;
    private final List<String> mFileNames;
    private DateFormat mLastModifiedStringFormat;
    private boolean mIsCyclic;
    private boolean mIsDirected;
    private boolean mIsTree;
    private boolean mIsOrdered;
    private boolean mIsMultiGraph;
    private boolean mIsFinite;

    public ModelType(String string, Type type, Collection<String> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("A graphtype has to have at least one filename");
        }
        if (type == null) {
            throw new IllegalArgumentException("A graphtype has to have a type");
        }
        this.mCreator = string;
        this.mType = type;
        this.mFileNames = new ArrayList<String>(collection);
        this.init();
    }

    public void modified(String string) {
        this.setDirty(true);
        this.mLastModifier = string;
        this.mLastModified = System.currentTimeMillis();
        ++this.mIteration;
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            ModelType modelType = (ModelType)object;
            return modelType.mLastModified == this.mLastModified && modelType.mCreator.equals(this.mCreator);
        }
        return false;
    }

    public int hashCode() {
        return (int)this.mLastModified;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.mFileNames) {
            stringBuilder.append(new File(string).getName());
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(" ");
        }
        stringBuilder.append(this.mCreator);
        stringBuilder.append(" " + String.valueOf((Object)this.mType));
        stringBuilder.append(" " + this.mLastModifiedStringFormat.format(new Date(this.mLastModified)));
        return stringBuilder.toString();
    }

    public boolean isDirty() {
        return this.mTouched;
    }

    public void setDirty(boolean bl) {
        this.mTouched = bl;
    }

    public String getCreator() {
        return this.mCreator;
    }

    public Date getCreated() {
        return this.mCreated;
    }

    public String getLastModifier() {
        return this.mLastModifier;
    }

    public Date getLastModified() {
        return new Date(this.mLastModified);
    }

    public boolean isFromSource() {
        return this.mIteration == 0;
    }

    public Type getType() {
        return this.mType;
    }

    public boolean isCyclic() {
        return this.mIsCyclic;
    }

    public boolean isDirected() {
        return this.mIsDirected;
    }

    public boolean isGraph() {
        return this.mIsTree;
    }

    public boolean isOrdered() {
        return this.mIsOrdered;
    }

    public boolean isFinite() {
        return this.mIsFinite;
    }

    public boolean isMulitGraph() {
        return this.mIsMultiGraph;
    }

    public String getAbsolutePath(int n) {
        return this.mFileNames.get(n);
    }

    public String getFileName(int n) {
        Object object = this.mFileNames.get(n);
        if (((String)object).contains(", ")) {
            String[] stringArray = ((String)object).split(", ");
            object = "";
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string = stringArray2[n3];
                object = (String)object + string.substring(string.lastIndexOf(File.separator) + 1) + ", ";
                ++n3;
            }
            object = ((String)object).substring(0, ((String)object).length() - 2);
        } else {
            object = ((String)object).trim();
            object = ((String)object).substring(((String)object).lastIndexOf(File.separator) + 1);
        }
        return object;
    }

    public int getNumberOfFiles() {
        return this.mFileNames.size();
    }

    private void init() {
        this.mTouched = false;
        this.mIteration = 0;
        this.mLastModifier = this.mCreator;
        this.mCreated = new Date();
        this.mLastModified = System.currentTimeMillis();
        this.mSize = 0;
        this.mLastModifiedStringFormat = new SimpleDateFormat("dd.MM hh:mm:ss");
        this.setAttributes();
    }

    private void setAttributes() {
        switch (this.mType) {
            case AST: {
                this.mIsCyclic = false;
                this.mIsDirected = true;
                this.mIsTree = true;
                this.mIsOrdered = true;
                this.mIsMultiGraph = false;
                this.mIsFinite = true;
                break;
            }
            case CST: {
                this.mIsCyclic = false;
                this.mIsDirected = true;
                this.mIsTree = true;
                this.mIsOrdered = true;
                this.mIsMultiGraph = false;
                this.mIsFinite = true;
                break;
            }
            case DFG: {
                this.mIsCyclic = false;
                this.mIsDirected = true;
                this.mIsTree = true;
                this.mIsOrdered = false;
                this.mIsMultiGraph = false;
                this.mIsFinite = true;
                break;
            }
            case CFG: {
                this.mIsCyclic = true;
                this.mIsDirected = true;
                this.mIsTree = false;
                this.mIsOrdered = false;
                this.mIsMultiGraph = false;
                this.mIsFinite = true;
                break;
            }
            case OTHER: {
                this.mIsCyclic = true;
                this.mIsDirected = true;
                this.mIsTree = false;
                this.mIsOrdered = false;
                this.mIsMultiGraph = true;
                this.mIsFinite = false;
                break;
            }
        }
    }

    public int getSize() {
        return this.mSize;
    }

    public void setSize(int n) {
        this.mSize = n;
    }

    public List<String> getFileNames() {
        return this.mFileNames;
    }

    public static enum Type {
        AST,
        CG,
        CFG,
        DFG,
        CST,
        TS,
        PG,
        OTHER,
        CORRECTNESS_WITNESS,
        VIOLATION_WITNESS;

    }
}

