/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.acceleratedtracecheck;

import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.core.lib.results.StatisticsResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.IPayload;
import de.uni_freiburg.informatik.ultimate.core.model.models.Payload;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.JordanLoopAcceleration;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.JordanLoopAccelerationStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.IInterpolatingTraceCheck;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.InterpolantComputationStatus;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.TraceCheckReasonUnknown;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.taskidentifier.TaskIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolationTechnique;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckSpWp;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.acceleratedtracecheck.AcceleratedTraceCheckStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.TaCheckAndRefinementPreferences;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashTreeRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.TreeRelation;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class AcceleratedTraceCheck<L extends IIcfgTransition<?>>
implements IInterpolatingTraceCheck<L> {
    private final ILogger mLogger;
    private final ManagedScript mMgdScript;
    private final IUltimateServiceProvider mServices;
    private final List<L> mCounterexample;
    private final IPredicate mPrecondition;
    private final IPredicate mPostcondition;
    private final IPredicateUnifier mPredicateUnifier;
    private final TaCheckAndRefinementPreferences mPrefs;
    private final IIcfg<?> mIcfg;
    private Script.LBool mIsTraceCorrect;
    private IPredicate[] mInterpolants;
    private IProgramExecution<L, Term> mFeasibleProgramExecution;
    private TraceCheckReasonUnknown mReasonUnknown;
    private boolean mTraceCheckFinishedNormally;
    private final PredicateFactory mPredicateFactory;
    private final TaskIdentifier mTaskIdentifier;
    private final AcceleratedTraceCheckStatisticsGenerator mStatisticsGenerator;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AcceleratedTraceCheck(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, TaCheckAndRefinementPreferences<L> taCheckAndRefinementPreferences, ManagedScript managedScript, IPredicateUnifier iPredicateUnifier, Counterexample<L> counterexample, IPredicate iPredicate, IPredicate iPredicate2, PredicateFactory predicateFactory, TaskIdentifier taskIdentifier) {
        IcfgProgramExecution icfgProgramExecution;
        this.mLogger = iLogger;
        this.mMgdScript = managedScript;
        this.mServices = iUltimateServiceProvider;
        this.mCounterexample = counterexample.getWord().asList();
        this.mPrecondition = iPredicate;
        this.mPostcondition = iPredicate2;
        this.mPrefs = taCheckAndRefinementPreferences;
        this.mPredicateFactory = predicateFactory;
        this.mTaskIdentifier = taskIdentifier;
        counterexample.requireControlConfigurations();
        this.mIcfg = this.mPrefs.getIcfgContainer();
        this.mPredicateUnifier = iPredicateUnifier;
        this.mInterpolants = null;
        this.mStatisticsGenerator = new AcceleratedTraceCheckStatisticsGenerator();
        TreeMap<Integer, AcceleratedSegment> treeMap = this.constructAcceleratedSegments(this.mServices, this.mLogger, managedScript, counterexample);
        if (treeMap.isEmpty()) {
            TraceCheckSpWp<L> traceCheckSpWp = this.checkTrace(this.mPrecondition, this.mPostcondition, counterexample);
            this.mIsTraceCorrect = traceCheckSpWp.isCorrect();
            switch (traceCheckSpWp.isCorrect()) {
                case SAT: {
                    this.mFeasibleProgramExecution = traceCheckSpWp.getRcfgProgramExecution();
                    return;
                }
                case UNKNOWN: {
                    this.mReasonUnknown = traceCheckSpWp.getTraceCheckReasonUnknown();
                    return;
                }
                case UNSAT: {
                    InterpolantComputationStatus interpolantComputationStatus = traceCheckSpWp.getInterpolantComputationStatus();
                    if (!interpolantComputationStatus.wasComputationSuccessful()) throw new UnsupportedOperationException(String.format("Acceleration-free interpolant computation failed: %s %s ", interpolantComputationStatus.getStatus(), interpolantComputationStatus.getException()));
                    this.mInterpolants = traceCheckSpWp.getForwardIpp().getPredicates().toArray(new IPredicate[0]);
                    return;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        Counterexample<L> counterexample2 = this.construtAcceleratedCounterexample(this.mServices, this.mLogger, this.mMgdScript, this.mIcfg.getCfgSmtToolkit().getIcfgEdgeFactory(), treeMap, counterexample);
        TraceCheckSpWp<L> traceCheckSpWp = this.checkTrace(this.mPrecondition, this.mPostcondition, counterexample2);
        this.mIsTraceCorrect = traceCheckSpWp.isCorrect();
        switch (traceCheckSpWp.isCorrect()) {
            case SAT: {
                icfgProgramExecution = traceCheckSpWp.getRcfgProgramExecution();
                this.mFeasibleProgramExecution = this.constructProgramExecution(counterexample.getWord(), treeMap, icfgProgramExecution);
                break;
            }
            case UNKNOWN: {
                this.mReasonUnknown = traceCheckSpWp.getTraceCheckReasonUnknown();
                break;
            }
            case UNSAT: {
                this.mInterpolants = this.constructInterpolants(counterexample, treeMap, traceCheckSpWp.getForwardPredicates());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.mStatisticsGenerator.reportSatisfiability(traceCheckSpWp.isCorrect());
        icfgProgramExecution = new StatisticsData();
        icfgProgramExecution.aggregateBenchmarkData((IStatisticsDataProvider)this.mStatisticsGenerator);
        iUltimateServiceProvider.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)new StatisticsResult("TraceAbstraction", "AcceleratedTraceCheckStatistics", (ICsvProviderProvider)icfgProgramExecution));
    }

    private IPredicate[] constructInterpolants(Counterexample<L> counterexample, TreeMap<Integer, AcceleratedSegment> treeMap, List<IPredicate> list) {
        ArrayList<IPredicate> arrayList = new ArrayList<IPredicate>();
        int n = 0;
        for (Map.Entry<Integer, AcceleratedSegment> entry : treeMap.entrySet()) {
            List list2;
            NestedWord nestedWord;
            IPredicate iPredicate;
            AcceleratedSegment acceleratedSegment = entry.getValue();
            assert (entry.getKey().intValue() == entry.getValue().getStartPosition());
            List<IPredicate> list3 = list.subList(arrayList.size() - n, acceleratedSegment.getStartPosition() - n);
            arrayList.addAll(list3);
            assert (arrayList.size() == acceleratedSegment.getStartPosition());
            IPredicate iPredicate2 = list.get(acceleratedSegment.getStartPosition() - n - 1);
            TraceCheckSpWp<L> traceCheckSpWp = this.checkTrace(iPredicate2, iPredicate = list.get(acceleratedSegment.getStartPosition() - n), new Counterexample((Word)(nestedWord = counterexample.getWord().getSubWord(acceleratedSegment.getStartPosition(), acceleratedSegment.getEndPosition() + 1)), list2 = counterexample.getControlConfigurations().subList(acceleratedSegment.getStartPosition(), acceleratedSegment.getEndPosition() + 2)));
            if (traceCheckSpWp.isCorrect() != Script.LBool.UNSAT) {
                throw new UnsupportedOperationException("Body trace check " + String.valueOf(traceCheckSpWp.isCorrect()));
            }
            arrayList.addAll(traceCheckSpWp.getForwardPredicates());
            assert (arrayList.size() == acceleratedSegment.getEndPosition());
            n += acceleratedSegment.getEndPosition() - acceleratedSegment.getStartPosition();
        }
        arrayList.addAll(list.subList(arrayList.size() - n, list.size()));
        assert (counterexample.length() == arrayList.size() + 1);
        assert (list.size() + n == arrayList.size());
        return arrayList.toArray(new IPredicate[arrayList.size()]);
    }

    private TraceCheckSpWp<L> checkTrace(IPredicate iPredicate, IPredicate iPredicate2, Counterexample<L> counterexample) {
        TraceCheckSpWp traceCheckSpWp = new TraceCheckSpWp(iPredicate, iPredicate2, new TreeMap(), counterexample, this.mPrefs.getCfgSmtToolkit(), this.mPrefs.getAssertCodeBlockOrder(), this.mPrefs.getUnsatCores(), this.mPrefs.getUseLiveVariables(), this.mServices, this.mPrefs.computeCounterexample(), this.mPredicateFactory, this.mPredicateUnifier, InterpolationTechnique.ForwardPredicates, this.constructManagedScript(), SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, this.mPrefs.collectInterpolantStatistics());
        return traceCheckSpWp;
    }

    private ManagedScript constructManagedScript() {
        SolverBuilder.SolverSettings solverSettings = this.mPrefs.constructSolverSettings(this.mTaskIdentifier);
        return this.createExternalManagedScript(solverSettings);
    }

    protected ManagedScript createExternalManagedScript(SolverBuilder.SolverSettings solverSettings) {
        return this.mPrefs.getIcfgContainer().getCfgSmtToolkit().createFreshManagedScript(this.mServices, solverSettings, "ChecksDuringAccel");
    }

    private IProgramExecution<L, Term> constructProgramExecution(NestedWord<L> nestedWord, TreeMap<Integer, AcceleratedSegment> treeMap, IcfgProgramExecution<L> icfgProgramExecution) {
        ArrayList<AtomicTraceElement> arrayList = new ArrayList<AtomicTraceElement>();
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        Map[] mapArray = new Map[nestedWord.length()];
        IProgramExecution.ProgramState programState = icfgProgramExecution.getInitialProgramState();
        hashMap.put(-1, programState);
        boolean bl = false;
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        while (n3 < nestedWord.length()) {
            Object object;
            if (treeMap.containsKey(n3)) {
                bl = true;
                object = treeMap.get(n3);
                n = ((AcceleratedSegment)object).getEndPosition();
                n2 += ((AcceleratedSegment)object).getEndPosition() - ((AcceleratedSegment)object).getStartPosition();
            }
            if (bl) {
                object = new AtomicTraceElement.AtomicTraceElementBuilder();
                object.setStepAndElement((Object)((IIcfgTransition)nestedWord.getSymbol(n3)));
                var13_13 = object.build();
                arrayList.add((AtomicTraceElement)var13_13);
            } else {
                arrayList.add(icfgProgramExecution.getTraceElement(n3 - n2));
                object = icfgProgramExecution.getProgramState(n3 - n2);
                if (object != null) {
                    hashMap.put(n3, object);
                }
                if ((var13_13 = icfgProgramExecution.getBranchEncoders()[n3 - n2]) != null) {
                    mapArray[n3] = var13_13;
                }
            }
            if (n3 == n) {
                bl = false;
            }
            ++n3;
        }
        return new IcfgProgramExecution(arrayList, hashMap, mapArray, icfgProgramExecution.isConcurrent(), icfgProgramExecution.getTraceElementClass());
    }

    private Counterexample<L> construtAcceleratedCounterexample(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, ManagedScript managedScript, IcfgEdgeFactory icfgEdgeFactory, TreeMap<Integer, AcceleratedSegment> treeMap, Counterexample<L> counterexample) {
        NestedWord nestedWord2 = counterexample.getWord();
        List list = counterexample.getControlConfigurations();
        int n = 0;
        NestedWord nestedWord3 = new NestedWord();
        ArrayList arrayList = new ArrayList();
        for (Map.Entry<Integer, AcceleratedSegment> nestedWord4 : treeMap.entrySet()) {
            IcfgInternalTransition icfgInternalTransition;
            AcceleratedSegment acceleratedSegment = nestedWord4.getValue();
            NestedWord nestedWord = nestedWord2.getSubWord(n, acceleratedSegment.getStartPosition());
            nestedWord3 = nestedWord3.concatenate(nestedWord);
            List list2 = list.subList(n, nestedWord4.getKey());
            arrayList.addAll(list2);
            IcfgLocation icfgLocation = ((IIcfgTransition)nestedWord2.getSymbol(acceleratedSegment.getStartPosition())).getSource();
            IcfgInternalTransition icfgInternalTransition2 = icfgInternalTransition = icfgEdgeFactory.createInternalTransition(icfgLocation, icfgLocation, (IPayload)new Payload(), acceleratedSegment.getTransitiveClosure());
            NestedWord nestedWord5 = new NestedWord((Object)icfgInternalTransition2, -2);
            nestedWord3 = nestedWord3.concatenate(nestedWord5);
            arrayList.add(list.get(acceleratedSegment.getStartPosition()));
            n = acceleratedSegment.getEndPosition() + 1;
        }
        NestedWord nestedWord = nestedWord2.getSubWord(n, counterexample.length());
        nestedWord3 = nestedWord3.concatenate(nestedWord);
        arrayList.addAll(list.subList(n, counterexample.length() + 1));
        return new Counterexample((Word)nestedWord3, arrayList);
    }

    private TreeMap<Integer, AcceleratedSegment> constructAcceleratedSegments(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, ManagedScript managedScript, Counterexample<L> counterexample) {
        TreeMap<Integer, AcceleratedSegment> treeMap = new TreeMap<Integer, AcceleratedSegment>();
        HashTreeRelation<Object, Integer> hashTreeRelation = AcceleratedTraceCheck.findSimilarProgramPoints(counterexample.getControlConfigurations());
        TreeRelation<Integer, Integer> treeRelation = AcceleratedTraceCheck.computeMaximalCrossFreeLoopPositions(hashTreeRelation);
        int n = 0;
        while (n < counterexample.length() + 1) {
            TreeSet treeSet = treeRelation.getImage((Object)n);
            Integer n2 = treeSet.higher(n);
            if (n2 != null) {
                NestedWord nestedWord = counterexample.getWord();
                NestedWord nestedWord2 = nestedWord.getSubWord(n, n2.intValue());
                this.mLogger.info((Object)String.format("Found repeated program point %s. Trying to accelerate segment from %s to %s", counterexample.getControlConfigurations().get(n), n, n2));
                UnmodifiableTransFormula unmodifiableTransFormula = this.accelerate(iUltimateServiceProvider, iLogger, managedScript, nestedWord2);
                this.mStatisticsGenerator.reportAccelerationAttempt();
                if (unmodifiableTransFormula != null) {
                    this.mStatisticsGenerator.reportSuccessfullAcceleration();
                    treeMap.put(n, new AcceleratedSegment(n, n2 - 1, unmodifiableTransFormula));
                    this.mLogger.info((Object)String.format("Found repeated program point %s. Successfully accelerated segment from %s to %s", counterexample.getControlConfigurations().get(n), n, n2));
                    n = n2 - 1;
                } else {
                    this.mLogger.info((Object)String.format("Found repeated program point %s. Failed to accelerate segment from %s to %s", counterexample.getControlConfigurations().get(n), n, n2));
                }
            }
            ++n;
        }
        return treeMap;
    }

    private static TreeRelation<Integer, Integer> computeMaximalCrossFreeLoopPositions(HashTreeRelation<Object, Integer> hashTreeRelation) {
        TreeRelation treeRelation = new TreeRelation();
        for (Map.Entry entry : hashTreeRelation.entrySet()) {
            TreeSet treeSet = (TreeSet)entry.getValue();
            for (Integer n : treeSet) {
                treeRelation.addAllPairs((Object)n, (Collection)treeSet);
            }
        }
        return AcceleratedTraceCheck.computeMaximalCrossFreeLoopPositions((TreeRelation<Integer, Integer>)treeRelation, (Integer)treeRelation.getDomain().first(), (Integer)treeRelation.getDomain().last());
    }

    private static TreeRelation<Integer, Integer> computeMaximalCrossFreeLoopPositions(TreeRelation<Integer, Integer> treeRelation, Integer n, Integer n2) {
        TreeRelation treeRelation2 = new TreeRelation();
        if (n2 < n) {
            return treeRelation2;
        }
        int n3 = n;
        while (n3 <= n2) {
            Integer n4 = treeRelation.getDomain().higher(n3 - 1);
            if (n4 == null) break;
            TreeSet treeSet = treeRelation.getImage((Object)n4);
            SortedSet<Integer> sortedSet = treeSet.subSet(n3, n2 + 1);
            int n5 = -1;
            for (Integer n6 : sortedSet) {
                treeRelation2.addAllPairs((Object)n6, sortedSet);
                if (n5 != -1) {
                    treeRelation2.addAll(AcceleratedTraceCheck.computeMaximalCrossFreeLoopPositions(treeRelation, n5 + 1, n6 - 1));
                }
                n5 = n6;
            }
            n3 = n5 + 1;
        }
        return treeRelation2;
    }

    private UnmodifiableTransFormula accelerate(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, ManagedScript managedScript, NestedWord<L> nestedWord) {
        if (!nestedWord.hasEmptyNestingRelation()) {
            return null;
        }
        List list = nestedWord.asList().stream().map(IAction::getTransformula).collect(Collectors.toList());
        UnmodifiableTransFormula unmodifiableTransFormula = TransFormulaUtils.sequentialComposition((ILogger)iLogger, (IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)managedScript, (boolean)true, (boolean)true, (boolean)false, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA2, list);
        JordanLoopAcceleration.JordanLoopAccelerationResult jordanLoopAccelerationResult = JordanLoopAcceleration.accelerateLoop((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMgdScript, (UnmodifiableTransFormula)unmodifiableTransFormula, (boolean)true);
        JordanLoopAccelerationStatisticsGenerator jordanLoopAccelerationStatisticsGenerator = jordanLoopAccelerationResult.getJordanLoopAccelerationStatistics();
        StatisticsData statisticsData = new StatisticsData();
        statisticsData.aggregateBenchmarkData((IStatisticsDataProvider)jordanLoopAccelerationStatisticsGenerator);
        iUltimateServiceProvider.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)new StatisticsResult("TraceAbstraction", "LoopAccelerationStatistics", (ICsvProviderProvider)statisticsData));
        if (jordanLoopAccelerationResult.getAccelerationStatus() != JordanLoopAcceleration.JordanLoopAccelerationResult.AccelerationStatus.SUCCESS) {
            return null;
        }
        return jordanLoopAccelerationResult.getTransFormula();
    }

    private static HashTreeRelation<Object, Integer> findSimilarProgramPoints(List<?> list) {
        HashTreeRelation hashTreeRelation = new HashTreeRelation();
        int n = 0;
        while (n < list.size()) {
            hashTreeRelation.addPair(list.get(n), (Object)n);
            ++n;
        }
        return hashTreeRelation;
    }

    public InterpolantComputationStatus getInterpolantComputationStatus() {
        if (this.isCorrect() == Script.LBool.UNSAT) {
            return new InterpolantComputationStatus();
        }
        if (this.isCorrect() == Script.LBool.SAT) {
            return new InterpolantComputationStatus(InterpolantComputationStatus.ItpErrorStatus.TRACE_FEASIBLE, null);
        }
        throw new UnsupportedOperationException();
    }

    public IPredicate[] getInterpolants() {
        return this.mInterpolants;
    }

    public Map<Integer, IPredicate> getPendingContexts() {
        return Collections.emptyMap();
    }

    public IPredicate getPostcondition() {
        return this.mPostcondition;
    }

    public IPredicate getPrecondition() {
        return this.mPrecondition;
    }

    public IPredicateUnifier getPredicateUnifier() {
        return this.mPredicateUnifier;
    }

    public IProgramExecution<L, Term> getRcfgProgramExecution() {
        if (this.mFeasibleProgramExecution == null) {
            throw new AssertionError();
        }
        return this.mFeasibleProgramExecution;
    }

    public IStatisticsDataProvider getStatistics() {
        return null;
    }

    public List<L> getTrace() {
        return this.mCounterexample;
    }

    public TraceCheckReasonUnknown getTraceCheckReasonUnknown() {
        return this.mReasonUnknown;
    }

    public Script.LBool isCorrect() {
        return this.mIsTraceCorrect;
    }

    public boolean isPerfectSequence() {
        return this.isCorrect() == Script.LBool.UNSAT;
    }

    public boolean providesRcfgProgramExecution() {
        return this.mIsTraceCorrect == Script.LBool.SAT;
    }

    public boolean wasTracecheckFinishedNormally() {
        return this.mTraceCheckFinishedNormally;
    }

    private static class AcceleratedSegment {
        final int mStartPosition;
        final int mEndPosition;
        final UnmodifiableTransFormula mTransitiveClosure;

        public AcceleratedSegment(int n, int n2, UnmodifiableTransFormula unmodifiableTransFormula) {
            this.mStartPosition = n;
            this.mEndPosition = n2;
            this.mTransitiveClosure = unmodifiableTransFormula;
        }

        public int getStartPosition() {
            return this.mStartPosition;
        }

        public int getEndPosition() {
            return this.mEndPosition;
        }

        public UnmodifiableTransFormula getTransitiveClosure() {
            return this.mTransitiveClosure;
        }
    }
}

