/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.BinaryRelation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprHelpers;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.TTSubstitution;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.TermTuple;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprGroundEqualityAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprGroundPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedEqualityAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseDpllLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseEprGroundLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseEprLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseEprQuantifiedLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.EprClauseState;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.UnitPropagationData;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.DawgFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgState;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel.DecideStackLiteral;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiFunction;

public class EprClause {
    private static final int DAWG_FALSE = -1;
    private static final int DAWG_TRUE = -2;
    private static final int DAWG_UNKNOWN = -3;
    private final List<Literal> mDpllLiterals;
    private final EprTheory mEprTheory;
    private final DawgFactory<ApplicationTerm, TermVariable> mDawgFactory;
    private DawgState<ApplicationTerm, Integer> mDawg;
    private final List<ClauseLiteral> mLiterals;
    private final boolean mIsGround;
    private final SortedSet<TermVariable> mVariables;
    boolean mClauseStateIsDirty = true;
    private EprClauseState mEprClauseState;
    private DawgState<ApplicationTerm, Boolean> mConflictPoints;
    private UnitPropagationData mUnitPropagationData;
    private boolean mHasBeenDisposed = false;

    public EprClause(Set<Literal> set, EprTheory eprTheory) {
        this.mDpllLiterals = new ArrayList<Literal>(set);
        this.mEprTheory = eprTheory;
        this.mDawgFactory = eprTheory.getDawgFactory();
        TreeSet treeSet = new TreeSet(EprHelpers.getColumnNamesComparator());
        for (Literal literal : set) {
            treeSet.addAll(Arrays.asList(literal.getAtom().getSMTFormula(this.mEprTheory.getTheory()).getFreeVars()));
        }
        this.mVariables = treeSet;
        this.mLiterals = Collections.unmodifiableList(this.createClauseLiterals(set));
        this.mIsGround = this.mVariables.isEmpty();
    }

    private List<ClauseLiteral> createClauseLiterals(Set<Literal> set) {
        ArrayList<ClauseLiteral> arrayList = new ArrayList<ClauseLiteral>(set.size());
        for (Literal literal : set) {
            ClauseEprLiteral clauseEprLiteral;
            EprPredicateAtom eprPredicateAtom;
            boolean bl = literal.getSign() == 1;
            DPLLAtom dPLLAtom = literal.getAtom();
            if (dPLLAtom instanceof EprQuantifiedPredicateAtom || dPLLAtom instanceof EprQuantifiedEqualityAtom) {
                eprPredicateAtom = (EprQuantifiedPredicateAtom)dPLLAtom;
                clauseEprLiteral = new ClauseEprQuantifiedLiteral(bl, (EprQuantifiedPredicateAtom)eprPredicateAtom, this, this.mEprTheory);
                arrayList.add(clauseEprLiteral);
                eprPredicateAtom.getEprPredicate().addQuantifiedOccurence((ClauseEprQuantifiedLiteral)clauseEprLiteral, this);
                continue;
            }
            if (dPLLAtom instanceof EprGroundPredicateAtom) {
                eprPredicateAtom = (EprGroundPredicateAtom)dPLLAtom;
                clauseEprLiteral = new ClauseEprGroundLiteral(bl, (EprGroundPredicateAtom)eprPredicateAtom, this, this.mEprTheory);
                arrayList.add(clauseEprLiteral);
                eprPredicateAtom.getEprPredicate().addGroundOccurence((ClauseEprGroundLiteral)clauseEprLiteral, this);
                continue;
            }
            if (dPLLAtom instanceof EprGroundEqualityAtom) {
                assert (false) : "do we really have this case?";
                continue;
            }
            arrayList.add(new ClauseDpllLiteral(bl, dPLLAtom, this, this.mEprTheory));
        }
        return arrayList;
    }

    public void disposeOfClause() {
        assert (!this.mHasBeenDisposed);
        for (ClauseLiteral clauseLiteral : this.mLiterals) {
            if (!(clauseLiteral instanceof ClauseEprLiteral)) continue;
            ClauseEprLiteral clauseEprLiteral = (ClauseEprLiteral)clauseLiteral;
            clauseEprLiteral.getEprPredicate().notifyAboutClauseDisposal(this);
        }
        this.mHasBeenDisposed = true;
    }

    public void backtrackStateWrtDecideStackLiteral(DecideStackLiteral decideStackLiteral) {
        this.mClauseStateIsDirty = true;
    }

    private EprClauseState determineClauseState() {
        DawgState<ApplicationTerm, Integer> dawgState = this.mDawgFactory.createConstantDawg(this.getVariables(), -1);
        boolean bl = this.mEprClauseState == null;
        for (ClauseLiteral clauseLiteral : this.getLiterals()) {
            if (!clauseLiteral.isDirty()) continue;
            bl = true;
        }
        if (!bl) {
            return this.mEprClauseState;
        }
        int n3 = 0;
        while (n3 < this.getLiterals().size()) {
            int n4 = n3;
            BiFunction<Integer, EprTheory.TriBool, Integer> biFunction = (n2, triBool) -> triBool == EprTheory.TriBool.TRUE ? -2 : (triBool == EprTheory.TriBool.FALSE ? n2 : (n2 == -1 ? n4 : (n2 == -2 ? -2 : -3)));
            dawgState = this.mDawgFactory.createProduct(dawgState, this.getLiterals().get(n3).getDawg(), biFunction);
            assert (dawgState.isTotal());
            if (DawgFactory.isConstantValue(dawgState, -2)) {
                this.mEprClauseState = EprClauseState.Fulfilled;
                return this.mEprClauseState;
            }
            ++n3;
        }
        this.mDawg = dawgState;
        this.mConflictPoints = this.mDawgFactory.createMapped(dawgState, n -> n == -1);
        if (!DawgFactory.isEmpty(this.mConflictPoints)) {
            this.mEprClauseState = EprClauseState.Conflict;
        } else if (!DawgFactory.isEmpty(this.mDawgFactory.createMapped(dawgState, n -> n >= 0))) {
            this.mUnitPropagationData = new UnitPropagationData(this, dawgState, this.mDawgFactory);
            this.mEprClauseState = EprClauseState.Unit;
        } else {
            this.mEprClauseState = EprClauseState.Normal;
        }
        return this.mEprClauseState;
    }

    public SortedSet<TermVariable> getVariables() {
        return this.mVariables;
    }

    public int getVariablePos(TermVariable termVariable) {
        int n = 0;
        for (TermVariable termVariable2 : this.mVariables) {
            if (termVariable2 == termVariable) {
                return n;
            }
            ++n;
        }
        throw new NoSuchElementException();
    }

    public UnitPropagationData getUnitPropagationData() {
        assert (this.mUnitPropagationData != null);
        UnitPropagationData unitPropagationData = this.mUnitPropagationData;
        return unitPropagationData;
    }

    public boolean isUnit() {
        assert (!this.mHasBeenDisposed);
        return this.determineClauseState() == EprClauseState.Unit;
    }

    public boolean isConflict() {
        assert (!this.mHasBeenDisposed);
        return this.determineClauseState() == EprClauseState.Conflict;
    }

    public DawgState<ApplicationTerm, Boolean> getConflictPoints() {
        assert (this.isConflict());
        assert (this.mConflictPoints != null) : "this should have been set somewhere..";
        return this.mConflictPoints;
    }

    public DawgState<ApplicationTerm, Boolean> getUndecidedPoints() {
        return this.mDawgFactory.createMapped(this.mDawg, n -> n == -3);
    }

    public List<ClauseLiteral> getLiterals() {
        assert (!this.mHasBeenDisposed);
        return this.mLiterals;
    }

    public List<Literal[]> computeAllGroundings(List<TTSubstitution> list) {
        ArrayList<Literal[]> arrayList = new ArrayList<Literal[]>();
        for (TTSubstitution tTSubstitution : list) {
            ArrayList<Literal> arrayList2 = this.getSubstitutedLiterals(tTSubstitution);
            arrayList.add(arrayList2.toArray(new Literal[arrayList2.size()]));
        }
        return arrayList;
    }

    public List<Literal[]> computeAllGroundings(HashSet<ApplicationTerm> hashSet) {
        ArrayList<TTSubstitution> arrayList = EprHelpers.getAllInstantiations(this.getVariables(), hashSet);
        return this.computeAllGroundings(arrayList);
    }

    protected ArrayList<Literal> getSubstitutedLiterals(TTSubstitution tTSubstitution) {
        assert (false) : "TODO reimplement";
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        String string = "";
        for (ClauseLiteral clauseLiteral : this.getLiterals()) {
            stringBuilder.append(string);
            stringBuilder.append(clauseLiteral.toString());
            string = ", ";
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public Set<Clause> getGroundings(DawgState<ApplicationTerm, Boolean> dawgState) {
        if (this.mIsGround) {
            assert (dawgState.isFinal());
            return dawgState.getFinalValue() != false ? Collections.singleton(new Clause(this.mDpllLiterals.toArray(new Literal[this.mDpllLiterals.size()]))) : Collections.emptySet();
        }
        HashSet<Clause> hashSet = new HashSet<Clause>();
        for (List<ApplicationTerm> list : DawgFactory.getSet(dawgState)) {
            Set<Literal> set = this.getGroundingForPoint(list).getDomain();
            hashSet.add(new Clause(set.toArray(new Literal[set.size()])));
        }
        return hashSet;
    }

    private BinaryRelation<Literal, ClauseLiteral> getGroundingForPoint(List<ApplicationTerm> list) {
        TTSubstitution tTSubstitution = new TTSubstitution(this.mVariables, list);
        HashSet<Literal> hashSet = new HashSet<Literal>();
        BinaryRelation<Literal, ClauseLiteral> binaryRelation = new BinaryRelation<Literal, ClauseLiteral>();
        for (ClauseLiteral clauseLiteral : this.getLiterals()) {
            if (clauseLiteral instanceof ClauseEprQuantifiedLiteral) {
                ClauseEprQuantifiedLiteral clauseEprQuantifiedLiteral = (ClauseEprQuantifiedLiteral)clauseLiteral;
                Term[] termArray = clauseEprQuantifiedLiteral.mArgumentTerms.toArray(new Term[clauseEprQuantifiedLiteral.mArgumentTerms.size()]);
                TermTuple termTuple = tTSubstitution.apply(new TermTuple(termArray));
                assert (termTuple.getFreeVars().size() == 0);
                EprPredicateAtom eprPredicateAtom = clauseEprQuantifiedLiteral.getEprPredicate().getAtomForTermTuple(termTuple, this.mEprTheory.getTheory(), this.mEprTheory.getClausifier().getStackLevel(), clauseEprQuantifiedLiteral.getAtom().getSourceAnnotation());
                Literal literal = clauseLiteral.getPolarity() ? eprPredicateAtom : eprPredicateAtom.negate();
                binaryRelation.addPair(literal, clauseEprQuantifiedLiteral);
                hashSet.add(literal);
                continue;
            }
            binaryRelation.addPair(clauseLiteral.getLiteral(), clauseLiteral);
            hashSet.add(clauseLiteral.getLiteral());
        }
        return binaryRelation;
    }

    public EprClause factorIfPossible() {
        for (List<ApplicationTerm> list : DawgFactory.getSet(this.getConflictPoints())) {
            BinaryRelation<Literal, ClauseLiteral> binaryRelation = this.getGroundingForPoint(list);
            for (Literal literal : binaryRelation.getDomain()) {
                Set<ClauseLiteral> set = binaryRelation.getImage(literal);
                if (set.size() == 1) continue;
                assert (set.size() > 1);
                assert (set.size() == 2) : "TODO: deal with factoring for more than two literals";
                ClauseEprQuantifiedLiteral clauseEprQuantifiedLiteral = null;
                Object object2 = null;
                for (ClauseLiteral object3 : set) {
                    assert (object3 instanceof ClauseEprLiteral);
                    if (clauseEprQuantifiedLiteral == null && object3 instanceof ClauseEprQuantifiedLiteral) {
                        clauseEprQuantifiedLiteral = (ClauseEprQuantifiedLiteral)object3;
                        continue;
                    }
                    if (object2 != null || clauseEprQuantifiedLiteral == null && object3 instanceof ClauseEprQuantifiedLiteral) continue;
                    object2 = (ClauseEprLiteral)object3;
                }
                assert (object2 != null && clauseEprQuantifiedLiteral != null && !object2.equals(clauseEprQuantifiedLiteral));
                this.mEprTheory.getLogger().debug("EPRDEBUG: (EprClause): factoring " + String.valueOf(this));
                EprClause eprClause = this.mEprTheory.getEprClauseFactory().getFactoredClause(clauseEprQuantifiedLiteral, (ClauseEprLiteral)object2);
                assert (eprClause.isConflict()) : "we only factor conflicts -- we should get a conflict out, too.";
                return eprClause;
            }
        }
        return this;
    }
}

