/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Analyze;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.GetRandomNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.GetRandomNwaTv;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.ToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;

public final class RandomNwaBenchmarkCreator {
    public static final File DEFAULT_PATH = new File(new File(System.getProperty("user.home"), "Desktop"), "randomNwaBenchmark");
    public static final int LOG_EVERY = 100;
    private static final int PERC_LOWER_BOUND = 0;
    private static final int PERC_TO_DOUBLE = 100;
    private static final int PERC_UPPER_BOUND = 100;
    private final float mAcceptance;
    private final int mAlphabetSize;
    private final float mCallTotality;
    private final float mHierarchicalPredecessorDensity;
    private final float mInternalTotality;
    private String mPreamble;
    private final float mReturnTotality;
    private final AutomataLibraryServices mServices;
    private final int mSize;
    private final boolean mUseRandomTvModel;

    public RandomNwaBenchmarkCreator(int n, int n2, float f, float f2, float f3, float f4) throws IllegalArgumentException {
        this.mSize = n;
        this.mAlphabetSize = n2;
        this.mAcceptance = this.ensureIsPercentage(f);
        this.mInternalTotality = this.ensureIsPercentage(f2);
        this.mCallTotality = this.ensureIsPercentage(f3);
        this.mReturnTotality = this.ensureIsPercentage(f4);
        this.mHierarchicalPredecessorDensity = -1.0f;
        this.mUseRandomTvModel = false;
        this.mServices = new AutomataLibraryServices((IUltimateServiceProvider)new ToolchainStorage());
        this.mPreamble = "";
    }

    public RandomNwaBenchmarkCreator(int n, int n2, float f, float f2, float f3, float f4, float f5) throws IllegalArgumentException {
        this.mSize = n;
        this.mAlphabetSize = n2;
        this.mAcceptance = this.ensureIsPercentage(f);
        this.mInternalTotality = f2;
        this.mCallTotality = f3;
        this.mReturnTotality = f4;
        this.mHierarchicalPredecessorDensity = f5;
        this.mUseRandomTvModel = true;
        this.mServices = new AutomataLibraryServices((IUltimateServiceProvider)new ToolchainStorage());
        this.mPreamble = "";
    }

    public void createAndSaveABenchmark(int n) throws IOException {
        this.createAndSaveABenchmark(n, DEFAULT_PATH, 100);
    }

    public void createAndSaveABenchmark(int n, File file) throws IOException {
        this.createAndSaveABenchmark(n, file, 100);
    }

    public void createAndSaveABenchmark(int n, File file, int n2) throws IOException {
        Object object = null;
        double d = this.percentageToDouble(this.mInternalTotality);
        double d2 = this.percentageToDouble(this.mCallTotality);
        double d3 = this.percentageToDouble(this.mReturnTotality);
        double d4 = this.percentageToDouble(this.mAcceptance);
        String string = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String string2 = "randomNwaAutomata_" + string;
        if (!file.exists()) {
            file.mkdirs();
        } else if (!file.isDirectory()) {
            throw new IllegalArgumentException("The provided path exists but is no directory: " + String.valueOf(file));
        }
        int n3 = 1;
        while (n3 <= n) {
            Object object2;
            if (n3 % n2 == 0) {
                System.out.println("Created automata: " + n3);
            }
            object = this.mUseRandomTvModel ? new GetRandomNwaTv(this.mServices, this.mSize, this.mAlphabetSize, this.mAlphabetSize, this.mAlphabetSize, (int)this.mInternalTotality, (int)this.mCallTotality, (int)this.mReturnTotality, (int)this.mHierarchicalPredecessorDensity, (int)this.mAcceptance).getResult() : new GetRandomNwa(this.mServices, this.mAlphabetSize, this.mSize, d, d2, d3, d4, 0L).getResult();
            if (n3 == 1) {
                object2 = new Analyze(this.mServices, object, true);
                System.out.println("#Internal: " + ((Analyze)object2).getNumberOfTransitions(Analyze.SymbolType.INTERNAL));
                System.out.println("#Call: " + ((Analyze)object2).getNumberOfTransitions(Analyze.SymbolType.CALL));
                System.out.println("#Return: " + ((Analyze)object2).getNumberOfTransitions(Analyze.SymbolType.RETURN));
            }
            object2 = "_" + n3;
            File file2 = new File(file, string2 + (String)object2 + ".ats");
            Throwable throwable = null;
            Object var19_16 = null;
            try (FileWriter fileWriter = new FileWriter(file2);){
                fileWriter.write(this.mPreamble + String.valueOf(object));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ++n3;
        }
    }

    public void createAndSaveABenchmark(int n, String string) throws IOException {
        this.createAndSaveABenchmark(n, new File(DEFAULT_PATH, string), 100);
    }

    public void setPreamble(String string) {
        this.mPreamble = string;
    }

    private float ensureIsPercentage(float f) throws IllegalArgumentException {
        if (f < 0.0f || f > 100.0f) {
            throw new IllegalArgumentException("The given value is no percentage: " + f);
        }
        return f;
    }

    private double percentageToDouble(float f) {
        return f / 100.0f;
    }

    public static void main(String[] stringArray) throws IOException {
        RandomNwaBenchmarkCreator.coverSpaceBenchmark(100, 2, 20, 0, true, 50.0f, 50.0f, 1.0f, 300.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f, true);
    }

    private static void coverSpaceBenchmark(int n, int n2, int n3, int n4, boolean bl, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, boolean bl2) throws IOException {
        int n5;
        LinkedList<Number> linkedList;
        int n6;
        int n7;
        int n8;
        int n9;
        System.out.println("Starting creation of space coverage sets...");
        int n10 = (int)Math.ceil((f2 - f) / f11);
        if (n10 == 0) {
            n10 = 1;
        }
        if ((n9 = (int)Math.ceil((f4 - f3) / f11)) == 0) {
            n9 = 1;
        }
        if ((n8 = (int)Math.ceil((f6 - f5) / f11)) == 0) {
            n8 = 1;
        }
        if ((n7 = (int)Math.ceil((f8 - f7) / f11)) == 0) {
            n7 = 1;
        }
        if ((n6 = (int)Math.ceil((f10 - f9) / f11)) == 0) {
            n6 = 1;
        }
        if (bl2) {
            linkedList = new LinkedList<Number>();
            linkedList.add(n10);
            linkedList.add(n9);
            linkedList.add(n8);
            linkedList.add(n7);
            linkedList.add(n6);
            n5 = (Integer)Collections.max(linkedList);
        } else {
            n5 = n10 * n9 * n8 * n7 * n6;
        }
        System.out.println("Sets to create: " + n5);
        System.out.println("---------------");
        if (bl2) {
            linkedList = new LinkedList();
            linkedList.add(Float.valueOf(f));
            linkedList.add(Float.valueOf(f3));
            linkedList.add(Float.valueOf(f5));
            linkedList.add(Float.valueOf(f7));
            linkedList.add(Float.valueOf(f9));
            float f12 = ((Float)Collections.min(linkedList)).floatValue();
            LinkedList<Float> linkedList2 = new LinkedList<Float>();
            linkedList2.add(Float.valueOf(f2));
            linkedList2.add(Float.valueOf(f4));
            linkedList2.add(Float.valueOf(f6));
            linkedList2.add(Float.valueOf(f8));
            linkedList2.add(Float.valueOf(f10));
            float f13 = ((Float)Collections.max(linkedList2)).floatValue();
            float f14 = f12;
            while (f14 <= f13) {
                float f15 = f14 < f ? f : (f14 > f2 ? f2 : f14);
                float f16 = f14 < f3 ? f3 : (f14 > f4 ? f4 : f14);
                float f17 = f14 < f5 ? f5 : (f14 > f6 ? f6 : f14);
                float f18 = f14 < f7 ? f7 : (f14 > f8 ? f8 : f14);
                float f19 = f14 < f9 ? f9 : (f14 > f10 ? f10 : f14);
                RandomNwaBenchmarkCreator.createExplicitSet(n, n2, f15, f16, f17, f18, f19, n3, n4, bl);
                System.out.println("Steps to go: " + --n5);
                f14 += f11;
            }
        } else {
            float f20 = f;
            while (f20 <= f2) {
                float f21 = f3;
                while (f21 <= f4) {
                    float f22 = f5;
                    while (f22 <= f6) {
                        float f23 = f7;
                        while (f23 <= f8) {
                            float f24 = f9;
                            while (f24 <= f10) {
                                RandomNwaBenchmarkCreator.createExplicitSet(n, n2, f20, f21, f22, f23, f24, n3, n4, bl);
                                System.out.println("Steps to go: " + --n5);
                                f24 += f11;
                            }
                            f23 += f11;
                        }
                        f22 += f11;
                    }
                    f21 += f11;
                }
                f20 += f11;
            }
        }
    }

    private static void createExplicitSet(int n, int n2, float f, float f2, float f3, float f4, float f5, int n3, int n4, boolean bl) throws IOException {
        String string = switch (n4) {
            case 0 -> "compareReduceNwaSimulation(removeDeadEnds(nwa));";
            case 1 -> "reduceNwaDirectSimulation(removeDeadEnds(nwa), false);";
            case 2 -> "minimizeNwaPmaxSat(removeDeadEnds(nwa));";
            default -> "";
        };
        String string2 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date());
        String string3 = "// Random nwa automaton dumped by RandomNwaBenchmarkCreator at " + string2 + "\n// Author: Daniel Tischner {@literal <zabuza.dev@gmail.com>}\n\n" + string + "\n\n";
        RandomNwaBenchmarkCreator randomNwaBenchmarkCreator = bl ? new RandomNwaBenchmarkCreator(n, n2, f, f2, f3, f4, f5) : new RandomNwaBenchmarkCreator(n, n2, f, f2, f3, f4);
        randomNwaBenchmarkCreator.setPreamble(string3);
        System.out.println("Starting automata generation.");
        String string4 = bl ? "#" + n3 + "_n" + n + "_k" + n2 + "_f" + f + "%_ti" + f2 + "%_tc" + f3 + "%_tr" + f4 + "%_th" + f5 + "%" : "#" + n3 + "_n" + n + "_k" + n2 + "_f" + f + "%_ti" + f2 + "%_tc" + f3 + "%_tr" + f4 + "%";
        randomNwaBenchmarkCreator.createAndSaveABenchmark(n3, string4);
        System.out.println("Finished automata generation.");
        System.out.println("Overview label:");
        System.out.println(string4);
    }
}

