/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomatonCache;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NwaCacheBookkeeping;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNetTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.Marking;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetNot1SafeException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IPetriNet2FiniteAutomatonStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LazyPetriNet2FiniteAutomaton<L, S>
implements INwaOutgoingLetterAndTransitionProvider<L, S> {
    private final IPetriNetTransitionProvider<L, S> mOperand;
    private final Predicate<Marking<S>> mIsKnownDeadEnd;
    private final IPetriNet2FiniteAutomatonStateFactory<S> mStateFactory;
    private final Map<Marking<S>, S> mMarking2State = new HashMap<Marking<S>, S>();
    private final Map<S, Marking<S>> mState2Marking = new HashMap<S, Marking<S>>();
    private final NwaCacheBookkeeping<L, S> mCacheBookkeeping = new NwaCacheBookkeeping();
    private final NestedWordAutomatonCache<L, S> mCache;

    public LazyPetriNet2FiniteAutomaton(AutomataLibraryServices automataLibraryServices, IPetriNet2FiniteAutomatonStateFactory<S> iPetriNet2FiniteAutomatonStateFactory, IPetriNetTransitionProvider<L, S> iPetriNetTransitionProvider, Predicate<Marking<S>> predicate) throws PetriNetNot1SafeException {
        this.mOperand = iPetriNetTransitionProvider;
        this.mIsKnownDeadEnd = predicate;
        this.mStateFactory = iPetriNet2FiniteAutomatonStateFactory;
        this.mCache = new NestedWordAutomatonCache(automataLibraryServices, new VpAlphabet(this.mOperand.getAlphabet()), iPetriNet2FiniteAutomatonStateFactory);
        this.constructState(new Marking(ImmutableSet.of(this.mOperand.getInitialPlaces())), true);
    }

    @Override
    @Deprecated
    public IStateFactory<S> getStateFactory() {
        return this.mStateFactory;
    }

    @Override
    public VpAlphabet<L> getVpAlphabet() {
        return this.mCache.getVpAlphabet();
    }

    @Override
    public S getEmptyStackState() {
        return this.mCache.getEmptyStackState();
    }

    @Override
    public Iterable<S> getInitialStates() {
        return this.mCache.getInitialStates();
    }

    @Override
    public boolean isInitial(S s) {
        return this.mCache.isInitial(s);
    }

    @Override
    public boolean isFinal(S s) {
        return this.mCache.isFinal(s);
    }

    @Override
    public int size() {
        return this.mMarking2State.size();
    }

    @Override
    public String sizeInformation() {
        return "currently " + this.size() + " states, but on-demand construction may add more states";
    }

    @Override
    public Set<L> lettersInternal(S s) {
        Marking<S> marking = this.mState2Marking.get(s);
        if (marking == null) {
            return this.mCache.lettersInternal(s);
        }
        return this.getOutgoingNetTransitions(marking).map(Transition::getSymbol).collect(Collectors.toSet());
    }

    @Override
    public Iterable<OutgoingInternalTransition<L, S>> internalSuccessors(S s, L l) {
        if (!this.mCacheBookkeeping.isCachedInternal(s, l)) {
            this.computeOutgoingTransitions(s, l);
            if (this.mCacheBookkeeping.countCachedInternal(s) == this.lettersInternal(s).size()) {
                this.mState2Marking.remove(s);
            }
        }
        return this.mCache.internalSuccessors(s, l);
    }

    @Override
    public Iterable<OutgoingInternalTransition<L, S>> internalSuccessors(S s) {
        if (this.mState2Marking.containsKey(s)) {
            for (L l : this.lettersInternal(s)) {
                if (this.mCacheBookkeeping.isCachedInternal(s, l)) continue;
                this.computeOutgoingTransitions(s, l);
            }
            this.mState2Marking.remove(s);
        }
        return this.mCache.internalSuccessors(s);
    }

    @Override
    public Iterable<OutgoingCallTransition<L, S>> callSuccessors(S s, L l) {
        return Collections.emptySet();
    }

    @Override
    public Iterable<OutgoingReturnTransition<L, S>> returnSuccessors(S s, S s2, L l) {
        return Collections.emptySet();
    }

    private void computeOutgoingTransitions(S s, L l) {
        Marking<S> marking = this.mState2Marking.get(s);
        if (marking == null) {
            return;
        }
        this.getOutgoingNetTransitions(marking).filter(transition -> transition.getSymbol().equals(l)).distinct().forEach(transition -> this.createAutomatonTransition(s, marking, (Transition<L, S>)transition));
    }

    private void createAutomatonTransition(S s, Marking<S> marking, Transition<L, S> transition) {
        try {
            S s2 = this.getOrConstructState(marking.fireTransition(transition));
            if (s2 != null) {
                this.mCache.addInternalTransition(s, transition.getSymbol(), s2);
            }
            this.mCacheBookkeeping.reportCachedInternal(s, transition.getSymbol());
        }
        catch (PetriNetNot1SafeException petriNetNot1SafeException) {
            throw new IllegalArgumentException("Petri net must be 1-safe!", petriNetNot1SafeException);
        }
    }

    private S getOrConstructState(Marking<S> marking) {
        if (!this.mMarking2State.containsKey(marking)) {
            S s = this.constructState(marking, false);
            this.mMarking2State.put(marking, s);
            return s;
        }
        return this.mMarking2State.get(marking);
    }

    private S constructState(Marking<S> marking, boolean bl) {
        if (this.isKnownDeadEnd(marking)) {
            return null;
        }
        S s = this.mStateFactory.getContentOnPetriNet2FiniteAutomaton(marking);
        this.mState2Marking.put(s, marking);
        assert (bl == new Marking(ImmutableSet.of(this.mOperand.getInitialPlaces())).equals(marking)) : "Wrong initial state";
        boolean bl2 = this.mOperand.isAccepting((S)marking);
        this.mCache.addState(bl, bl2, s);
        return s;
    }

    private Stream<Transition<L, S>> getOutgoingNetTransitions(Marking<S> marking) {
        return marking.stream().flatMap(object -> this.mOperand.getSuccessors(object).stream()).filter(marking::isTransitionEnabled);
    }

    private boolean isKnownDeadEnd(Marking<S> marking) {
        if (this.mIsKnownDeadEnd == null) {
            return false;
        }
        return this.mIsKnownDeadEnd.test(marking);
    }
}

