/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PredicateHelper<LETTER extends IIcfgTransition<?>> {
    private final IPredicateUnifier mPredicateUnifier;
    private final PredicateTransformer<Term, IPredicate, TransFormula> mPredTransformer;
    private final ILogger mLogger;
    private final ManagedScript mScript;
    private final IUltimateServiceProvider mServices;

    public PredicateHelper(IPredicateUnifier iPredicateUnifier, PredicateTransformer<Term, IPredicate, TransFormula> predicateTransformer, ILogger iLogger, ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mPredicateUnifier = iPredicateUnifier;
        this.mPredTransformer = predicateTransformer;
        this.mScript = managedScript;
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
    }

    public UnmodifiableTransFormula traceToTf(List<LETTER> list) {
        ArrayList<UnmodifiableTransFormula> arrayList = new ArrayList<UnmodifiableTransFormula>();
        for (IIcfgTransition iIcfgTransition : list) {
            arrayList.add(iIcfgTransition.getTransformula());
        }
        return TransFormulaUtils.sequentialComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, (boolean)false, (boolean)false, (boolean)false, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, arrayList);
    }

    public List<UnmodifiableTransFormula> traceToListOfTfs(List<LETTER> list) {
        ArrayList<UnmodifiableTransFormula> arrayList = new ArrayList<UnmodifiableTransFormula>();
        for (IIcfgTransition iIcfgTransition : list) {
            arrayList.add(iIcfgTransition.getTransformula());
        }
        return arrayList;
    }

    public Term normalizeTerm(UnmodifiableTransFormula unmodifiableTransFormula) {
        HashMap<Term, TermVariable> hashMap = new HashMap<Term, TermVariable>();
        Term term = unmodifiableTransFormula.getFormula();
        HashMap<IProgramVar, TermVariable> hashMap2 = new HashMap<IProgramVar, TermVariable>();
        HashMap<IProgramVar, TermVariable> hashMap3 = new HashMap<IProgramVar, TermVariable>();
        for (Map.Entry entry : unmodifiableTransFormula.getOutVars().entrySet()) {
            hashMap.put((Term)entry.getValue(), ((IProgramVar)entry.getKey()).getTermVariable());
            hashMap3.put((IProgramVar)entry.getKey(), ((IProgramVar)entry.getKey()).getTermVariable());
        }
        for (Map.Entry entry : unmodifiableTransFormula.getInVars().entrySet()) {
            hashMap.put((Term)entry.getValue(), ((IProgramVar)entry.getKey()).getTermVariable());
            hashMap2.put((IProgramVar)entry.getKey(), ((IProgramVar)entry.getKey()).getTermVariable());
        }
        return Substitution.apply((ManagedScript)this.mScript, hashMap, (Term)term);
    }

    public UnmodifiableTransFormula normalizeTerm(Term term, UnmodifiableTransFormula unmodifiableTransFormula, Boolean bl) {
        Term term2;
        HashMap<IProgramVar, TermVariable> hashMap;
        HashMap<IProgramVar, TermVariable> hashMap2;
        HashMap<Term, TermVariable> hashMap3 = new HashMap<Term, TermVariable>();
        Term term3 = term;
        if (bl.booleanValue()) {
            TermVariable termVariable;
            hashMap2 = new HashMap<IProgramVar, TermVariable>();
            hashMap = new HashMap<IProgramVar, TermVariable>();
            for (Map.Entry object2 : unmodifiableTransFormula.getOutVars().entrySet()) {
                termVariable = this.mScript.constructFreshCopy(((IProgramVar)object2.getKey()).getTermVariable());
                hashMap3.put((Term)object2.getValue(), termVariable);
                hashMap.put((IProgramVar)object2.getKey(), termVariable);
            }
            for (Map.Entry entry : unmodifiableTransFormula.getInVars().entrySet()) {
                termVariable = this.mScript.constructFreshCopy(((IProgramVar)entry.getKey()).getTermVariable());
                hashMap3.put((Term)entry.getValue(), termVariable);
                hashMap2.put((IProgramVar)entry.getKey(), termVariable);
            }
            term2 = Substitution.apply((ManagedScript)this.mScript, hashMap3, (Term)term3);
        } else {
            hashMap2 = new HashMap(unmodifiableTransFormula.getInVars());
            hashMap = new HashMap(unmodifiableTransFormula.getOutVars());
            term2 = term3;
        }
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(hashMap2, hashMap, true, Collections.emptySet(), true, Collections.emptySet(), false);
        transFormulaBuilder.setFormula(term2);
        transFormulaBuilder.addAuxVarsButRenameToFreshCopies(unmodifiableTransFormula.getAuxVars(), this.mScript);
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        return transFormulaBuilder.finishConstruction(this.mScript);
    }

    public Term makeReflexive(Term term, UnmodifiableTransFormula unmodifiableTransFormula) {
        Map map = unmodifiableTransFormula.getInVars();
        Map map2 = unmodifiableTransFormula.getOutVars();
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (Map.Entry term22 : map.entrySet()) {
            IProgramVar iProgramVar = (IProgramVar)term22.getKey();
            TermVariable termVariable = (TermVariable)term22.getValue();
            TermVariable termVariable2 = (TermVariable)map2.get(iProgramVar);
            Term term2 = this.mScript.getScript().term("=", new Term[]{termVariable, termVariable2});
            arrayList.add(term2);
        }
        Term term3 = SmtUtils.and((Script)this.mScript.getScript(), arrayList);
        return SmtUtils.or((Script)this.mScript.getScript(), (Term[])new Term[]{term, term3});
    }

    public boolean predContainsTfVar(IPredicate iPredicate, UnmodifiableTransFormula unmodifiableTransFormula) {
        Set set = iPredicate.getVars();
        Set set2 = unmodifiableTransFormula.getInVars().keySet();
        Set set3 = unmodifiableTransFormula.getOutVars().keySet();
        for (IProgramVar iProgramVar : set) {
            if (!set2.contains(iProgramVar) && !set3.contains(iProgramVar)) continue;
            return true;
        }
        return false;
    }
}

