/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class BenchmarkRecord {
    private static int mNumOfNBAs = 0;
    private static int mNumOfSDBAs = 0;
    private static int mNumOfDBAs = 0;
    private static int mNumOfFAs = 0;
    private static PrintWriter mOutput = null;
    private static String mOutputFile = null;

    public static boolean includeDiffTransition() {
        return true;
    }

    public static boolean canDump() {
        File file = new File("machine.conf");
        return file.exists();
    }

    private BenchmarkRecord() {
    }

    public static void start(String string, String string2) {
        if (mOutputFile == null) {
            mOutputFile = "Info.log";
        }
        try {
            mOutput = new PrintWriter(new BufferedWriter(new FileWriter(mOutputFile, true)));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        mOutput.println("\n" + string);
        mOutput.println(string2);
        mOutput.close();
        BenchmarkRecord.clear();
    }

    private static void clear() {
        mNumOfNBAs = 0;
        mNumOfSDBAs = 0;
        mNumOfDBAs = 0;
        mNumOfFAs = 0;
    }

    public static void addComplementAutomaton(int n, int n2, int n3) {
        if (mOutputFile == null) {
            return;
        }
        try {
            mOutput = new PrintWriter(new BufferedWriter(new FileWriter(mOutputFile, true)));
            mOutput.print("(" + n + ", " + n2 + "), ");
            mOutput.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void addDiffComparison(int n, int n2, int n3) {
        if (mOutputFile == null) {
            return;
        }
        try {
            mOutput = new PrintWriter(new BufferedWriter(new FileWriter(mOutputFile, true)));
            mOutput.print("( BA:" + n + ", GBA: " + n2 + ", GBA2BA: " + n3 + "), ");
            mOutput.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void addInterpolantOrDifferenceAutomaton(int n, int n2, int n3, int n4, int n5, int n6) {
        AutomatonType automatonType = null;
        if (n4 == 0) {
            automatonType = AutomatonType.NBA;
            ++mNumOfNBAs;
        } else if (n4 == 1) {
            automatonType = AutomatonType.SDBA;
            ++mNumOfSDBAs;
        } else if (n4 == 2) {
            automatonType = AutomatonType.DBA;
            ++mNumOfDBAs;
        } else if (n4 == 3) {
            automatonType = AutomatonType.FA;
            ++mNumOfFAs;
        }
        if (mOutputFile == null) {
            return;
        }
        try {
            mOutput = new PrintWriter(new BufferedWriter(new FileWriter(mOutputFile, true)));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        AutomatonInfo automatonInfo = new AutomatonInfo(n, n2, n3, automatonType);
        mOutput.print("[" + String.valueOf(automatonInfo) + ", " + n5 + ", " + n6 + "], ");
        mOutput.close();
    }

    public static void finish() {
        if (mOutputFile == null) {
            return;
        }
        try {
            mOutput = new PrintWriter(new BufferedWriter(new FileWriter(mOutputFile, true)));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        mOutput.println();
        mOutput.println("# interpolant NBAs = " + mNumOfNBAs);
        mOutput.println("# interpolant SDBAs = " + mNumOfSDBAs);
        mOutput.println("# interpolant DBAs = " + mNumOfDBAs);
        mOutput.println("# interpolant FAs = " + mNumOfFAs);
        mOutput.close();
    }

    private static class AutomatonInfo {
        int mNumOfStates;
        int mNumOfTrans;
        AutomatonType mAutType;
        int mIteration;

        AutomatonInfo(int n, int n2, int n3, AutomatonType automatonType) {
            this.mIteration = n;
            this.mNumOfStates = n2;
            this.mNumOfTrans = n3;
            this.mAutType = automatonType;
        }

        public String toString() {
            return "( " + this.mIteration + ", " + this.mNumOfStates + ", " + this.mNumOfTrans + ", " + String.valueOf((Object)this.mAutType) + ")";
        }
    }

    private static enum AutomatonType {
        NBA,
        SDBA,
        DBA,
        FA;


        public String toString() {
            if (this == NBA) {
                return "NBA";
            }
            if (this == SDBA) {
                return "SDBA";
            }
            if (this == DBA) {
                return "DBA";
            }
            return "FA";
        }
    }
}

