/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.VPStatistics;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.SimpleCsvProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;

public class VPDomainBenchmark
implements ICsvProviderProvider<Integer> {
    private int mLocationsCounter;
    private int mTransitionsCounter;
    private boolean mAlreadyGeneratedColumnTitlesAndResults = false;
    private final List<String> mColumnTitles = new ArrayList<String>();
    private final List<Integer> mResults = new ArrayList<Integer>();
    Map<VPStatistics, Integer> mLocationAggregateStatistics = new HashMap<VPStatistics, Integer>();
    Map<VPStatistics, Integer> mTransitionAggregateStatistics = new HashMap<VPStatistics, Integer>();

    public ICsvProvider<Integer> createCsvProvider() {
        this.generateColumnTitlesAndResults();
        SimpleCsvProvider simpleCsvProvider = new SimpleCsvProvider(this.mColumnTitles);
        simpleCsvProvider.addRow(this.mResults);
        return simpleCsvProvider;
    }

    protected void generateColumnTitlesAndResults() {
        VPStatistics vPStatistics;
        if (this.mAlreadyGeneratedColumnTitlesAndResults) {
            return;
        }
        this.mColumnTitles.add("#Locations");
        this.mResults.add(this.mLocationsCounter);
        VPStatistics[] vPStatisticsArray = VPStatistics.values();
        int n = vPStatisticsArray.length;
        int n2 = 0;
        while (n2 < n) {
            vPStatistics = vPStatisticsArray[n2];
            this.mColumnTitles.add("LocStat_" + vPStatistics.toString());
            this.mResults.add(this.mLocationAggregateStatistics.get(vPStatistics));
            ++n2;
        }
        this.mColumnTitles.add("#Transitions");
        this.mResults.add(this.mTransitionsCounter);
        vPStatisticsArray = VPStatistics.values();
        n = vPStatisticsArray.length;
        n2 = 0;
        while (n2 < n) {
            vPStatistics = vPStatisticsArray[n2];
            this.mColumnTitles.add("TransStat_" + vPStatistics.toString());
            this.mResults.add(this.mTransitionAggregateStatistics.get(vPStatistics));
            ++n2;
        }
        this.mAlreadyGeneratedColumnTitlesAndResults = true;
    }

    public void setLocationsCounter(int n) {
        this.mLocationsCounter = n;
    }

    public void setTransitionsCounter(int n) {
        this.mTransitionsCounter = n;
    }

    public String toString() {
        this.generateColumnTitlesAndResults();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        int n = 0;
        while (n < this.mColumnTitles.size()) {
            stringBuilder.append(String.format("%-40s : %7d %n", this.mColumnTitles.get(n), this.mResults.get(n)));
            ++n;
        }
        return stringBuilder.toString();
    }

    public void reportStatsForLocation(Function<VPStatistics, Integer> function) {
        VPStatistics[] vPStatisticsArray = VPStatistics.values();
        int n = vPStatisticsArray.length;
        int n2 = 0;
        while (n2 < n) {
            VPStatistics vPStatistics = vPStatisticsArray[n2];
            Integer n3 = this.mLocationAggregateStatistics.get(vPStatistics);
            if (n3 == null) {
                n3 = VPStatistics.getInitialValue((VPStatistics)vPStatistics);
            }
            Integer n4 = function.apply(vPStatistics);
            BinaryOperator binaryOperator = VPStatistics.getAggregator((VPStatistics)vPStatistics);
            Integer n5 = (Integer)binaryOperator.apply(n3, n4);
            this.mLocationAggregateStatistics.put(vPStatistics, n5);
            ++n2;
        }
    }

    public void reportStatsForTransitionRelation(Function<VPStatistics, Integer> function) {
        VPStatistics[] vPStatisticsArray = VPStatistics.values();
        int n = vPStatisticsArray.length;
        int n2 = 0;
        while (n2 < n) {
            VPStatistics vPStatistics = vPStatisticsArray[n2];
            Integer n3 = this.mTransitionAggregateStatistics.get(vPStatistics);
            if (n3 == null) {
                n3 = VPStatistics.getInitialValue((VPStatistics)vPStatistics);
            }
            Integer n4 = function.apply(vPStatistics);
            BinaryOperator binaryOperator = VPStatistics.getAggregator((VPStatistics)vPStatistics);
            Integer n5 = (Integer)binaryOperator.apply(n3, n4);
            this.mTransitionAggregateStatistics.put(vPStatistics, n5);
            ++n2;
        }
    }
}

