/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.simplify;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import de.uni_freiburg.informatik.ultimate.logic.simplification.SimplifyDDA;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.DAGSize;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class SimplifyDDAWithTimeout
extends SimplifyDDA {
    private final IUltimateServiceProvider mServices;
    private Term mInputTerm;
    private final Term mContext;
    private long mStartTime;

    public SimplifyDDAWithTimeout(Script script, IUltimateServiceProvider iUltimateServiceProvider) {
        this(script, true, iUltimateServiceProvider);
    }

    public SimplifyDDAWithTimeout(Script script, boolean bl, IUltimateServiceProvider iUltimateServiceProvider) {
        this(script, bl, iUltimateServiceProvider, null);
    }

    public SimplifyDDAWithTimeout(Script script, boolean bl, IUltimateServiceProvider iUltimateServiceProvider, Term term) {
        super(script, bl);
        this.mServices = iUltimateServiceProvider;
        this.mContext = term;
    }

    protected SimplifyDDA.Redundancy getRedundancy(Term term) {
        if (!this.mServices.getProgressMonitorService().continueProcessing()) {
            throw new ToolchainCanceledException(((Object)((Object)this)).getClass(), "simplifying term of DAG size " + new DAGSize().size(this.mInputTerm) + " for " + this.getElapsedTimeInMilliseconds() + "ms.");
        }
        return super.getRedundancy(term);
    }

    public Script.LBool checkEquivalence(Term term, Term term2) {
        Term term3 = this.mScript.term("=", new Term[]{term, term2});
        Script.LBool lBool = Util.checkSat((Script)this.mScript, (Term)Util.not((Script)this.mScript, (Term)term3));
        return lBool;
    }

    /*
     * WARNING - void declaration
     */
    public Term getSimplifiedTerm(Term term) {
        Collection<TermVariable> collection;
        this.mInputTerm = term;
        this.mStartTime = System.nanoTime();
        if (!SmtSortUtils.isBoolSort(term.getSort())) {
            return term;
        }
        Term term3 = term;
        this.mScript.echo(new QuotedObject("Begin Simplifier"));
        this.mScript.push(1);
        if (this.mContext == null) {
            collection = Arrays.asList(term.getFreeVars());
        } else {
            collection = new HashSet<TermVariable>(Arrays.asList(term.getFreeVars()));
            collection.addAll(Arrays.asList(this.mContext.getFreeVars()));
        }
        Map<TermVariable, Term> map = SmtUtils.termVariables2Constants(this.mScript, collection, true);
        final TermVariable[] termVariableArray = new TermVariable[map.size()];
        final Term[] termArray = new Term[map.size()];
        int n = 0;
        for (Map.Entry<TermVariable, Term> term22 : map.entrySet()) {
            termVariableArray[n] = term22.getKey();
            termArray[n] = term22.getValue();
            ++n;
        }
        if (this.mContext != null) {
            Term term2 = new FormulaUnLet().unlet(this.mScript.let(termVariableArray, termArray, this.mContext));
            this.mScript.assertTerm(term2);
        }
        term3 = this.mScript.let(termVariableArray, termArray, term3);
        term3 = new FormulaUnLet().unlet(term3);
        Term term4 = this.simplifyOnce(term3);
        if (this.mSimplifyRepeatedly) {
            void var8_13;
            while (var8_13 != term3) {
                term3 = var8_13;
                Term term5 = this.simplifyOnce(term3);
            }
        } else {
            term3 = term4;
        }
        term3 = new TermTransformer(){

            public void convert(Term term) {
                int n = 0;
                while (n < termVariableArray.length) {
                    if (term == termArray[n]) {
                        term = termVariableArray[n];
                    }
                    ++n;
                }
                super.convert(term);
            }
        }.transform(term3);
        this.mScript.pop(1);
        assert (this.mContext != null || this.checkEquivalence(term, term3) != Script.LBool.SAT) : "Simplification unsound?";
        this.mScript.echo(new QuotedObject("End Simplifier"));
        this.mInputTerm = null;
        return term3;
    }

    private long getElapsedTimeInMilliseconds() {
        return (System.nanoTime() - this.mStartTime) / 1000000L;
    }
}

