/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.relation;

import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import de.uni_freiburg.informatik.ultimate.util.LazyInt;

public class Quad<E1, E2, E3, E4> {
    private final E1 mFirst;
    private final E2 mSecond;
    private final E3 mThird;
    private final E4 mFourth;
    private final LazyInt mHash;

    public Quad(E1 E1, E2 E2, E3 E3, E4 E4) {
        this.mFirst = E1;
        this.mSecond = E2;
        this.mThird = E3;
        this.mFourth = E4;
        this.mHash = new LazyInt(this::computeHash);
    }

    public E1 getFirst() {
        return this.mFirst;
    }

    public E2 getSecond() {
        return this.mSecond;
    }

    public E3 getThird() {
        return this.mThird;
    }

    public E4 getFourth() {
        return this.mFourth;
    }

    public int hashCode() {
        return this.mHash.get();
    }

    private int computeHash() {
        return HashUtils.hashJenkins(31, this.mFirst, this.mSecond, this.mThird, this.mFourth);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Quad quad = (Quad)object;
        if (this.hashCode() != quad.hashCode()) {
            return false;
        }
        if (this.mFirst == null ? quad.mFirst != null : !this.mFirst.equals(quad.mFirst)) {
            return false;
        }
        if (this.mFourth == null ? quad.mFourth != null : !this.mFourth.equals(quad.mFourth)) {
            return false;
        }
        if (this.mSecond == null ? quad.mSecond != null : !this.mSecond.equals(quad.mSecond)) {
            return false;
        }
        return !(this.mThird == null ? quad.mThird != null : !this.mThird.equals(quad.mThird));
    }

    public String toString() {
        return "[" + String.valueOf(this.mFirst) + ", " + String.valueOf(this.mSecond) + ", " + String.valueOf(this.mThird) + ", " + String.valueOf(this.mFourth) + "]";
    }
}

