/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.CodeAnnot;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.CodeForBehavior;
import java.util.List;
import java.util.function.Predicate;

public final class CodeAnnotBehavior
extends CodeAnnot {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(CodeAnnotBehavior.class);
    CodeForBehavior forBehavior;

    public CodeAnnotBehavior(CodeForBehavior codeForBehavior) {
        this.forBehavior = codeForBehavior;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid CodeAnnotBehavior: " + String.valueOf(this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CodeAnnotBehavior").append('[');
        stringBuffer.append(this.forBehavior);
        return stringBuffer.append(']').toString();
    }

    public CodeForBehavior getForBehavior() {
        return this.forBehavior;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        list.add(this.forBehavior);
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (!aCSLVisitor.visit((CodeAnnot)this)) {
            return;
        }
        if (aCSLVisitor.visit(this) && this.forBehavior != null) {
            this.forBehavior.accept(aCSLVisitor);
        }
    }

    @Override
    public CodeAnnot accept(ACSLTransformer aCSLTransformer) {
        CodeAnnot codeAnnot = aCSLTransformer.transform(this);
        if (codeAnnot != this) {
            return codeAnnot;
        }
        CodeForBehavior codeForBehavior = null;
        if (this.forBehavior != null) {
            codeForBehavior = this.forBehavior.accept(aCSLTransformer);
        }
        if (this.forBehavior != codeForBehavior) {
            return new CodeAnnotBehavior(codeForBehavior);
        }
        return this;
    }
}

