/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.livevariable;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class LiveVariableState<ACTION extends IAction>
implements IAbstractState<LiveVariableState<ACTION>> {
    private static int sId;
    private final int mId;
    private final ImmutableSet<IProgramVarOrConst> mLive;

    LiveVariableState() {
        this((ImmutableSet<IProgramVarOrConst>)ImmutableSet.empty());
    }

    LiveVariableState(ImmutableSet<IProgramVarOrConst> immutableSet) {
        this.mLive = Objects.requireNonNull(immutableSet);
        this.mId = LiveVariableState.getFreshId();
    }

    public LiveVariableState<ACTION> addVariable(IProgramVarOrConst iProgramVarOrConst) {
        return this;
    }

    public LiveVariableState<ACTION> removeVariable(IProgramVarOrConst iProgramVarOrConst) {
        return this;
    }

    public LiveVariableState<ACTION> addVariables(Collection<IProgramVarOrConst> collection) {
        return this;
    }

    public LiveVariableState<ACTION> removeVariables(Collection<IProgramVarOrConst> collection) {
        return this;
    }

    public boolean containsVariable(IProgramVarOrConst iProgramVarOrConst) {
        return true;
    }

    public LiveVariableState<ACTION> renameVariables(Map<IProgramVarOrConst, IProgramVarOrConst> map) {
        return this;
    }

    public LiveVariableState<ACTION> patch(LiveVariableState<ACTION> liveVariableState) {
        return this.union(liveVariableState);
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isBottom() {
        return false;
    }

    public boolean isEqualTo(LiveVariableState<ACTION> liveVariableState) {
        if (liveVariableState == null) {
            return false;
        }
        return this.mLive.equals(liveVariableState.mLive);
    }

    public IAbstractState.SubsetResult isSubsetOf(LiveVariableState<ACTION> liveVariableState) {
        if (this.isEqualTo(liveVariableState)) {
            return IAbstractState.SubsetResult.EQUAL;
        }
        return IAbstractState.SubsetResult.NONE;
    }

    public LiveVariableState<ACTION> intersect(LiveVariableState<ACTION> liveVariableState) {
        Set set = DataStructureUtils.intersection(this.mLive, liveVariableState.mLive);
        if (set.equals(this.mLive)) {
            return this;
        }
        if (set.equals(liveVariableState.mLive)) {
            return liveVariableState;
        }
        return new LiveVariableState<ACTION>((ImmutableSet<IProgramVarOrConst>)ImmutableSet.of((Set)set));
    }

    public LiveVariableState<ACTION> union(LiveVariableState<ACTION> liveVariableState) {
        Set set = DataStructureUtils.union(this.mLive, liveVariableState.mLive);
        if (set.equals(this.mLive)) {
            return this;
        }
        if (set.equals(liveVariableState.mLive)) {
            return liveVariableState;
        }
        return new LiveVariableState<ACTION>((ImmutableSet<IProgramVarOrConst>)ImmutableSet.of((Set)set));
    }

    public Term getTerm(Script script) {
        return script.term("true", new Term[0]);
    }

    public String toLogString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        if (!this.mLive.isEmpty()) {
            this.mLive.stream().forEach(iProgramVarOrConst -> {
                StringBuilder stringBuilder2 = stringBuilder.append(iProgramVarOrConst).append(", ");
            });
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toLogString();
    }

    public int hashCode() {
        return this.mId;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LiveVariableState liveVariableState = (LiveVariableState)object;
        if (!this.isEqualTo(liveVariableState)) {
            return false;
        }
        return liveVariableState.mId == this.mId;
    }

    public ImmutableSet<IProgramVarOrConst> getLiveVariables() {
        return this.mLive;
    }

    public Set<IProgramVar> getLiveVariablesAsProgramVars() {
        assert (this.mLive.stream().allMatch(iProgramVarOrConst -> iProgramVarOrConst instanceof IProgramVar)) : "Not all live variables are of type IProgramVar";
        return this.mLive.stream().map(iProgramVarOrConst -> (IProgramVar)iProgramVarOrConst).collect(Collectors.toSet());
    }

    private static int getFreshId() {
        return ++sId;
    }

    public ImmutableSet<IProgramVarOrConst> getVariables() {
        return ImmutableSet.empty();
    }

    public LiveVariableState<ACTION> compact() {
        return this;
    }
}

