/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Axiom;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ConstDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.TypeDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public abstract sealed class Declaration
extends BoogieASTNode
permits Procedure, Axiom, ConstDeclaration, FunctionDeclaration, VariableDeclaration, TypeDeclaration {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(Declaration.class);
    ILocation loc;
    Attribute[] attributes;

    public Declaration(ILocation iLocation, Attribute[] attributeArray) {
        super(iLocation);
        this.loc = iLocation;
        this.attributes = attributeArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Declaration: " + String.valueOf((Object)this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Declaration").append('[');
        stringBuffer.append(this.loc);
        stringBuffer.append(',');
        if (this.attributes == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            int n = 0;
            while (n < this.attributes.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.attributes[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public ILocation getLoc() {
        return this.loc;
    }

    public void setLoc(ILocation iLocation) {
        if (this.loc != null && iLocation != this.loc) {
            throw new AssertionError((Object)"Value is only writeable once");
        }
        this.loc = iLocation;
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        if (this.attributes != null) {
            list.addAll(Arrays.asList(this.attributes));
        }
        return list;
    }

    @Override
    public abstract void accept(GeneratedBoogieAstVisitor var1);

    public abstract Declaration accept(GeneratedBoogieAstTransformer var1);
}

