/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBuchiIntersectStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BuchiIntersectNwa<LETTER, STATE>
implements INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> {
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mFstOperand;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mSndOperand;
    private final IBuchiIntersectStateFactory<STATE> mStateFactory;
    private final STATE mEmptyStackState;
    private final Map<STATE, Map<STATE, ProductState>> mTrack1_fst2snd2res = new HashMap<STATE, Map<STATE, ProductState>>();
    private final Map<STATE, Map<STATE, ProductState>> mTrack2_fst2snd2res = new HashMap<STATE, Map<STATE, ProductState>>();
    private final Map<STATE, ProductState> mRes2prod = new HashMap<STATE, ProductState>();
    private Set<STATE> mInitialStates;

    public <FACTORY extends IBuchiIntersectStateFactory<STATE> & IEmptyStackStateFactory<STATE>> BuchiIntersectNwa(INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider2, FACTORY FACTORY) throws AutomataLibraryException {
        this.mFstOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mSndOperand = iNwaOutgoingLetterAndTransitionProvider2;
        if (!NestedWordAutomataUtils.sameAlphabet(this.mFstOperand, this.mSndOperand)) {
            throw new AutomataLibraryException(this.getClass(), "Unable to apply operation to automata with different alphabets.");
        }
        this.mStateFactory = FACTORY;
        this.mEmptyStackState = FACTORY.createEmptyStackState();
    }

    private Set<STATE> constructInitialState() {
        HashSet hashSet = new HashSet();
        for (Object STATE : this.mFstOperand.getInitialStates()) {
            for (Object STATE2 : this.mSndOperand.getInitialStates()) {
                Object STATE3 = this.getOrConstructStateOnTrack1(STATE, STATE2);
                hashSet.add(STATE3);
            }
        }
        return hashSet;
    }

    private STATE getOrConstructStateOnTrack1(STATE STATE, STATE STATE2) {
        ProductState productState;
        Map<STATE, ProductState> map = this.mTrack1_fst2snd2res.get(STATE);
        if (map == null) {
            map = new HashMap<STATE, ProductState>();
            this.mTrack1_fst2snd2res.put(STATE, map);
        }
        if ((productState = map.get(STATE2)) == null) {
            STATE STATE3 = this.mStateFactory.intersectBuchi(STATE, STATE2, 1);
            boolean bl = this.mFstOperand.isFinal(STATE);
            productState = new ProductState(STATE, STATE2, 1, STATE3, bl);
            map.put(STATE2, productState);
            this.mRes2prod.put(STATE3, productState);
        }
        return productState.getRes();
    }

    private STATE getOrConstructStateOnTrack2(STATE STATE, STATE STATE2) {
        ProductState productState;
        Map<STATE, ProductState> map = this.mTrack2_fst2snd2res.get(STATE);
        if (map == null) {
            map = new HashMap<STATE, ProductState>();
            this.mTrack2_fst2snd2res.put(STATE, map);
        }
        if ((productState = map.get(STATE2)) == null) {
            STATE STATE3 = this.mStateFactory.intersectBuchi(STATE, STATE2, 2);
            productState = new ProductState(STATE, STATE2, 2, STATE3, false);
            map.put(STATE2, productState);
            this.mRes2prod.put(STATE3, productState);
        }
        return productState.getRes();
    }

    private byte getSuccTrack(ProductState productState) {
        int n;
        if (productState.getTrack() == 1) {
            n = this.mFstOperand.isFinal(productState.getFst()) && !this.mSndOperand.isFinal(productState.getSnd()) ? 2 : 1;
        } else {
            assert (productState.getTrack() == 2);
            n = this.mSndOperand.isFinal(productState.getSnd()) ? 1 : 2;
        }
        return (byte)n;
    }

    @Override
    public Iterable<STATE> getInitialStates() {
        if (this.mInitialStates == null) {
            this.mInitialStates = this.constructInitialState();
        }
        return this.mInitialStates;
    }

    @Override
    public VpAlphabet<LETTER> getVpAlphabet() {
        return this.mFstOperand.getVpAlphabet();
    }

    @Override
    public IStateFactory<STATE> getStateFactory() {
        return this.mStateFactory;
    }

    @Override
    public boolean isInitial(STATE STATE) {
        return this.mInitialStates.contains(STATE);
    }

    @Override
    public boolean isFinal(STATE STATE) {
        return this.mRes2prod.get(STATE).isFinal();
    }

    @Override
    public STATE getEmptyStackState() {
        return this.mEmptyStackState;
    }

    @Override
    public Set<LETTER> lettersInternal(STATE STATE) {
        Object STATE2 = this.mRes2prod.get(STATE).getFst();
        return this.mFstOperand.lettersInternal(STATE2);
    }

    @Override
    public Set<LETTER> lettersCall(STATE STATE) {
        Object STATE2 = this.mRes2prod.get(STATE).getFst();
        return this.mFstOperand.lettersCall(STATE2);
    }

    @Override
    public Set<LETTER> lettersReturn(STATE STATE, STATE STATE2) {
        Object STATE3 = this.mRes2prod.get(STATE).getFst();
        Object STATE4 = this.mRes2prod.get(STATE2).getFst();
        return this.mFstOperand.lettersReturn(STATE3, STATE4);
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE, LETTER LETTER) {
        ProductState productState = this.mRes2prod.get(STATE);
        return this.internalSuccessors(this.mFstOperand.internalSuccessors(productState.getFst(), LETTER), productState);
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE) {
        ProductState productState = this.mRes2prod.get(STATE);
        return this.internalSuccessors(this.mFstOperand.internalSuccessors(productState.getFst()), productState);
    }

    @Override
    private Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(Iterable<OutgoingInternalTransition<LETTER, STATE>> iterable, ProductState productState) {
        ArrayList<OutgoingInternalTransition<LETTER, STATE>> arrayList = new ArrayList<OutgoingInternalTransition<LETTER, STATE>>();
        for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition : iterable) {
            LETTER LETTER = outgoingInternalTransition.getLetter();
            for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition2 : this.mSndOperand.internalSuccessors(productState.getSnd(), LETTER)) {
                STATE STATE;
                STATE STATE2 = outgoingInternalTransition.getSucc();
                STATE STATE3 = outgoingInternalTransition2.getSucc();
                byte by = this.getSuccTrack(productState);
                if (by == 1) {
                    STATE = this.getOrConstructStateOnTrack1(STATE2, STATE3);
                } else {
                    assert (by == 2);
                    STATE = this.getOrConstructStateOnTrack2(STATE2, STATE3);
                }
                arrayList.add(new OutgoingInternalTransition<LETTER, STATE>(LETTER, STATE));
            }
        }
        return arrayList;
    }

    @Override
    public Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(STATE STATE, LETTER LETTER) {
        ProductState productState = this.mRes2prod.get(STATE);
        return this.callSuccessors(this.mFstOperand.callSuccessors(productState.getFst(), LETTER), productState);
    }

    @Override
    public Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(STATE STATE) {
        ProductState productState = this.mRes2prod.get(STATE);
        return this.callSuccessors(this.mFstOperand.callSuccessors(productState.getFst()), productState);
    }

    @Override
    private Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(Iterable<OutgoingCallTransition<LETTER, STATE>> iterable, ProductState productState) {
        ArrayList<OutgoingCallTransition<LETTER, STATE>> arrayList = new ArrayList<OutgoingCallTransition<LETTER, STATE>>();
        for (OutgoingCallTransition<LETTER, STATE> outgoingCallTransition : iterable) {
            LETTER LETTER = outgoingCallTransition.getLetter();
            for (OutgoingCallTransition<LETTER, STATE> outgoingCallTransition2 : this.mSndOperand.callSuccessors(productState.getSnd(), LETTER)) {
                STATE STATE;
                STATE STATE2 = outgoingCallTransition.getSucc();
                STATE STATE3 = outgoingCallTransition2.getSucc();
                byte by = this.getSuccTrack(productState);
                if (by == 1) {
                    STATE = this.getOrConstructStateOnTrack1(STATE2, STATE3);
                } else {
                    assert (by == 2);
                    STATE = this.getOrConstructStateOnTrack2(STATE2, STATE3);
                }
                arrayList.add(new OutgoingCallTransition<LETTER, STATE>(LETTER, STATE));
            }
        }
        return arrayList;
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessors(STATE STATE, STATE STATE2, LETTER LETTER) {
        ProductState productState = this.mRes2prod.get(STATE);
        ProductState productState2 = this.mRes2prod.get(STATE2);
        Object STATE3 = productState2.getFst();
        Object STATE4 = productState2.getSnd();
        return this.returnSuccessors(this.mFstOperand.returnSuccessors(productState.getFst(), STATE3, LETTER), productState, STATE2, STATE4);
    }

    private Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessors(Iterable<OutgoingReturnTransition<LETTER, STATE>> iterable, ProductState productState, STATE STATE, STATE STATE2) {
        ArrayList<OutgoingReturnTransition<LETTER, STATE>> arrayList = new ArrayList<OutgoingReturnTransition<LETTER, STATE>>();
        for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : iterable) {
            LETTER LETTER = outgoingReturnTransition.getLetter();
            for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition2 : this.mSndOperand.returnSuccessors(productState.getSnd(), STATE2, LETTER)) {
                STATE STATE3;
                STATE STATE4 = outgoingReturnTransition.getSucc();
                STATE STATE5 = outgoingReturnTransition2.getSucc();
                byte by = this.getSuccTrack(productState);
                if (by == 1) {
                    STATE3 = this.getOrConstructStateOnTrack1(STATE4, STATE5);
                } else {
                    assert (by == 2);
                    STATE3 = this.getOrConstructStateOnTrack2(STATE4, STATE5);
                }
                arrayList.add(new OutgoingReturnTransition<LETTER, STATE>(STATE, LETTER, STATE3));
            }
        }
        return arrayList;
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessorsGivenHier(STATE STATE, STATE STATE2) {
        ProductState productState = this.mRes2prod.get(STATE);
        ProductState productState2 = this.mRes2prod.get(STATE2);
        Object STATE3 = productState2.getFst();
        Object STATE4 = productState2.getSnd();
        return this.returnSuccessors(this.mFstOperand.returnSuccessorsGivenHier(productState.getFst(), STATE3), productState, STATE2, STATE4);
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public String sizeInformation() {
        return null;
    }

    private class ProductState {
        private final STATE mFst;
        private final STATE mSnd;
        private final byte mTrack;
        private final STATE mRes;
        private final boolean mIsFinal;

        ProductState(STATE STATE, STATE STATE2, byte by, STATE STATE3, boolean bl) {
            this.mFst = STATE;
            this.mSnd = STATE2;
            this.mTrack = by;
            this.mRes = STATE3;
            this.mIsFinal = bl;
        }

        public STATE getFst() {
            return this.mFst;
        }

        public STATE getSnd() {
            return this.mSnd;
        }

        public byte getTrack() {
            return this.mTrack;
        }

        public STATE getRes() {
            return this.mRes;
        }

        public boolean isFinal() {
            return this.mIsFinal;
        }

        public String toString() {
            return "<" + this.mFst.toString() + "," + this.mSnd.toString() + " " + this.mTrack + ">";
        }
    }
}

