/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.AbstractMinimizeNwaDd;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationCheckResultStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaMaxSat2;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaPmaxSat;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaPmaxSatDirectBi;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeSevpa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.ShrinkNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.direct.nwa.ReduceNwaDirectSimulation;
import de.uni_freiburg.informatik.ultimate.automata.util.ISetOfPairs;
import de.uni_freiburg.informatik.ultimate.automata.util.PartitionBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Map;

public abstract class MinimizeNwaCombinator<LETTER, STATE>
extends AbstractMinimizeNwaDd<LETTER, STATE> {
    public static final String UNDEFINED_ENUM_STATE_MESSAGE = "Undefined enum state.";
    private static final String MAP_NOT_SUPPORTED_MESSAGE = "Map from old to new automaton is not supported with ";
    protected Object mBackingMinimization;
    protected MinimizationMethods mMode;
    private final INestedWordAutomaton<LETTER, STATE> mOperand;

    protected MinimizeNwaCombinator(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton) {
        super(automataLibraryServices, iMinimizationStateFactory);
        this.mOperand = iDoubleDeckerAutomaton;
        this.mMode = MinimizationMethods.UNDEFINED;
    }

    @Override
    protected INestedWordAutomaton<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    protected final void run(ISetOfPairs<STATE, ?> iSetOfPairs, boolean bl) throws AutomataOperationCanceledException {
        switch (this.mMode) {
            case SEVPA: {
                this.mBackingMinimization = new MinimizeSevpa<LETTER, STATE>(this.mServices, this.mStateFactory, this.mOperand, (PartitionBackedSetOfPairs)iSetOfPairs, bl, false);
                break;
            }
            case SHRINK_NWA: {
                this.mBackingMinimization = new ShrinkNwa<LETTER, STATE>(this.mServices, this.mStateFactory, this.mOperand, (PartitionBackedSetOfPairs)iSetOfPairs, bl, false, false, 200, false, 0, false, false, true, false);
                break;
            }
            case NWA_MAX_SAT2: {
                this.mBackingMinimization = new MinimizeNwaPmaxSatDirectBi(this.mServices, this.mStateFactory, (IDoubleDeckerAutomaton)this.mOperand, (PartitionBackedSetOfPairs)iSetOfPairs, new MinimizeNwaMaxSat2.Settings().setAddMapOldState2NewState(bl).setLibraryMode(false));
                break;
            }
            case NWA_RAQ_DIRECT: {
                this.checkForNoMapping(bl);
                this.mBackingMinimization = new ReduceNwaDirectSimulation(this.mServices, this.mStateFactory, (IDoubleDeckerAutomaton)this.mOperand, false, (PartitionBackedSetOfPairs)iSetOfPairs);
                break;
            }
            case NONE: {
                if (this.mLogger.isInfoEnabled()) {
                    this.mLogger.info((Object)"No minimization is used.");
                }
                this.mBackingMinimization = this.mOperand;
                break;
            }
            default: {
                throw new IllegalArgumentException(UNDEFINED_ENUM_STATE_MESSAGE);
            }
        }
    }

    @Override
    public final IDoubleDeckerAutomaton<LETTER, STATE> getResult() {
        switch (this.mMode) {
            case SEVPA: {
                return (IDoubleDeckerAutomaton)((MinimizeSevpa)this.mBackingMinimization).getResult();
            }
            case SHRINK_NWA: {
                return (IDoubleDeckerAutomaton)((ShrinkNwa)this.mBackingMinimization).getResult();
            }
            case NWA_MAX_SAT2: {
                return ((MinimizeNwaPmaxSat)this.mBackingMinimization).getResult();
            }
            case NWA_RAQ_DIRECT: {
                return (IDoubleDeckerAutomaton)((ReduceNwaDirectSimulation)this.mBackingMinimization).getResult();
            }
            case NONE: {
                return (IDoubleDeckerAutomaton)this.mBackingMinimization;
            }
        }
        throw new IllegalArgumentException(UNDEFINED_ENUM_STATE_MESSAGE);
    }

    @Override
    public final Map<STATE, STATE> getOldState2newState() {
        switch (this.mMode) {
            case SEVPA: {
                return ((MinimizeSevpa)this.mBackingMinimization).getOldState2newState();
            }
            case SHRINK_NWA: {
                return ((ShrinkNwa)this.mBackingMinimization).getOldState2newState();
            }
            case NWA_MAX_SAT2: {
                return ((MinimizeNwaPmaxSat)this.mBackingMinimization).getOldState2newState();
            }
            case NWA_RAQ_DIRECT: {
                throw new UnsupportedOperationException(MAP_NOT_SUPPORTED_MESSAGE + String.valueOf((Object)this.mMode));
            }
            case NONE: {
                throw new IllegalArgumentException("Do not ask for Hoare annotation if no minimization was used.");
            }
        }
        throw new IllegalArgumentException(UNDEFINED_ENUM_STATE_MESSAGE);
    }

    @Override
    public final Pair<Boolean, String> checkResultHelper(IMinimizationCheckResultStateFactory<STATE> iMinimizationCheckResultStateFactory) throws AutomataLibraryException {
        switch (this.mMode) {
            case SEVPA: {
                return ((MinimizeSevpa)this.mBackingMinimization).checkResultHelper(iMinimizationCheckResultStateFactory);
            }
            case SHRINK_NWA: {
                return ((ShrinkNwa)this.mBackingMinimization).checkResultHelper(iMinimizationCheckResultStateFactory);
            }
            case NWA_MAX_SAT2: {
                return ((MinimizeNwaPmaxSat)this.mBackingMinimization).checkResultHelper(iMinimizationCheckResultStateFactory);
            }
            case NWA_RAQ_DIRECT: {
                return ((ReduceNwaDirectSimulation)this.mBackingMinimization).checkResultHelper(iMinimizationCheckResultStateFactory);
            }
            case NONE: {
                return new Pair((Object)true, (Object)"");
            }
        }
        throw new IllegalArgumentException(UNDEFINED_ENUM_STATE_MESSAGE);
    }

    private void checkForNoMapping(boolean bl) {
        if (bl) {
            throw new IllegalArgumentException(MAP_NOT_SUPPORTED_MESSAGE + String.valueOf((Object)this.mMode));
        }
    }

    public MinimizationMethods getMode() {
        return this.mMode;
    }

    public static enum MinimizationMethods {
        SEVPA,
        SHRINK_NWA,
        NWA_MAX_SAT2,
        NWA_RAQ_DIRECT,
        NONE,
        UNDEFINED;

    }
}

