/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.builders;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.TracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.CoverageAnalysis;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.builders.IInterpolantAutomatonBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CanonicalInterpolantAutomatonBuilder<LETTER>
extends CoverageAnalysis<Object>
implements IInterpolantAutomatonBuilder<LETTER, IPredicate> {
    private final boolean mSelfloopAtInitial = false;
    private final boolean mSelfloopAtFinal = true;
    private final NestedWordAutomaton<LETTER, IPredicate> mIA;
    protected final NestedWord<LETTER> mNestedWord;
    private final Map<Integer, Set<IPredicate>> mAlternativeCallPredecessors = new HashMap<Integer, Set<IPredicate>>();

    public CanonicalInterpolantAutomatonBuilder(IUltimateServiceProvider iUltimateServiceProvider, TracePredicates tracePredicates, VpAlphabet<LETTER> vpAlphabet, IEmptyStackStateFactory<IPredicate> iEmptyStackStateFactory, ILogger iLogger, IPredicateUnifier iPredicateUnifier, Counterexample<LETTER> counterexample) {
        super(iUltimateServiceProvider, tracePredicates, counterexample.getControlConfigurations(), iLogger, iPredicateUnifier);
        this.mNestedWord = counterexample.getWord();
        this.mIA = new NestedWordAutomaton(new AutomataLibraryServices(this.mServices), vpAlphabet, iEmptyStackStateFactory);
    }

    protected void processCodeBlock(int n) {
        IPredicate iPredicate = this.mIpp.getPredicate(n + 1);
        if (!this.mIA.getStates().contains(iPredicate)) {
            assert (iPredicate != this.mIpp.getPostcondition());
            this.mIA.addState(false, false, (Object)iPredicate);
        }
        this.addTransition(n, n, n + 1);
    }

    protected void processCoveringResult(int n, int n2, Script.LBool lBool) {
        if (lBool == Script.LBool.UNSAT) {
            this.addTransition(n - 1, n - 1, n2);
            this.addTransition(n, n2, n2 + 1);
        }
    }

    protected void postprocess() {
        IPredicate iPredicate = this.mIpp.getPostcondition();
        for (Object e : this.mIA.getVpAlphabet().getInternalAlphabet()) {
            this.mIA.addInternalTransition((Object)iPredicate, e, (Object)iPredicate);
        }
        for (Object e : this.mIA.getVpAlphabet().getCallAlphabet()) {
            this.mIA.addCallTransition((Object)iPredicate, e, (Object)iPredicate);
        }
        for (Object e : this.mIA.getVpAlphabet().getReturnAlphabet()) {
            this.mIA.addReturnTransition((Object)iPredicate, (Object)iPredicate, e, (Object)iPredicate);
            for (Integer n : this.mAlternativeCallPredecessors.keySet()) {
                for (IPredicate iPredicate2 : this.mAlternativeCallPredecessors.get(n)) {
                    this.mIA.addReturnTransition((Object)iPredicate, (Object)iPredicate2, e, (Object)iPredicate);
                }
            }
        }
    }

    protected void preprocess() {
        StringBuilder stringBuilder = new StringBuilder("Constructing canonical interpolant automaton");
        stringBuilder.append(", with selfloop in false state");
        this.mLogger.info((Object)stringBuilder.toString());
        this.mIA.addState(true, false, (Object)this.mIpp.getPrecondition());
        this.mIA.addState(false, true, (Object)this.mIpp.getPostcondition());
    }

    @Override
    public NestedWordAutomaton<LETTER, IPredicate> getResult() {
        return this.mIA;
    }

    private void addTransition(int n, int n2, int n3) {
        IPredicate iPredicate = this.mIpp.getPredicate(n);
        IPredicate iPredicate2 = this.mIpp.getPredicate(n3);
        Object object = this.mNestedWord.getSymbol(n2);
        if (this.mNestedWord.isCallPosition(n2)) {
            this.mIA.addCallTransition((Object)iPredicate, object, (Object)iPredicate2);
            if (this.mIpp.getPredicate(n) != this.mIpp.getPredicate(n2)) {
                this.addAlternativeCallPredecessor(n2, this.mIpp.getPredicate(n));
            }
        } else if (this.mNestedWord.isReturnPosition(n2)) {
            int n4 = this.mNestedWord.getCallPosition(n2);
            IPredicate iPredicate3 = this.mIpp.getPredicate(n4);
            this.mIA.addReturnTransition((Object)iPredicate, (Object)iPredicate3, object, (Object)iPredicate2);
            this.addAlternativeReturnTransitions(iPredicate, n4, object, iPredicate2);
        } else {
            this.mIA.addInternalTransition((Object)iPredicate, object, (Object)iPredicate2);
        }
    }

    private void addAlternativeCallPredecessor(int n, IPredicate iPredicate) {
        Set<IPredicate> set = this.mAlternativeCallPredecessors.get(n);
        if (set == null) {
            set = new HashSet<IPredicate>();
            this.mAlternativeCallPredecessors.put(n, set);
        }
        set.add(iPredicate);
    }

    private void addAlternativeReturnTransitions(IPredicate iPredicate, int n, LETTER LETTER, IPredicate iPredicate2) {
        this.mAlternativeCallPredecessors.get(n);
    }
}

