/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.printer;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogieOutput;
import de.uni_freiburg.informatik.ultimate.boogie.printer.Activator;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IUnmanagedObserver;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class BoogiePrinterObserver
implements IUnmanagedObserver {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;

    public BoogiePrinterObserver(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
    }

    public boolean process(IElement iElement) {
        if (iElement instanceof Unit) {
            PrintWriter printWriter = this.openTempFile(iElement);
            if (printWriter != null) {
                Unit unit = (Unit)iElement;
                BoogieOutput boogieOutput = new BoogieOutput(printWriter);
                boogieOutput.printBoogieProgram(unit);
                printWriter.close();
            }
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PrintWriter openTempFile(IElement iElement) {
        String string;
        File file = null;
        if (this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getBoolean("Save file in source directory?")) {
            ILocation iLocation = ILocation.getAnnotation((IElement)iElement);
            File file2 = new File(iLocation.getFileName());
            string = file2.isDirectory() ? file2.getPath() : file2.getParent();
            if (string == null) {
                this.mLogger.warn((Object)"Model does not provide a valid source location, falling back to default dump path...");
                string = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getString("Dump path:");
            }
        } else {
            string = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getString("Dump path:");
        }
        try {
            if (this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getBoolean("Use automatic naming?")) {
                file = File.createTempFile("BoogiePrinter_" + new File(ILocation.getAnnotation((IElement)iElement).getFileName()).getName() + "_UID", ".bpl", new File(string));
            } else {
                String string2 = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getString("File name:");
                file = new File(string + File.separatorChar + string2);
                if (!(file.isFile() && file.canWrite() || !file.exists())) {
                    this.mLogger.warn((Object)("Cannot write to: " + file.getAbsolutePath()));
                    return null;
                }
                if (file.exists()) {
                    this.mLogger.info((Object)("File already exists and will be overwritten: " + file.getAbsolutePath()));
                }
                file.createNewFile();
            }
            this.mLogger.info((Object)("Writing to file " + file.getAbsolutePath()));
            return new PrintWriter(new FileWriter(file));
        }
        catch (IOException iOException) {
            if (file != null) {
                this.mLogger.fatal((Object)("Cannot open file: " + file.getAbsolutePath()), (Throwable)iOException);
                return null;
            }
            this.mLogger.fatal((Object)"Cannot open file", (Throwable)iOException);
            return null;
        }
    }

    public void finish() {
    }

    public void init(ModelType modelType, int n, int n2) {
    }

    public boolean performedChanges() {
        return false;
    }
}

