/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.LocationFactory;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.Objects;

public class HeapDataArray {
    private final String mName;
    private final ASTType mContentASTType;
    private final int mSize;
    private final BoogieType mContentBoogieType;
    private final IdentifierExpression mIdentifierExpression;
    private final VariableLHS mVariableLhs;

    public HeapDataArray(String string, ASTType aSTType, BoogieType boogieType, BoogieType boogieType2, int n) {
        this.mName = string;
        this.mContentASTType = aSTType;
        this.mContentBoogieType = boogieType;
        this.mSize = n;
        BoogieArrayType boogieArrayType = BoogieType.createArrayType((int)0, (BoogieType[])new BoogieType[]{boogieType2}, (BoogieType)boogieType);
        this.mIdentifierExpression = ExpressionFactory.constructIdentifierExpression((ILocation)LocationFactory.createIgnoreCLocation(), (BoogieType)boogieArrayType, (String)this.getVariableName(), (DeclarationInformation)DeclarationInformation.DECLARATIONINFO_GLOBAL);
        this.mVariableLhs = ExpressionFactory.constructVariableLHS((ILocation)LocationFactory.createIgnoreCLocation(), (BoogieType)boogieArrayType, (String)this.getVariableName(), (DeclarationInformation)DeclarationInformation.DECLARATIONINFO_GLOBAL);
    }

    public String getName() {
        return this.mName;
    }

    public ASTType getASTType() {
        return this.mContentASTType;
    }

    public BoogieType getArrayContentBoogieType() {
        return this.mContentBoogieType;
    }

    public String getVariableName() {
        return "#memory_" + this.getName();
    }

    public IdentifierExpression getIdentifierExpression() {
        return this.mIdentifierExpression;
    }

    public VariableLHS getVariableLHS() {
        return this.mVariableLhs;
    }

    public int getSize() {
        return this.mSize;
    }

    public int hashCode() {
        return Objects.hash(this.mContentASTType, this.mName, this.mSize);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HeapDataArray heapDataArray = (HeapDataArray)object;
        if (this.mContentASTType == null ? heapDataArray.mContentASTType != null : !this.mContentASTType.equals(heapDataArray.mContentASTType)) {
            return false;
        }
        if (this.mName == null ? heapDataArray.mName != null : !this.mName.equals(heapDataArray.mName)) {
            return false;
        }
        return this.mSize == heapDataArray.mSize;
    }

    public String toString() {
        return "HeapDataArray [mName=" + this.mName + ", mASTType=" + String.valueOf(this.mContentASTType) + ", mSize=" + this.mSize + "]";
    }
}

