/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNetTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.Marking;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetNot1SafeException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.UnaryNetOperation;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IPetriNet2FiniteAutomatonStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public final class PetriNet2FiniteAutomaton<LETTER, PLACE>
extends UnaryNetOperation<LETTER, PLACE, IStateFactory<PLACE>> {
    private final IPetriNetTransitionProvider<LETTER, PLACE> mOperand;
    private final NestedWordAutomaton<LETTER, PLACE> mResult;
    private final Predicate<Marking<PLACE>> mIsKnownDeadEnd;
    private final List<Marking<PLACE>> mWorklist = new LinkedList<Marking<PLACE>>();
    private final Map<Marking<PLACE>, PLACE> mMarking2State = new HashMap<Marking<PLACE>, PLACE>();
    private final IPetriNet2FiniteAutomatonStateFactory<PLACE> mContentFactory;

    public PetriNet2FiniteAutomaton(AutomataLibraryServices automataLibraryServices, IPetriNet2FiniteAutomatonStateFactory<PLACE> iPetriNet2FiniteAutomatonStateFactory, IPetriNetTransitionProvider<LETTER, PLACE> iPetriNetTransitionProvider) throws PetriNetNot1SafeException, AutomataOperationCanceledException {
        this(automataLibraryServices, iPetriNet2FiniteAutomatonStateFactory, iPetriNetTransitionProvider, null);
    }

    public PetriNet2FiniteAutomaton(AutomataLibraryServices automataLibraryServices, IPetriNet2FiniteAutomatonStateFactory<PLACE> iPetriNet2FiniteAutomatonStateFactory, IPetriNetTransitionProvider<LETTER, PLACE> iPetriNetTransitionProvider, Predicate<Marking<PLACE>> predicate) throws PetriNetNot1SafeException, AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mOperand = iPetriNetTransitionProvider;
        this.mIsKnownDeadEnd = predicate;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mContentFactory = iPetriNet2FiniteAutomatonStateFactory;
        HashSet hashSet = new HashSet(iPetriNetTransitionProvider.getAlphabet());
        VpAlphabet vpAlphabet = new VpAlphabet(hashSet, Collections.emptySet(), Collections.emptySet());
        this.mResult = new NestedWordAutomaton(this.mServices, vpAlphabet, iPetriNet2FiniteAutomatonStateFactory);
        this.getState(new Marking(ImmutableSet.of(iPetriNetTransitionProvider.getInitialPlaces())), true);
        while (!this.mWorklist.isEmpty()) {
            Marking<PLACE> marking = this.mWorklist.remove(0);
            this.constructOutgoingTransitions(marking);
            if (this.mServices.getProgressAwareTimer().continueProcessing()) continue;
            RunningTaskInfo runningTaskInfo = new RunningTaskInfo(this.getClass(), "constructing automaton for Petri net that has " + this.mOperand.sizeInformation() + ". Already constructed " + this.mMarking2State.size() + " states. Currently " + this.mWorklist.size() + " states in worklist.");
            throw new AutomataOperationCanceledException(runningTaskInfo);
        }
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ". Result " + this.mResult.sizeInformation();
    }

    private PLACE getState(Marking<PLACE> marking, boolean bl) {
        if (this.isKnownDeadEnd(marking)) {
            return null;
        }
        PLACE PLACE = this.mMarking2State.get(marking);
        if (PLACE == null) {
            boolean bl2 = this.mOperand.isAccepting(marking);
            PLACE = this.mContentFactory.getContentOnPetriNet2FiniteAutomaton(marking);
            this.mResult.addState(bl, bl2, PLACE);
            this.mMarking2State.put(marking, PLACE);
            this.mWorklist.add(marking);
        }
        return PLACE;
    }

    private void constructOutgoingTransitions(Marking<PLACE> marking) throws PetriNetNot1SafeException {
        PLACE PLACE = this.getState(marking, false);
        assert (PLACE != null) : "Dead-end marking should never be on worklist";
        Set<Transition<LETTER, PLACE>> set = this.getOutgoingNetTransitions(marking);
        for (Transition<LETTER, PLACE> transition : set) {
            Marking<PLACE> marking2;
            PLACE PLACE2;
            if (!marking.isTransitionEnabled(transition) || (PLACE2 = this.getState(marking2 = marking.fireTransition(transition), false)) == null) continue;
            this.mResult.addInternalTransition(PLACE, transition.getSymbol(), PLACE2);
        }
    }

    private Set<Transition<LETTER, PLACE>> getOutgoingNetTransitions(Marking<PLACE> marking) {
        HashSet<Transition<LETTER, PLACE>> hashSet = new HashSet<Transition<LETTER, PLACE>>();
        for (PLACE PLACE : marking) {
            hashSet.addAll(this.mOperand.getSuccessors(PLACE));
        }
        return hashSet;
    }

    private boolean isKnownDeadEnd(Marking<PLACE> marking) {
        if (this.mIsKnownDeadEnd == null) {
            return false;
        }
        return this.mIsKnownDeadEnd.test(marking);
    }

    @Override
    protected IPetriNetTransitionProvider<LETTER, PLACE> getOperand() {
        return this.mOperand;
    }

    @Override
    public INestedWordAutomaton<LETTER, PLACE> getResult() {
        return this.mResult;
    }

    @Override
    public boolean checkResult(IStateFactory<PLACE> iStateFactory) throws AutomataLibraryException {
        return true;
    }
}

