/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayStoreExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitVectorAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitvecLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionApplication;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfThenElseExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.QuantifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StringLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructConstructor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WildcardExpression;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.List;
import java.util.function.Predicate;

public abstract sealed class Expression
extends BoogieASTNode
permits FunctionApplication, BinaryExpression, WildcardExpression, IntegerLiteral, StructAccessExpression, ArrayStoreExpression, StringLiteral, BooleanLiteral, UnaryExpression, QuantifierExpression, RealLiteral, StructConstructor, BitvecLiteral, IfThenElseExpression, IdentifierExpression, BitVectorAccessExpression, ArrayAccessExpression {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(Expression.class);
    ILocation loc;
    IBoogieType type;

    public Expression(ILocation iLocation) {
        super(iLocation);
        this.loc = iLocation;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Expression: " + String.valueOf((Object)this);
    }

    public Expression(ILocation iLocation, IBoogieType iBoogieType) {
        super(iLocation);
        this.loc = iLocation;
        this.type = iBoogieType;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Expression: " + String.valueOf((Object)this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Expression").append('[');
        stringBuffer.append(this.loc);
        stringBuffer.append(',').append(this.type);
        return stringBuffer.append(']').toString();
    }

    public ILocation getLoc() {
        return this.loc;
    }

    public void setLoc(ILocation iLocation) {
        if (this.loc != null && iLocation != this.loc) {
            throw new AssertionError((Object)"Value is only writeable once");
        }
        this.loc = iLocation;
    }

    public IBoogieType getType() {
        return this.type;
    }

    public void setType(IBoogieType iBoogieType) {
        this.type = iBoogieType;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        return list;
    }

    @Override
    public abstract void accept(GeneratedBoogieAstVisitor var1);

    public abstract Expression accept(GeneratedBoogieAstTransformer var1);
}

