/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ThreeValuedEquivalenceRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ArrayIndexEqualityManager {
    private final ThreeValuedEquivalenceRelation<Term> mTver;
    private final Term mContext;
    private final boolean mContextIsAbsorbingElement;
    private final Set<TermVariable> mFreeVarsOfContext;
    private final boolean mCheckEqualityStatusOnDemand;
    private final int mQuantifier;
    private final ManagedScript mMgdScript;
    private final ILogger mLogger;
    private final HashRelation<Term, Term> mAlreadyCheckedBySolver;
    final IncrementalPlicationChecker mIea;

    public ArrayIndexEqualityManager(ThreeValuedEquivalenceRelation<Term> threeValuedEquivalenceRelation, Term term, int n, ILogger iLogger, ManagedScript managedScript) {
        IncrementalPlicationChecker.Plication plication;
        this.mTver = threeValuedEquivalenceRelation;
        this.mContext = term;
        this.mQuantifier = n;
        this.mLogger = iLogger;
        this.mMgdScript = managedScript;
        this.mFreeVarsOfContext = Arrays.stream(this.mContext.getFreeVars()).collect(Collectors.toSet());
        this.mCheckEqualityStatusOnDemand = true;
        this.mAlreadyCheckedBySolver = new HashRelation();
        if (this.mQuantifier == 0) {
            plication = IncrementalPlicationChecker.Plication.IMPLICATION;
        } else if (this.mQuantifier == 1) {
            plication = IncrementalPlicationChecker.Plication.EXPLICATION;
        } else {
            throw new AssertionError((Object)"unknown quantifier");
        }
        this.mIea = new IncrementalPlicationChecker(plication, this.mMgdScript, this.mContext);
        Term term2 = QuantifierUtils.getNeutralElement(this.mMgdScript.getScript(), this.mQuantifier);
        IncrementalPlicationChecker.Validity validity = this.mIea.checkPlication(term2);
        this.mContextIsAbsorbingElement = validity == IncrementalPlicationChecker.Validity.VALID;
    }

    boolean alreadyCheckedUsesRepresenatives() {
        for (Term term : this.mAlreadyCheckedBySolver.getDomain()) {
            if (this.mTver.isRepresentative((Object)term)) continue;
            return false;
        }
        return true;
    }

    public EqualityStatus checkEqualityStatus(Term term, Term term2) {
        if (!this.allFreeVarsOccurInContext(term)) {
            return EqualityStatus.UNKNOWN;
        }
        if (!this.allFreeVarsOccurInContext(term2)) {
            return EqualityStatus.UNKNOWN;
        }
        this.mTver.addElement((Object)term);
        this.mTver.addElement((Object)term2);
        EqualityStatus equalityStatus = this.mTver.getEqualityStatus((Object)term, (Object)term2);
        if (equalityStatus == EqualityStatus.UNKNOWN && this.mCheckEqualityStatusOnDemand) {
            Term term3 = (Term)this.mTver.getRepresentative((Object)term);
            Term term4 = (Term)this.mTver.getRepresentative((Object)term2);
            assert (this.alreadyCheckedUsesRepresenatives()) : "the mAlreadyCheckedBySolver relation is outdated";
            if (this.mAlreadyCheckedBySolver.containsPair((Object)term3, (Object)term4)) {
                return EqualityStatus.UNKNOWN;
            }
            this.mAlreadyCheckedBySolver.addPair((Object)term3, (Object)term4);
            this.mAlreadyCheckedBySolver.addPair((Object)term4, (Object)term3);
            this.checkEqualityStatusViaSolver(this.mQuantifier, this.mTver, this.mIea, term3, term4);
            assert (this.alreadyCheckedUsesRepresenatives()) : "the mAlreadyCheckedBySolver relation is outdated";
            return this.mTver.getEqualityStatus((Object)term3, (Object)term4);
        }
        return equalityStatus;
    }

    private boolean allFreeVarsOccurInContext(Term term) {
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray[n2];
            if (!this.mFreeVarsOfContext.contains(termVariable)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void checkEqualityStatusViaSolver(int n, ThreeValuedEquivalenceRelation<Term> threeValuedEquivalenceRelation, IncrementalPlicationChecker incrementalPlicationChecker, Term term, Term term2) throws AssertionError {
        Term term3 = SmtUtils.binaryEquality(this.mMgdScript.getScript(), term, term2);
        if (SmtUtils.isTrueLiteral(term3)) {
            this.reportEquality(term, term2);
            assert (!threeValuedEquivalenceRelation.isInconsistent()) : "inconsistent equality information";
        } else if (SmtUtils.isFalseLiteral(term3)) {
            threeValuedEquivalenceRelation.reportDisequality((Object)term, (Object)term2);
            assert (!threeValuedEquivalenceRelation.isInconsistent()) : "inconsistent equality information";
        } else {
            Term term4 = SmtUtils.not(this.mMgdScript.getScript(), term3);
            IncrementalPlicationChecker.Validity validity = incrementalPlicationChecker.checkPlication(term3);
            if (validity == IncrementalPlicationChecker.Validity.UNKNOWN && this.mLogger.isWarnEnabled()) {
                this.mLogger.warn((Object)("solver failed to check if following equality is implied: " + String.valueOf(term3)));
            }
            if (validity == IncrementalPlicationChecker.Validity.VALID) {
                if (n == 0) {
                    this.reportEquality(term, term2);
                    assert (!threeValuedEquivalenceRelation.isInconsistent()) : "inconsistent equality information";
                } else if (n == 1) {
                    threeValuedEquivalenceRelation.reportDisequality((Object)term, (Object)term2);
                    assert (!threeValuedEquivalenceRelation.isInconsistent()) : "inconsistent equality information";
                } else {
                    throw new AssertionError((Object)"unknown quantifier");
                }
                this.mLogger.info((Object)"detected equality via solver");
            } else {
                IncrementalPlicationChecker.Validity validity2 = incrementalPlicationChecker.checkPlication(term4);
                if (validity2 == IncrementalPlicationChecker.Validity.UNKNOWN && this.mLogger.isWarnEnabled()) {
                    this.mLogger.warn((Object)("solver failed to check if following not equals relation is implied: " + String.valueOf(term3)));
                }
                if (validity2 == IncrementalPlicationChecker.Validity.VALID) {
                    if (n == 0) {
                        threeValuedEquivalenceRelation.reportDisequality((Object)term, (Object)term2);
                        assert (!threeValuedEquivalenceRelation.isInconsistent()) : "inconsistent equality information";
                    } else if (n == 1) {
                        this.reportEquality(term, term2);
                        assert (!threeValuedEquivalenceRelation.isInconsistent()) : "inconsistent equality information";
                    } else {
                        throw new AssertionError((Object)"unknown quantifier");
                    }
                    this.mLogger.info((Object)"detected not equals via solver");
                }
            }
        }
    }

    private void reportEquality(Term term, Term term2) {
        Term term3;
        Term term4;
        Term term5 = (Term)this.mTver.getRepresentative((Object)term);
        Term term6 = (Term)this.mTver.getRepresentative((Object)term2);
        this.mTver.reportEquality((Object)term, (Object)term2);
        if (term5 == this.mTver.getRepresentative((Object)term)) {
            term4 = term5;
            term3 = term6;
            assert (term5 == this.mTver.getRepresentative((Object)term2));
        } else {
            term4 = term6;
            term3 = term5;
            assert (term6 == this.mTver.getRepresentative((Object)term));
        }
        HashRelation hashRelation = new HashRelation();
        for (Map.Entry entry : this.mAlreadyCheckedBySolver.getSetOfPairs()) {
            if (entry.getKey() != term3 && entry.getValue() != term3) continue;
            hashRelation.addPair((Object)((Term)entry.getKey()), (Object)((Term)entry.getValue()));
        }
        for (Map.Entry entry : hashRelation.getSetOfPairs()) {
            boolean bl;
            if (entry.getKey() == term3) {
                bl = this.mAlreadyCheckedBySolver.removePair((Object)term3, (Object)((Term)entry.getValue()));
                if (!bl) {
                    throw new AssertionError((Object)"element does not exist");
                }
                this.mAlreadyCheckedBySolver.addPair((Object)term4, (Object)((Term)entry.getValue()));
                continue;
            }
            if (entry.getValue() == term3) {
                bl = this.mAlreadyCheckedBySolver.removePair((Object)((Term)entry.getKey()), (Object)term3);
                if (!bl) {
                    throw new AssertionError((Object)"element does not exist");
                }
                this.mAlreadyCheckedBySolver.addPair((Object)((Term)entry.getKey()), (Object)term4);
                continue;
            }
            throw new AssertionError((Object)"some element has to be outdated.");
        }
    }

    public void unlockSolver() {
        this.mIea.unlockSolver();
    }

    public boolean contextIsAbsorbingElement() {
        return this.mContextIsAbsorbingElement;
    }

    public EqualityStatus checkIndexEquality(ArrayIndex arrayIndex, ArrayIndex arrayIndex2) {
        int n = 0;
        while (n < arrayIndex.size()) {
            EqualityStatus equalityStatus = this.checkEqualityStatus(arrayIndex.get(n), arrayIndex2.get(n));
            if (equalityStatus == EqualityStatus.NOT_EQUAL || equalityStatus == EqualityStatus.UNKNOWN) {
                return equalityStatus;
            }
            ++n;
        }
        return EqualityStatus.EQUAL;
    }

    public Term constructIndexEquality(ArrayIndex arrayIndex, ArrayIndex arrayIndex2) {
        assert (arrayIndex.size() == arrayIndex2.size());
        ArrayList<Term> arrayList = new ArrayList<Term>(arrayIndex.size());
        int n = 0;
        while (n < arrayIndex.size()) {
            EqualityStatus equalityStatus = this.checkEqualityStatus(arrayIndex.get(n), arrayIndex2.get(n));
            switch (equalityStatus) {
                case EQUAL: {
                    break;
                }
                case NOT_EQUAL: {
                    return this.mMgdScript.getScript().term("false", new Term[0]);
                }
                case UNKNOWN: {
                    arrayList.add(SmtUtils.binaryEquality(this.mMgdScript.getScript(), arrayIndex.get(n), arrayIndex2.get(n)));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            ++n;
        }
        return SmtUtils.and(this.mMgdScript.getScript(), arrayList);
    }

    public Term constructDerRelation(Script script, int n, Term term, Term term2) {
        EqualityStatus equalityStatus = this.checkEqualityStatus(term, term2);
        return switch (equalityStatus) {
            case EqualityStatus.EQUAL -> QuantifierUtils.getAbsorbingElement(script, n);
            case EqualityStatus.NOT_EQUAL -> QuantifierUtils.getNeutralElement(script, n);
            case EqualityStatus.UNKNOWN -> QuantifierUtils.applyDerOperator(script, n, term, term2);
            default -> throw new AssertionError();
        };
    }

    public Term constructAntiDerRelation(Script script, int n, Term term, Term term2) {
        EqualityStatus equalityStatus = this.checkEqualityStatus(term, term2);
        return switch (equalityStatus) {
            case EqualityStatus.EQUAL -> QuantifierUtils.getNeutralElement(script, n);
            case EqualityStatus.NOT_EQUAL -> QuantifierUtils.getAbsorbingElement(script, n);
            case EqualityStatus.UNKNOWN -> QuantifierUtils.applyDerOperator(script, n, term, term2);
            default -> throw new AssertionError();
        };
    }

    public Term constructDerRelation(Script script, int n, ArrayIndex arrayIndex, ArrayIndex arrayIndex2) {
        assert (arrayIndex.size() == arrayIndex2.size());
        ArrayList<Term> arrayList = new ArrayList<Term>(arrayIndex.size());
        int n2 = 0;
        while (n2 < arrayIndex.size()) {
            EqualityStatus equalityStatus = this.checkEqualityStatus(arrayIndex.get(n2), arrayIndex2.get(n2));
            switch (equalityStatus) {
                case EQUAL: {
                    break;
                }
                case NOT_EQUAL: {
                    return QuantifierUtils.getNeutralElement(script, n);
                }
                case UNKNOWN: {
                    arrayList.add(QuantifierUtils.applyDerOperator(script, n, arrayIndex.get(n2), arrayIndex2.get(n2)));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            ++n2;
        }
        return QuantifierUtils.applyDualFiniteConnective(script, n, arrayList);
    }

    public Term constructAntiDerRelation(Script script, int n, ArrayIndex arrayIndex, ArrayIndex arrayIndex2) {
        assert (arrayIndex.size() == arrayIndex2.size());
        ArrayList<Term> arrayList = new ArrayList<Term>(arrayIndex.size());
        int n2 = 0;
        while (n2 < arrayIndex.size()) {
            EqualityStatus equalityStatus = this.checkEqualityStatus(arrayIndex.get(n2), arrayIndex2.get(n2));
            switch (equalityStatus) {
                case EQUAL: {
                    break;
                }
                case NOT_EQUAL: {
                    return QuantifierUtils.getAbsorbingElement(script, n);
                }
                case UNKNOWN: {
                    arrayList.add(QuantifierUtils.applyAntiDerOperator(script, n, arrayIndex.get(n2), arrayIndex2.get(n2)));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            ++n2;
        }
        return QuantifierUtils.applyCorrespondingFiniteConnective(script, n, arrayList);
    }

    private Term constructNestedStoreUpdateConstraintForOnePosition(Script script, int n, Term term, ArrayIndex arrayIndex, List<ArrayIndex> list, ArrayIndex arrayIndex3, Term term2) {
        List<Term> list2 = list.stream().map(arrayIndex2 -> this.constructDerRelation(script, n, arrayIndex, (ArrayIndex)arrayIndex2)).collect(Collectors.toList());
        Term term3 = QuantifierUtils.applyCorrespondingFiniteConnective(script, n, list2);
        if (term3 == QuantifierUtils.getAbsorbingElement(script, n)) {
            return term3;
        }
        Term term4 = this.constructAntiDerRelation(script, n, arrayIndex, arrayIndex3);
        MultiDimensionalSelect multiDimensionalSelect = new MultiDimensionalSelect(term, arrayIndex);
        Term term5 = this.constructDerRelation(script, n, multiDimensionalSelect.toTerm(script), term2);
        Term term6 = QuantifierUtils.applyCorrespondingFiniteConnective(script, n, term3, term4, term5);
        return term6;
    }

    public Term constructNestedStoreUpdateConstraint(Script script, int n, Term term, ArrayIndex arrayIndex, List<ArrayIndex> list, List<Term> list2, Term term2) {
        assert (list.size() == list2.size());
        ArrayList<Term> arrayList = new ArrayList<Term>();
        Term term3 = this.constructNestedStoreUpdateConstraintForOnePosition(script, n, term, arrayIndex, list, arrayIndex, term2);
        arrayList.add(term3);
        LinkedList<ArrayIndex> linkedList = new LinkedList<ArrayIndex>(list);
        int n2 = 0;
        while (n2 < list.size()) {
            ArrayIndex arrayIndex2 = linkedList.removeFirst();
            Term term4 = list2.get(n2);
            Term term5 = this.constructNestedStoreUpdateConstraintForOnePosition(script, n, term, arrayIndex, linkedList, arrayIndex2, term4);
            arrayList.add(term5);
            ++n2;
        }
        Term term6 = QuantifierUtils.applyDualFiniteConnective(script, n, arrayList);
        return term6;
    }
}

