/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationStatistics;
import de.uni_freiburg.informatik.ultimate.automata.StatisticsType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.BinaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiComplementFKV;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiIntersectDD;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiIsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.IBuchiNwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsDeterministic;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsSemiDeterministic;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;

public final class BuchiIsIncluded<LETTER, STATE>
extends BinaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mFstOperand;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mSndOperand;
    private final Boolean mResult;
    private final NestedLassoRun<LETTER, STATE> mCounterexample;

    public BuchiIsIncluded(AutomataLibraryServices automataLibraryServices, IBuchiNwaInclusionStateFactory<STATE> iBuchiNwaInclusionStateFactory, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider2) throws AutomataLibraryException {
        super(automataLibraryServices);
        this.mFstOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mSndOperand = iNwaOutgoingLetterAndTransitionProvider2;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        Object object = new BuchiComplementFKV<LETTER, STATE>(this.mServices, iBuchiNwaInclusionStateFactory, this.mSndOperand).getResult();
        Object object2 = new BuchiIntersectDD<LETTER, STATE>(this.mServices, iBuchiNwaInclusionStateFactory, this.mFstOperand, object, true).getResult();
        BuchiIsEmpty buchiIsEmpty = new BuchiIsEmpty(this.mServices, object2);
        this.mResult = buchiIsEmpty.getResult();
        this.mCounterexample = buchiIsEmpty.getAcceptingNestedLassoRun();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ". Language is " + (this.mResult != false ? "" : "not ") + "included";
    }

    @Override
    public INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getFirstOperand() {
        return this.mFstOperand;
    }

    @Override
    public INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getSecondOperand() {
        return this.mSndOperand;
    }

    @Override
    public Boolean getResult() {
        return this.mResult;
    }

    public NestedLassoRun<LETTER, STATE> getCounterexample() {
        return this.mCounterexample;
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        return true;
    }

    @Override
    public AutomataOperationStatistics getAutomataOperationStatistics() {
        AutomataOperationStatistics automataOperationStatistics = BuchiIsIncluded.constructBasicInclusionStatistics(this.mServices, this.mLogger, this);
        return automataOperationStatistics;
    }

    static <LETTER, STATE> AutomataOperationStatistics constructBasicInclusionStatistics(AutomataLibraryServices automataLibraryServices, ILogger iLogger, BinaryNwaOperation<LETTER, STATE, ?> binaryNwaOperation) {
        AutomataOperationStatistics automataOperationStatistics = new AutomataOperationStatistics();
        int n = binaryNwaOperation.getFirstOperand().size();
        int n2 = binaryNwaOperation.getSecondOperand().size();
        Boolean bl = null;
        try {
            bl = new IsDeterministic<LETTER, STATE>(automataLibraryServices, binaryNwaOperation.getSecondOperand()).getResult();
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            iLogger.info((Object)"wanted to run IsDeterministic for statistics but toolchain was cancelled");
        }
        Boolean bl2 = null;
        try {
            bl2 = new IsSemiDeterministic<LETTER, STATE>(automataLibraryServices, binaryNwaOperation.getSecondOperand()).getResult();
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            iLogger.info((Object)"wanted to run IsSemiDeterministic for statistics but toolchain was cancelled");
        }
        boolean bl3 = (Boolean)binaryNwaOperation.getResult();
        automataOperationStatistics.addKeyValuePair(StatisticsType.STATES_LHS, n);
        automataOperationStatistics.addKeyValuePair(StatisticsType.STATES_RHS, n2);
        automataOperationStatistics.addKeyValuePair(StatisticsType.RHS_IS_DETERMINISTIC, bl);
        automataOperationStatistics.addKeyValuePair(StatisticsType.RHS_IS_SEMIDETERMINISTIC, bl2);
        automataOperationStatistics.addKeyValuePair(StatisticsType.IS_INCLUDED, bl3);
        return automataOperationStatistics;
    }
}

