/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import java.math.BigInteger;
import java.util.List;

public class BigInterval {
    private final BigInteger mMinValue;
    private final BigInteger mMaxValue;

    public BigInterval(BigInteger bigInteger, BigInteger bigInteger2) {
        this.mMinValue = bigInteger;
        this.mMaxValue = bigInteger2;
        assert (this.mMinValue == null || this.mMaxValue == null || bigInteger2.compareTo(bigInteger) >= 0) : "empty interval not supported";
    }

    public static BigInterval unbounded() {
        return new BigInterval(null, null);
    }

    public static BigInterval booleanRange() {
        return new BigInterval(BigInteger.ZERO, BigInteger.ONE);
    }

    public static BigInterval singleton(BigInteger bigInteger) {
        return new BigInterval(bigInteger, bigInteger);
    }

    public BigInteger getMinValue() {
        return this.mMinValue;
    }

    public BigInteger getMaxValue() {
        return this.mMaxValue;
    }

    public BigInteger length() {
        return this.mMinValue != null && this.mMaxValue != null ? this.mMaxValue.subtract(this.mMinValue).add(BigInteger.ONE) : null;
    }

    public boolean isSingleton() {
        return this.mMinValue != null && this.mMaxValue != null && this.mMinValue.equals(this.mMaxValue);
    }

    public boolean isStrictlyPositive() {
        return this.mMinValue != null && this.mMinValue.signum() == 1;
    }

    public boolean isStrictlyNegative() {
        return this.mMaxValue != null && this.mMaxValue.signum() == -1;
    }

    public boolean isNonNegative() {
        return this.mMinValue != null && this.mMinValue.signum() >= 0;
    }

    public boolean isNonPositive() {
        return this.mMaxValue != null && this.mMaxValue.signum() <= 0;
    }

    public boolean isZero() {
        return this.isSingleton() && this.mMinValue.signum() == 0;
    }

    public boolean contains(BigInterval bigInterval) {
        boolean bl;
        boolean bl2 = this.mMinValue == null || bigInterval.mMinValue != null && this.mMinValue.compareTo(bigInterval.mMinValue) <= 0;
        boolean bl3 = bl = this.mMaxValue == null || bigInterval.mMaxValue != null && this.mMaxValue.compareTo(bigInterval.mMaxValue) >= 0;
        return bl2 && bl;
    }

    public boolean contains(BigInteger bigInteger) {
        boolean bl;
        boolean bl2 = this.mMinValue == null || this.mMinValue.compareTo(bigInteger) <= 0;
        boolean bl3 = bl = this.mMaxValue == null || this.mMaxValue.compareTo(bigInteger) >= 0;
        return bl2 && bl;
    }

    public BigInterval join(BigInterval bigInterval) {
        BigInteger bigInteger = this.mMinValue == null || bigInterval.mMinValue == null ? null : this.mMinValue.min(bigInterval.mMinValue);
        BigInteger bigInteger2 = this.mMaxValue == null || bigInterval.mMaxValue == null ? null : this.mMaxValue.max(bigInterval.mMaxValue);
        return new BigInterval(bigInteger, bigInteger2);
    }

    public BigInterval intersect(BigInterval bigInterval) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3 = this.mMinValue == null ? bigInterval.mMinValue : (bigInteger2 = bigInterval.mMinValue == null ? this.mMinValue : this.mMinValue.max(bigInterval.mMinValue));
        BigInteger bigInteger4 = this.mMaxValue == null ? bigInterval.mMaxValue : (bigInteger = bigInterval.mMaxValue == null ? this.mMaxValue : this.mMaxValue.min(bigInterval.mMaxValue));
        if (bigInteger.compareTo(bigInteger2) < 0) {
            return null;
        }
        return new BigInterval(bigInteger2, bigInteger);
    }

    public BigInterval negate() {
        BigInteger bigInteger = this.mMaxValue == null ? null : this.mMaxValue.negate();
        BigInteger bigInteger2 = this.mMinValue == null ? null : this.mMinValue.negate();
        return new BigInterval(bigInteger, bigInteger2);
    }

    public BigInterval abs() {
        if (this.mMinValue != null && this.mMinValue.signum() >= 0) {
            return this;
        }
        if (this.mMaxValue != null && this.mMaxValue.signum() < 0) {
            return new BigInterval(this.mMaxValue.abs(), this.mMinValue == null ? null : this.mMinValue.abs());
        }
        assert (this.contains(BigInteger.ZERO));
        BigInteger bigInteger = this.mMinValue == null || this.mMaxValue == null ? null : (this.mMinValue.abs().compareTo(this.mMaxValue) >= 1 ? this.mMinValue.abs() : this.mMaxValue);
        return new BigInterval(BigInteger.ZERO, bigInteger);
    }

    public BigInterval add(BigInterval bigInterval) {
        BigInteger bigInteger = this.mMinValue == null || bigInterval.getMinValue() == null ? null : this.mMinValue.add(bigInterval.mMinValue);
        BigInteger bigInteger2 = this.mMaxValue == null || bigInterval.getMaxValue() == null ? null : this.mMaxValue.add(bigInterval.mMaxValue);
        return new BigInterval(bigInteger, bigInteger2);
    }

    public BigInterval subtract(BigInterval bigInterval) {
        BigInteger bigInteger = this.mMinValue == null || bigInterval.mMaxValue == null ? null : this.mMinValue.subtract(bigInterval.mMaxValue);
        BigInteger bigInteger2 = this.mMaxValue == null || bigInterval.mMinValue == null ? null : this.mMaxValue.subtract(bigInterval.mMinValue);
        return new BigInterval(bigInteger, bigInteger2);
    }

    public BigInterval multiply(BigInterval bigInterval) {
        if (this.mMinValue == null || this.mMaxValue == null || bigInterval.mMinValue == null || bigInterval.mMaxValue == null) {
            return BigInterval.unbounded();
        }
        List<BigInteger> list = List.of(this.mMinValue.multiply(bigInterval.mMinValue), this.mMinValue.multiply(bigInterval.mMaxValue), this.mMaxValue.multiply(bigInterval.mMinValue), this.mMaxValue.multiply(bigInterval.mMaxValue));
        BigInteger bigInteger = (BigInteger)list.stream().min(BigInteger::compareTo).get();
        BigInteger bigInteger2 = (BigInteger)list.stream().max(BigInteger::compareTo).get();
        return new BigInterval(bigInteger, bigInteger2);
    }

    public BigInterval euclideanDivide(BigInterval bigInterval) {
        if (bigInterval.contains(BigInteger.ZERO)) {
            return BigInterval.unbounded();
        }
        if (bigInterval.isStrictlyNegative()) {
            return this.euclideanDivide(bigInterval.negate()).negate();
        }
        assert (bigInterval.isStrictlyPositive());
        BigInteger bigInteger = this.mMinValue == null ? null : (this.mMinValue.signum() < 0 ? BigInterval.euclideanDivide(this.mMinValue, bigInterval.mMinValue) : (bigInterval.mMaxValue != null ? BigInterval.euclideanDivide(this.mMinValue, bigInterval.mMaxValue) : BigInteger.ZERO));
        BigInteger bigInteger2 = this.mMaxValue == null ? null : (this.mMaxValue.signum() >= 0 ? BigInterval.euclideanDivide(this.mMaxValue, bigInterval.mMinValue) : (bigInterval.mMaxValue != null ? BigInterval.euclideanDivide(this.mMaxValue, bigInterval.mMaxValue) : BigInteger.ZERO));
        return new BigInterval(bigInteger, bigInteger2);
    }

    private static BigInteger euclideanDivide(BigInteger bigInteger, BigInteger bigInteger2) {
        assert (!BigInteger.ZERO.equals(bigInteger2)) : "divisor ZERO not supported";
        BigInteger bigInteger3 = bigInteger.divide(bigInteger2);
        if (bigInteger.signum() >= 0) {
            return bigInteger3;
        }
        if (bigInteger3.signum() > 0) {
            return bigInteger3.subtract(BigInteger.ONE);
        }
        return bigInteger3.add(BigInteger.ONE);
    }

    public BigInterval euclideanModulo(BigInteger bigInteger) {
        assert (!BigInteger.ZERO.equals(bigInteger)) : "divisor ZERO not supported";
        BigInteger bigInteger2 = bigInteger.abs();
        BigInteger bigInteger3 = this.length();
        if (bigInteger3 != null && bigInteger3.compareTo(bigInteger2) < 0) {
            BigInteger bigInteger4 = this.mMinValue.mod(bigInteger2);
            BigInteger bigInteger5 = this.mMaxValue.mod(bigInteger2);
            if (bigInteger5.compareTo(bigInteger4) >= 0) {
                return new BigInterval(bigInteger4, bigInteger5);
            }
        }
        return new BigInterval(BigInteger.ZERO, bigInteger2.subtract(BigInteger.ONE));
    }

    public BigInterval euclideanModulo(BigInterval bigInterval) {
        if (bigInterval.contains(BigInteger.ZERO)) {
            return BigInterval.unbounded();
        }
        if (bigInterval.isSingleton()) {
            return this.euclideanModulo(bigInterval.mMinValue);
        }
        BigInterval bigInterval2 = bigInterval.abs();
        BigInteger bigInteger = this.length();
        if (bigInteger != null && bigInterval2.mMaxValue != null && bigInteger.compareTo(bigInterval2.mMaxValue) >= 0) {
            return new BigInterval(BigInteger.ZERO, bigInterval2.mMaxValue.subtract(BigInteger.ONE));
        }
        if (bigInteger != null && bigInteger.compareTo(bigInterval2.mMinValue) >= 0) {
            BigInterval bigInterval3 = new BigInterval(BigInteger.ZERO, bigInteger.subtract(BigInteger.ONE));
            BigInterval bigInterval4 = this.euclideanModulo(new BigInterval(bigInteger.add(BigInteger.ONE), bigInterval2.mMaxValue));
            return bigInterval3.join(bigInterval4);
        }
        if (bigInterval2.mMinValue.compareTo(this.mMaxValue) > 0) {
            return this;
        }
        if (bigInterval2.mMaxValue != null && bigInterval2.mMaxValue.compareTo(this.mMaxValue) > 0) {
            return new BigInterval(BigInteger.ZERO, this.mMaxValue);
        }
        return new BigInterval(BigInteger.ZERO, bigInterval2.mMaxValue == null ? null : bigInterval2.mMaxValue.subtract(BigInteger.ONE));
    }
}

