/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class EvaluatorLogger {
    private static final String POSSIBLE_LOSS_OF_PRECISION = "Possible loss of precision. Operator ";
    private static final boolean MORE_LOGGING = false;
    private final ILogger mLogger;
    private final Set<UnaryExpression.Operator> mWarningsUnknownUnaryOps;
    private final Set<BinaryExpression.Operator> mWarningsUnknownBinaryOps;
    private final Set<BinaryExpression.Operator> mWarningsOverapproxBinaryOps;

    public EvaluatorLogger(ILogger iLogger) {
        this.mLogger = iLogger;
        this.mWarningsUnknownUnaryOps = new HashSet<UnaryExpression.Operator>(1);
        this.mWarningsUnknownBinaryOps = new HashSet<BinaryExpression.Operator>(1);
        this.mWarningsOverapproxBinaryOps = new HashSet<BinaryExpression.Operator>(1);
    }

    public void warnUnknownOperator(UnaryExpression.Operator operator) {
        if (!this.mLogger.isWarnEnabled()) {
            return;
        }
        if (!this.mWarningsUnknownUnaryOps.add(operator)) {
            return;
        }
        this.mLogger.warn((Object)(POSSIBLE_LOSS_OF_PRECISION + String.valueOf(operator) + " is not implemented."));
    }

    public void warnOverapproximatingOperator(BinaryExpression.Operator operator) {
        if (!this.mLogger.isWarnEnabled()) {
            return;
        }
        if (!this.mWarningsOverapproxBinaryOps.add(operator)) {
            return;
        }
        this.mLogger.warn((Object)(POSSIBLE_LOSS_OF_PRECISION + String.valueOf(operator) + " has no precise implementation."));
    }

    public void warnUnknownOperator(BinaryExpression.Operator operator) {
        if (!this.mLogger.isWarnEnabled()) {
            return;
        }
        if (!this.mWarningsUnknownBinaryOps.add(operator)) {
            return;
        }
        this.mLogger.warn((Object)(POSSIBLE_LOSS_OF_PRECISION + String.valueOf(operator) + " is not implemented."));
    }

    public void logInverseEvaluation(Object object, Object object2, Object ... objectArray) {
    }

    public void logEvaluation(Object object, Object object2, Object ... objectArray) {
    }

    private void logEvaluation(String string, Object object2, Object object3, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        Arrays.stream(objectArray).forEach(object -> {
            StringBuilder stringBuilder2 = stringBuilder.append(' ').append(object);
        });
        this.mLogger.debug((Object)("      " + string + " (" + String.valueOf(object2) + String.valueOf(stringBuilder) + ") = " + String.valueOf(object3)));
    }

    public ILogger getLogger() {
        return this.mLogger;
    }
}

