/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqConstraint;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqConstraintFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqDisjunctiveConstraint;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqNode;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqNodeAndFunctionFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp.EqPredicate;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp.EqState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp.TransFormulaConverterCache;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp.VPDomainSettings;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class EqStateFactory {
    private final EqNodeAndFunctionFactory mEqNodeAndFunctionFactory;
    private final EqConstraintFactory<EqNode> mEqConstraintFactory;
    private final IIcfgSymbolTable mSymbolTable;
    private EqState mTopStateWithEmptyPvocs;
    private final ManagedScript mMgdScript;
    private final ILogger mLogger;
    private final VPDomainSettings mVpDomainSettings;
    private TransFormulaConverterCache mTransformulaConverter;

    public EqStateFactory(EqNodeAndFunctionFactory eqNodeAndFunctionFactory, EqConstraintFactory<EqNode> eqConstraintFactory, IIcfgSymbolTable iIcfgSymbolTable, ManagedScript managedScript, VPDomainSettings vPDomainSettings) {
        this.mEqNodeAndFunctionFactory = eqNodeAndFunctionFactory;
        this.mEqConstraintFactory = eqConstraintFactory;
        this.mSymbolTable = iIcfgSymbolTable;
        this.mMgdScript = managedScript;
        this.mLogger = this.mEqConstraintFactory.getLogger();
        this.mVpDomainSettings = vPDomainSettings;
    }

    public EqState disjoinAll(Set<EqState> set) {
        EqDisjunctiveConstraint eqDisjunctiveConstraint = this.mEqConstraintFactory.getDisjunctiveConstraint((Collection)set.stream().map(eqState -> eqState.getConstraint()).collect(Collectors.toSet()));
        EqConstraint eqConstraint = eqDisjunctiveConstraint.flatten();
        return this.getEqState((EqConstraint<EqNode>)eqConstraint, eqConstraint.getPvocs(this.mSymbolTable));
    }

    public EqState getTopState() {
        if (this.mTopStateWithEmptyPvocs == null) {
            this.mTopStateWithEmptyPvocs = this.getEqState((EqConstraint<EqNode>)this.mEqConstraintFactory.getEmptyConstraint(false), Collections.emptySet());
        }
        return this.mTopStateWithEmptyPvocs;
    }

    public EqNodeAndFunctionFactory getEqNodeAndFunctionFactory() {
        return this.mEqNodeAndFunctionFactory;
    }

    public EqState getEqState(EqConstraint<EqNode> eqConstraint, Set<IProgramVarOrConst> set) {
        EqConstraint eqConstraint2 = eqConstraint;
        if (this.mEqConstraintFactory.getWeqSettings().closeAllEqConstraints()) {
            eqConstraint2 = this.mEqConstraintFactory.closeIfNecessary(eqConstraint);
        }
        eqConstraint2.freezeIfNecessary();
        return new EqState((EqConstraint<EqNode>)eqConstraint2, this.mEqNodeAndFunctionFactory, this, set);
    }

    public EqConstraintFactory<EqNode> getEqConstraintFactory() {
        return this.mEqConstraintFactory;
    }

    public IIcfgSymbolTable getSymbolTable() {
        return this.mSymbolTable;
    }

    public ManagedScript getManagedScript() {
        return this.mMgdScript;
    }

    public EqPredicate stateToPredicate(EqState eqState) {
        return new EqPredicate((EqDisjunctiveConstraint<EqNode>)this.getEqConstraintFactory().getDisjunctiveConstraint(Collections.singleton(eqState.getConstraint())), (ImmutableSet<IProgramVar>)eqState.getConstraint().getVariables(this.getSymbolTable()), this.getSymbolTable(), this.getManagedScript(), this.mEqNodeAndFunctionFactory);
    }

    public EqPredicate statesToPredicate(List<EqState> list) {
        HashSet hashSet = new HashSet();
        HashSet<EqConstraint<EqNode>> hashSet2 = new HashSet<EqConstraint<EqNode>>();
        for (EqState eqState : list) {
            hashSet.addAll(eqState.getConstraint().getVariables(this.mSymbolTable));
            hashSet2.add(eqState.getConstraint());
        }
        return new EqPredicate((EqDisjunctiveConstraint<EqNode>)this.getEqConstraintFactory().getDisjunctiveConstraint(hashSet2), (ImmutableSet<IProgramVar>)ImmutableSet.of(hashSet), this.getSymbolTable(), this.getManagedScript(), this.mEqNodeAndFunctionFactory);
    }

    public EqPredicate termToPredicate(Term term, IPredicate iPredicate) {
        return new EqPredicate(term, (ImmutableSet<IProgramVar>)ImmutableSet.copyOf((Collection)iPredicate.getVars()), (ImmutableSet<IProgramFunction>)ImmutableSet.copyOf((Collection)iPredicate.getFuns()), this.mSymbolTable, this.mMgdScript, this.mEqNodeAndFunctionFactory, this.mEqConstraintFactory);
    }

    public EqState getBottomState() {
        return this.getEqState((EqConstraint<EqNode>)this.mEqConstraintFactory.getBottomConstraint(), Collections.emptySet());
    }

    public ILogger getLogger() {
        return this.mLogger;
    }

    public VPDomainSettings getVpDomainSettings() {
        return this.mVpDomainSettings;
    }

    public void registerTransformulaConverter(TransFormulaConverterCache transFormulaConverterCache) {
        if (this.mTransformulaConverter != null) {
            throw new AssertionError((Object)"a transformula converter has already been registered");
        }
        this.mTransformulaConverter = transFormulaConverterCache;
    }

    public TransFormulaConverterCache getTransformulaConverter() {
        if (this.mTransformulaConverter == null) {
            throw new AssertionError((Object)"no transformula converter has been registered, yet");
        }
        return this.mTransformulaConverter;
    }
}

