/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableList;
import java.util.Set;

public class PredicateWithConjuncts
implements IPredicate {
    protected final int mSerial;
    protected final ImmutableList<IPredicate> mConjuncts;

    public PredicateWithConjuncts(int n, ImmutableList<IPredicate> immutableList) {
        this.mSerial = n;
        this.mConjuncts = immutableList;
    }

    public PredicateWithConjuncts(int n, IPredicate iPredicate, IPredicate iPredicate2) {
        this.mSerial = n;
        ImmutableList<IPredicate> immutableList = iPredicate instanceof PredicateWithConjuncts ? ((PredicateWithConjuncts)iPredicate).mConjuncts : ImmutableList.singleton((Object)iPredicate);
        this.mConjuncts = new ImmutableList((Object)iPredicate2, immutableList);
    }

    public ImmutableList<IPredicate> getConjuncts() {
        return this.mConjuncts;
    }

    public int hashCode() {
        return HashUtils.hashJenkins((int)31, (Object)this.mSerial);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof PredicateWithConjuncts)) {
            return false;
        }
        if (this.mSerial == ((PredicateWithConjuncts)object).mSerial) {
            throw new UnsupportedOperationException("different predicates with same serial number");
        }
        return false;
    }

    @Override
    public Term getFormula() {
        throw new UnsupportedOperationException("PredicateWithConjuncts does not offer formula. Access conjuncts individually.");
    }

    @Override
    public Term getClosedFormula() {
        throw new UnsupportedOperationException("PredicateWithConjuncts does not offer formula. Access conjuncts individually.");
    }

    @Override
    public Set<IProgramVar> getVars() {
        throw new UnsupportedOperationException("PredicateWithConjuncts does not offer variables. Access conjuncts individually.");
    }

    @Override
    public Set<IProgramFunction> getFuns() {
        throw new UnsupportedOperationException("PredicateWithConjuncts does not offer functions. Access conjuncts individually.");
    }

    public String toString() {
        return this.mSerial + "#" + this.mConjuncts.toString();
    }
}

