/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.TermTuple;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;

public class TTSubstitution {
    ArrayList<SubsPair> subs;
    HashSet<TermVariable> tvSet = new HashSet();

    public TTSubstitution() {
        this.subs = new ArrayList();
    }

    public TTSubstitution(TermVariable termVariable, Term term) {
        this();
        this.addSubs(term, termVariable);
    }

    public TTSubstitution(TTSubstitution tTSubstitution) {
        this();
        for (SubsPair subsPair : tTSubstitution.subs) {
            if (subsPair instanceof TPair) {
                this.addSubs(subsPair.top, (TermVariable)subsPair.bot);
                continue;
            }
            this.addEquality((EqPair)subsPair);
        }
    }

    public TTSubstitution(SortedSet<TermVariable> sortedSet, List<ApplicationTerm> list) {
        this();
        assert (sortedSet.size() == list.size());
        Iterator iterator = sortedSet.iterator();
        int n = 0;
        while (n < list.size()) {
            TermVariable termVariable = (TermVariable)iterator.next();
            this.addSubs((Term)list.get(n), termVariable);
            ++n;
        }
    }

    public ArrayList<CCEquality> getEqPathForEquality(ApplicationTerm applicationTerm, ApplicationTerm applicationTerm2) {
        for (SubsPair subsPair : this.subs) {
            if (!(subsPair instanceof EqPair)) continue;
            EqPair eqPair = (EqPair)subsPair;
            if ((!eqPair.bot.equals(applicationTerm) || !eqPair.top.equals(applicationTerm2)) && (!eqPair.bot.equals(applicationTerm2) || !eqPair.top.equals(applicationTerm))) continue;
            return eqPair.eqPath;
        }
        assert (false) : "should not happen..";
        return null;
    }

    public void addEquality(EqPair eqPair) {
        this.addEquality(eqPair.top, eqPair.bot, eqPair.eqPath);
    }

    public void addEquality(Term term, Term term2, ArrayList<CCEquality> arrayList) {
        this.subs.add(new EqPair(term, term2, arrayList));
    }

    public void addSubs(Term term, TermVariable termVariable) {
        this.tvSet.add(termVariable);
        this.subs.add(new TPair(term, termVariable));
    }

    public TermTuple apply(TermTuple termTuple) {
        if (this.subs.isEmpty()) {
            return termTuple;
        }
        Term[] termArray = new Term[termTuple.terms.length];
        int n = 0;
        while (n < termArray.length) {
            termArray[n] = termTuple.terms[n];
            ++n;
        }
        n = 0;
        while (n < termTuple.terms.length) {
            int n2 = 0;
            while (n2 < this.subs.size()) {
                SubsPair subsPair = this.subs.get(n2);
                if (termArray[n].equals(subsPair.bot)) {
                    termArray[n] = subsPair.top;
                }
                ++n2;
            }
            ++n;
        }
        return new TermTuple(termArray);
    }

    public boolean isEmpty() {
        return this.subs.isEmpty();
    }

    public Set<TermVariable> tvSet() {
        return this.tvSet;
    }

    public String toString() {
        return this.subs.toString();
    }

    public ArrayList<SubsPair> getSubsPairs() {
        return this.subs;
    }

    public class EqPair
    extends SubsPair {
        ArrayList<CCEquality> eqPath;

        public EqPair(Term term, Term term2, ArrayList<CCEquality> arrayList) {
            super(term, term2);
            this.eqPath = arrayList;
        }

        @Override
        public String toString() {
            return String.format("(%s,%s)", this.top.toString(), this.bot.toString());
        }
    }

    public abstract class SubsPair {
        public final Term top;
        public final Term bot;

        public SubsPair(Term term, Term term2) {
            this.top = term;
            this.bot = term2;
        }

        public String toString() {
            return String.format("(%s,%s)", this.top.toString(), this.bot.toString());
        }
    }

    public class TPair
    extends SubsPair {
        public final Term t;
        public final TermVariable tv;

        public TPair(Term term, TermVariable termVariable) {
            super(term, (Term)termVariable);
            this.t = term;
            this.tv = termVariable;
        }

        @Override
        public String toString() {
            return String.format("(%s,%s)", this.tv.toString(), this.t.toString());
        }
    }
}

