/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.results.CounterExampleResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.DataRaceFoundResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.PositiveResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.StatisticsResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.TimeoutResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.lib.results.UnprovableResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.UserSpecifiedLimitReachedResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithLocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class ResultUtil {
    private ResultUtil() {
    }

    public static <TE extends IElement, E> List<ILocation> getLocationSequence(IProgramExecution<TE, E> iProgramExecution) {
        if (iProgramExecution == null) {
            return Collections.emptyList();
        }
        ArrayList<ILocation> arrayList = new ArrayList<ILocation>();
        int n = 0;
        while (n < iProgramExecution.getLength()) {
            AtomicTraceElement atomicTraceElement = iProgramExecution.getTraceElement(n);
            arrayList.add(ILocation.getAnnotation((IElement)((IElement)atomicTraceElement.getTraceElement())));
            ++n;
        }
        return arrayList;
    }

    public static <E extends IResult> Collection<E> filterResults(Map<String, List<IResult>> map, Class<E> clazz) {
        ArrayList<E> arrayList = new ArrayList<E>();
        for (Map.Entry<String, List<IResult>> entry : map.entrySet()) {
            arrayList.addAll(ResultUtil.filterResults(entry.getValue(), clazz));
        }
        return arrayList;
    }

    public static Collection<IResult> filterResults(Map<String, List<IResult>> map, Predicate<IResult> predicate) {
        ArrayList<IResult> arrayList = new ArrayList<IResult>();
        for (Map.Entry<String, List<IResult>> entry : map.entrySet()) {
            arrayList.addAll(ResultUtil.filterResults(entry.getValue(), predicate));
        }
        return arrayList;
    }

    public static Map<String, List<IResult>> filterResultMap(Map<String, List<IResult>> map, Predicate<IResult> predicate) {
        LinkedHashMap<String, List<IResult>> linkedHashMap = new LinkedHashMap<String, List<IResult>>();
        for (Map.Entry<String, List<IResult>> entry : map.entrySet()) {
            List list = entry.getValue().stream().filter(predicate).collect(Collectors.toList());
            if (list.size() == entry.getValue().size()) {
                linkedHashMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            linkedHashMap.put(entry.getKey(), list);
        }
        return linkedHashMap;
    }

    public static <E extends IResult> Collection<E> filterResults(List<IResult> list, Class<E> clazz) {
        ArrayList<IResult> arrayList = new ArrayList<IResult>();
        for (IResult iResult : list) {
            if (!clazz.isAssignableFrom(iResult.getClass())) continue;
            IResult iResult2 = iResult;
            arrayList.add(iResult2);
        }
        return arrayList;
    }

    public static Collection<IResult> filterResults(List<IResult> list, Predicate<IResult> predicate) {
        return list.stream().filter(predicate).collect(Collectors.toList());
    }

    public static boolean anyMatch(Map<String, List<IResult>> map, Predicate<IResult> predicate) {
        return map.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).anyMatch(predicate);
    }

    public static <SE> String translateExpressionToString(IBacktranslationService iBacktranslationService, Class<SE> clazz, SE[] SEArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < SEArray.length) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(iBacktranslationService.translateExpressionToString(SEArray[n], clazz));
            ++n;
        }
        return stringBuilder.toString();
    }

    public static void logResults(ILogger iLogger, Map<String, List<IResult>> map, boolean bl) {
        if (iLogger == null || map == null) {
            throw new IllegalArgumentException("logger or results is null");
        }
        List list = map.entrySet().stream().filter(entry -> !((List)entry.getValue()).isEmpty()).collect(Collectors.toList());
        if (list.isEmpty()) {
            return;
        }
        iLogger.info((Object)" --- Results ---");
        for (Map.Entry entry2 : list) {
            iLogger.info((Object)String.format(" * Results from %s:", entry2.getKey()));
            for (IResult iResult : (List)entry2.getValue()) {
                ResultUtil.logResult(iLogger, iResult, bl);
            }
        }
    }

    private static void logResult(ILogger iLogger, IResult iResult, boolean bl) {
        String[] stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("  - ");
        stringBuilder.append(iResult.getClass().getSimpleName());
        if (iResult instanceof IResultWithLocation) {
            stringArray = ((IResultWithLocation)iResult).getLocation();
            if (stringArray.getStartLine() != 0) {
                stringBuilder.append(" [Line: ");
                stringBuilder.append(stringArray.getStartLine()).append("]");
            } else {
                stringBuilder.append(" [Unknown line] ");
            }
        }
        stringBuilder.append(": ");
        stringBuilder.append(iResult.getShortDescription());
        iLogger.info((Object)stringBuilder.toString());
        stringArray = iResult.getLongDescription().split("\n");
        if (bl) {
            iLogger.info((Object)String.format("    %s", iResult.getLongDescription()));
        } else {
            iLogger.info((Object)String.format("    %s", stringArray[0].replaceAll("\\n|\\r", "")));
            if (stringArray.length > 1) {
                iLogger.info((Object)"    [...]");
            }
        }
    }

    public static <E extends ICsvProviderProvider<?>> Collection<E> getCsvProviderProviderFromUltimateResults(Map<String, List<IResult>> map, Class<E> clazz) {
        Collection<StatisticsResult> collection = ResultUtil.filterResults(map, StatisticsResult.class);
        ArrayList arrayList = new ArrayList();
        for (StatisticsResult statisticsResult : collection) {
            ICsvProviderProvider iCsvProviderProvider = statisticsResult.getStatistics();
            if (!iCsvProviderProvider.getClass().isAssignableFrom(clazz)) continue;
            arrayList.add(iCsvProviderProvider);
        }
        return arrayList;
    }

    public static IResult combineLocationResults(IResult iResult, IResult iResult2) {
        if (iResult instanceof DataRaceFoundResult) {
            return iResult;
        }
        if (iResult2 instanceof CounterExampleResult || iResult2 instanceof DataRaceFoundResult) {
            return iResult2;
        }
        if (iResult instanceof TimeoutResultAtElement || iResult instanceof UserSpecifiedLimitReachedResultAtElement || iResult instanceof CounterExampleResult || iResult instanceof UnprovableResult) {
            return iResult;
        }
        assert (iResult instanceof PositiveResult) : "Unsupported location-specific result: " + String.valueOf(iResult);
        return iResult2;
    }
}

