/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.AbstractNodeAndFunctionFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqBottomConstraint;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqConstraint;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqConstraintFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.IEqNodeIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.VPStatistics;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class EqDisjunctiveConstraint<NODE extends IEqNodeIdentifier<NODE>> {
    private final Set<EqConstraint<NODE>> mConstraints;
    private final EqConstraintFactory<NODE> mFactory;
    private final AbstractNodeAndFunctionFactory<NODE, Term> mNodeAndFunctionFactory;

    public EqDisjunctiveConstraint(Collection<EqConstraint<NODE>> collection, EqConstraintFactory<NODE> eqConstraintFactory) {
        assert (!collection.stream().filter(eqConstraint -> eqConstraint instanceof EqBottomConstraint).findAny().isPresent()) : "we filter out EqBottomConstraints up front, right? (could also do it here..)";
        this.mConstraints = new HashSet<EqConstraint<NODE>>(collection);
        this.mFactory = eqConstraintFactory;
        this.mNodeAndFunctionFactory = eqConstraintFactory.getEqNodeAndFunctionFactory();
    }

    public boolean isBottom() {
        return this.mConstraints.isEmpty();
    }

    public EqDisjunctiveConstraint<NODE> projectExistentially(Collection<Term> collection) {
        ArrayList arrayList = new ArrayList();
        for (EqConstraint<NODE> eqConstraint : this.mConstraints) {
            arrayList.add(this.mFactory.projectExistentially(collection, eqConstraint, false));
        }
        return this.mFactory.getDisjunctiveConstraint(arrayList);
    }

    public Set<EqConstraint<NODE>> getConstraints() {
        return Collections.unmodifiableSet(this.mConstraints);
    }

    public EqConstraint<NODE> flatten() {
        if (this.mConstraints.size() == 0) {
            return this.mFactory.getBottomConstraint();
        }
        if (this.mConstraints.size() == 1) {
            return this.mConstraints.iterator().next();
        }
        return (EqConstraint)this.mConstraints.stream().reduce((eqConstraint, eqConstraint2) -> eqConstraint.join(eqConstraint2)).get();
    }

    public boolean isEmpty() {
        return this.mConstraints.isEmpty();
    }

    public Term getTerm(Script script) {
        List list = this.mConstraints.stream().map(eqConstraint -> eqConstraint.getTerm(script)).collect(Collectors.toList());
        return SmtUtils.or((Script)script, list);
    }

    public boolean areEqual(NODE NODE, NODE NODE2) {
        return this.mConstraints.stream().map(eqConstraint -> eqConstraint.areEqual(NODE, NODE2, this.mFactory.getWeqSettings().isAddNodesBeforeAnsweringQuery())).reduce((bl, bl2) -> bl != false || bl2 != false).get();
    }

    public boolean areEqual(Term term, Term term2) {
        NODE NODE = this.mNodeAndFunctionFactory.getExistingNode(term);
        if (NODE == null) {
            return false;
        }
        NODE NODE2 = this.mNodeAndFunctionFactory.getExistingNode(term2);
        if (NODE2 == null) {
            return false;
        }
        return this.areEqual(NODE, NODE2);
    }

    public boolean areUnequal(NODE NODE, NODE NODE2) {
        return this.mConstraints.stream().map(eqConstraint -> eqConstraint.areUnequal(NODE, NODE2, this.mFactory.getWeqSettings().isAddNodesBeforeAnsweringQuery())).reduce((bl, bl2) -> bl != false || bl2 != false).get();
    }

    public boolean areUnequal(Term term, Term term2) {
        NODE NODE = this.mNodeAndFunctionFactory.getExistingNode(term);
        if (NODE == null) {
            return false;
        }
        NODE NODE2 = this.mNodeAndFunctionFactory.getExistingNode(term2);
        if (NODE2 == null) {
            return false;
        }
        return this.areUnequal(NODE, NODE2);
    }

    private EqDisjunctiveConstraint<NODE> reportEquality(NODE NODE, NODE NODE2) {
        ArrayList arrayList = new ArrayList();
        for (EqConstraint<NODE> eqConstraint : this.mConstraints) {
            EqConstraint<NODE> eqConstraint2 = this.mFactory.unfreeze(eqConstraint);
            eqConstraint2.reportEqualityInPlace(NODE, NODE2);
            if (this.mFactory.getWeqCcManager().getSettings().closeAllEqConstraints()) {
                eqConstraint2 = this.mFactory.closeIfNecessary(eqConstraint2);
            }
            eqConstraint2.freezeIfNecessary();
            arrayList.add(eqConstraint2);
        }
        return this.mFactory.getDisjunctiveConstraint(arrayList);
    }

    public EqDisjunctiveConstraint<NODE> reportEquality(Term term, Term term2) {
        NODE NODE = this.mNodeAndFunctionFactory.getOrConstructNode(term);
        NODE NODE2 = this.mNodeAndFunctionFactory.getOrConstructNode(term2);
        return this.reportEquality(NODE, NODE2);
    }

    private EqDisjunctiveConstraint<NODE> reportDisequality(NODE NODE, NODE NODE2) {
        ArrayList arrayList = new ArrayList();
        for (EqConstraint<NODE> eqConstraint : this.mConstraints) {
            EqConstraint<NODE> eqConstraint2 = this.mFactory.unfreeze(eqConstraint);
            eqConstraint2.reportDisequalityInPlace(NODE, NODE2);
            if (this.mFactory.getWeqCcManager().getSettings().closeAllEqConstraints()) {
                eqConstraint2 = this.mFactory.closeIfNecessary(eqConstraint2);
            }
            eqConstraint2.freezeIfNecessary();
            arrayList.add(eqConstraint2);
        }
        return this.mFactory.getDisjunctiveConstraint(arrayList);
    }

    public EqDisjunctiveConstraint<NODE> reportDisequality(Term term, Term term2) {
        NODE NODE = this.mNodeAndFunctionFactory.getOrConstructNode(term);
        NODE NODE2 = this.mNodeAndFunctionFactory.getOrConstructNode(term2);
        return this.reportDisequality(NODE, NODE2);
    }

    public String toString() {
        if (this.mConstraints.isEmpty()) {
            return "EmptyDisjunction/False";
        }
        return "\\/ " + this.mConstraints.toString();
    }

    public String toLogString() {
        if (this.mConstraints.isEmpty()) {
            return "EmptyDisjunction/False";
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.mConstraints.forEach(eqConstraint -> {
            StringBuilder stringBuilder2 = stringBuilder.append(eqConstraint.toLogString() + "\n");
        });
        return "\\/ " + stringBuilder.toString();
    }

    public String getDebugInfo() {
        Object object;
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        Object object2 = VPStatistics.values();
        int n = ((VPStatistics[])object2).length;
        int n2 = 0;
        while (n2 < n) {
            object = object2[n2];
            hashMap.put(object, VPStatistics.getInitialValue((VPStatistics)((Object)object)));
            ++n2;
        }
        object = new StringBuilder();
        for (EqConstraint<NODE> eqConstraint : this.mConstraints) {
            VPStatistics[] vPStatisticsArray = VPStatistics.values();
            int n3 = vPStatisticsArray.length;
            int n4 = 0;
            while (n4 < n3) {
                object2 = vPStatisticsArray[n4];
                hashMap.put(object2, (Integer)VPStatistics.getAggregator((VPStatistics)((Object)object2)).apply((Integer)hashMap.get(object2), eqConstraint.getStatistics((VPStatistics)((Object)object2))));
                ++n4;
            }
        }
        ((StringBuilder)object).append("EqDisjunctiveConstraint statistics:");
        ((StringBuilder)object).append(hashMap);
        return ((StringBuilder)object).toString();
    }

    public int hashCode() {
        return Objects.hash(this.mConstraints);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EqDisjunctiveConstraint eqDisjunctiveConstraint = (EqDisjunctiveConstraint)object;
        return !(this.mConstraints == null ? eqDisjunctiveConstraint.mConstraints != null : !this.mConstraints.equals(eqDisjunctiveConstraint.mConstraints));
    }

    public Integer getStatistics(VPStatistics vPStatistics) {
        switch (vPStatistics) {
            case NO_DISJUNCTIONS: 
            case MAX_NO_DISJUNCTIONS: {
                return this.mConstraints.size();
            }
        }
        Integer n = VPStatistics.getInitialValue(vPStatistics);
        for (EqConstraint<NODE> eqConstraint : this.mConstraints) {
            n = (Integer)VPStatistics.getAggregator(vPStatistics).apply(n, eqConstraint.getStatistics(vPStatistics));
        }
        return n;
    }

    public EqDisjunctiveConstraint<NODE> closeDisjunctsIfNecessary() {
        if (this.mConstraints.stream().allMatch(eqConstraint -> eqConstraint.isClosed())) {
            return this;
        }
        HashSet hashSet = new HashSet();
        for (EqConstraint<NODE> eqConstraint2 : this.mConstraints) {
            hashSet.add(this.mFactory.closeIfNecessary(eqConstraint2));
        }
        return this.mFactory.getDisjunctiveConstraint(hashSet);
    }

    public void freezeDisjunctsIfNecessary() {
        for (EqConstraint<NODE> eqConstraint : this.mConstraints) {
            eqConstraint.freezeIfNecessary();
        }
    }

    public Set<NODE> getAllLiteralNodes() {
        HashSet<NODE> hashSet = new HashSet<NODE>();
        for (EqConstraint<NODE> eqConstraint : this.mConstraints) {
            hashSet.addAll(eqConstraint.getAllLiteralNodes());
        }
        return hashSet;
    }

    public EqConstraintFactory<NODE> getFactory() {
        return this.mFactory;
    }

    public Set<Term> getSetConstraintForExpression(Term term) {
        NODE NODE = this.mNodeAndFunctionFactory.getOrConstructNode(term);
        EqConstraint<NODE> eqConstraint = this.flatten();
        Set<NODE> set = eqConstraint.getSetConstraintForExpression(NODE);
        if (set == null) {
            return null;
        }
        return set.stream().map(iEqNodeIdentifier -> iEqNodeIdentifier.getTerm()).collect(Collectors.toSet());
    }
}

