/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.EqualityProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.TermCompiler;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ILiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.IProofTracker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantUtil;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantifierTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.Polynomial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;

public class SubstitutionHelper {
    private final QuantifierTheory mQuantTheory;
    private final Clausifier mClausifier;
    private final IProofTracker mTracker;
    private final Literal[] mGroundLits;
    private final QuantLiteral[] mQuantLits;
    private final SourceAnnotation mSource;
    private final Map<TermVariable, Term> mSigma;

    public SubstitutionHelper(QuantifierTheory quantifierTheory, Literal[] literalArray, QuantLiteral[] quantLiteralArray, SourceAnnotation sourceAnnotation, Map<TermVariable, Term> map) {
        this.mQuantTheory = quantifierTheory;
        this.mClausifier = this.mQuantTheory.getClausifier();
        this.mTracker = this.mClausifier.getTracker();
        this.mGroundLits = literalArray;
        this.mQuantLits = quantLiteralArray;
        this.mSource = sourceAnnotation;
        this.mSigma = map;
    }

    public SubstitutionResult substituteInClause() {
        Term term;
        Term term2;
        Term term3;
        ILiteral iLiteral;
        assert (!this.mSigma.isEmpty());
        ArrayList<Term> arrayList = new ArrayList<Term>(this.mGroundLits.length + this.mQuantLits.length);
        ArrayList<Term> arrayList2 = new ArrayList<Term>(this.mGroundLits.length + this.mQuantLits.length);
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        LinkedHashSet<Object> linkedHashSet2 = new LinkedHashSet<Object>();
        Theory theory = this.mQuantTheory.getTheory();
        ILiteral[] iLiteralArray = this.mGroundLits;
        int n = this.mGroundLits.length;
        int n2 = 0;
        while (n2 < n) {
            iLiteral = iLiteralArray[n2];
            term3 = ((Literal)iLiteral).getSMTFormula(theory);
            arrayList.add(term3);
            arrayList2.add(this.mTracker.reflexivity(term3));
            linkedHashSet.add(iLiteral);
            ++n2;
        }
        iLiteralArray = this.mQuantLits;
        n = this.mQuantLits.length;
        n2 = 0;
        while (n2 < n) {
            iLiteral = iLiteralArray[n2];
            if (Collections.disjoint(Arrays.asList(((QuantLiteral)iLiteral).getTerm().getFreeVars()), this.mSigma.keySet())) {
                arrayList.add(((QuantLiteral)iLiteral).getSMTFormula(theory));
                arrayList2.add(this.mTracker.reflexivity(((QuantLiteral)iLiteral).getSMTFormula(theory)));
                linkedHashSet2.add(iLiteral);
            } else {
                term3 = new FormulaUnLet();
                term3.addSubstitutions(this.mSigma);
                Term term4 = term3.transform(((QuantLiteral)iLiteral).getSMTFormula(theory));
                arrayList.add(term4);
                Term term5 = this.normalizeAndSimplifyLitTerm(term4);
                if (this.mTracker.getProvedTerm(term5) == theory.mTrue) {
                    return this.buildTrueResult();
                }
                if (this.mTracker.getProvedTerm(term5) == theory.mFalse) {
                    arrayList2.add(term5);
                } else {
                    Object object;
                    ILiteral iLiteral2;
                    Object object2;
                    Object object3;
                    boolean bl = true;
                    Term term6 = this.mTracker.getProvedTerm(term5);
                    assert (term6 instanceof ApplicationTerm);
                    if (((ApplicationTerm)term6).getFunction().getName() == "not") {
                        term6 = ((ApplicationTerm)term6).getParameters()[0];
                        bl = false;
                    }
                    assert (term6 instanceof ApplicationTerm);
                    ApplicationTerm applicationTerm = (ApplicationTerm)term6;
                    if (applicationTerm.getFunction().getName() == "<=") {
                        if (applicationTerm.getFreeVars().length == 0) {
                            object3 = new Polynomial(applicationTerm.getParameters()[0]);
                            object2 = this.mClausifier.createMutableAffinTerm((Polynomial)object3, this.mSource);
                            iLiteral2 = this.mQuantTheory.getLinAr().generateConstraint((MutableAffineTerm)object2, false);
                        } else {
                            iLiteral2 = this.mQuantTheory.getQuantInequality(bl, applicationTerm.getParameters()[0], this.mSource);
                        }
                    } else if (applicationTerm.getFunction().getName() == "=") {
                        object3 = applicationTerm.getParameters()[0];
                        object2 = applicationTerm.getParameters()[1];
                        if (applicationTerm.getFreeVars().length == 0) {
                            object = this.mClausifier.createEqualityProxy((Term)object3, (Term)object2, this.mSource);
                            assert (object != EqualityProxy.getTrueProxy() && object != EqualityProxy.getFalseProxy());
                            iLiteral2 = ((EqualityProxy)object).getLiteral(this.mSource);
                        } else {
                            iLiteral2 = this.mQuantTheory.getQuantEquality(applicationTerm.getParameters()[0], applicationTerm.getParameters()[1], this.mSource);
                        }
                    } else {
                        assert (applicationTerm.getFreeVars().length == 0);
                        assert (applicationTerm.getSort() == theory.getBooleanSort());
                        object3 = applicationTerm;
                        object2 = theory.mTrue;
                        object = this.mClausifier.createEqualityProxy((Term)object3, (Term)object2, this.mSource);
                        assert (object != EqualityProxy.getTrueProxy() && object != EqualityProxy.getFalseProxy());
                        iLiteral2 = ((EqualityProxy)object).getLiteral(this.mSource);
                    }
                    object3 = this.mTracker.intern((Term)applicationTerm, iLiteral2.getSMTFormula(theory));
                    if (bl) {
                        term5 = this.mTracker.transitivity(term5, (Term)object3);
                    } else {
                        term5 = this.mTracker.congruence(term5, new Term[]{object3});
                        term5 = this.mClausifier.getSimplifier().convertNot(term5);
                    }
                    arrayList2.add(term5);
                    ILiteral iLiteral3 = object2 = bl ? iLiteral2 : iLiteral2.negate();
                    if (object2 instanceof Literal) {
                        object = (Literal)object2;
                        if (linkedHashSet.contains(((Literal)object).negate())) {
                            return this.buildTrueResult();
                        }
                        linkedHashSet.add(object);
                    } else {
                        object = (QuantLiteral)object2;
                        if (linkedHashSet2.contains(((QuantLiteral)object).negate())) {
                            return this.buildTrueResult();
                        }
                        linkedHashSet2.add(object);
                    }
                }
            }
            ++n2;
        }
        boolean bl = arrayList.size() == 1;
        Term term7 = term2 = bl ? (Term)arrayList.get(0) : theory.term("or", arrayList.toArray(new Term[arrayList.size()]));
        if (bl) {
            assert (arrayList2.size() == 1);
            term = (Term)arrayList2.get(0);
        } else {
            term = this.mTracker.congruence(this.mTracker.reflexivity(term2), arrayList2.toArray(new Term[arrayList2.size()]));
            term = this.mTracker.orSimpClause(term);
        }
        return new SubstitutionResult(term2, term, linkedHashSet.toArray(new Literal[linkedHashSet.size()]), linkedHashSet2.toArray(new QuantLiteral[linkedHashSet2.size()]));
    }

    private Term normalizeAndSimplifyLitTerm(Term term) {
        Term term2;
        Theory theory = this.mQuantTheory.getTheory();
        boolean bl = term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName() == "not";
        ApplicationTerm applicationTerm = (ApplicationTerm)(bl ? ((ApplicationTerm)term).getParameters()[0] : term);
        Term term3 = this.mTracker.reflexivity((Term)applicationTerm);
        assert (applicationTerm.getFunction().getName() == "<=" || applicationTerm.getFunction().getName() == "=");
        TermCompiler termCompiler = this.mClausifier.getTermCompiler();
        if (applicationTerm.getFunction().getName() == "<=") {
            return termCompiler.transform(term);
        }
        assert (applicationTerm.getFunction().getName() == "=");
        Term term4 = applicationTerm.getParameters()[0];
        Term term5 = applicationTerm.getParameters()[1];
        if (QuantUtil.isAuxApplication(term4)) {
            Term[] termArray = ((ApplicationTerm)term4).getParameters();
            Term[] termArray2 = new Term[termArray.length];
            int n = 0;
            while (n < termArray2.length) {
                termArray2[n] = termCompiler.transform(termArray[n]);
                ++n;
            }
            Term term6 = this.mTracker.congruence(this.mTracker.reflexivity(term4), termArray2);
            term2 = this.mTracker.congruence(term3, new Term[]{term6, this.mTracker.reflexivity(term5)});
        } else {
            Term term7 = termCompiler.transform(term4);
            Term term8 = termCompiler.transform(term5);
            term2 = this.mTracker.congruence(term3, new Term[]{term7, term8});
            Term term9 = Clausifier.checkAndGetTrivialEquality(this.mTracker.getProvedTerm(term7), this.mTracker.getProvedTerm(term8), theory);
            if (term9 != null) {
                term2 = this.mTracker.transitivity(term2, this.mTracker.intern(this.mTracker.getProvedTerm(term2), term9));
            }
        }
        if (bl) {
            return this.mClausifier.getSimplifier().convertNot(this.mTracker.congruence(this.mTracker.reflexivity(term), new Term[]{term2}));
        }
        return term2;
    }

    private SubstitutionResult buildTrueResult() {
        return new SubstitutionResult(null, null, null, null);
    }

    static class SubstitutionResult {
        final Term mSubstituted;
        final Term mSimplified;
        final Literal[] mGroundLits;
        final QuantLiteral[] mQuantLits;

        protected SubstitutionResult(Term term, Term term2, Literal[] literalArray, QuantLiteral[] quantLiteralArray) {
            this.mSubstituted = term;
            this.mSimplified = term2;
            this.mGroundLits = literalArray;
            this.mQuantLits = quantLiteralArray;
        }

        public boolean isTriviallyTrue() {
            return this.mSimplified == null;
        }

        public boolean isGround() {
            return this.isTriviallyTrue() || this.mQuantLits.length == 0;
        }

        public Term getSubstituted() {
            return this.mSubstituted;
        }

        public Term getSimplified() {
            return this.mSimplified;
        }

        public Literal[] getGroundLits() {
            return this.mGroundLits;
        }

        public QuantLiteral[] getQuantLits() {
            return this.mQuantLits;
        }
    }
}

