/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainExceptionWrapper;
import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IFailedAnalysisResult;

public class ExceptionOrErrorResult
extends AbstractResult
implements IFailedAnalysisResult {
    private final Throwable mThrowable;

    public ExceptionOrErrorResult(String string, Throwable throwable) {
        super(ExceptionOrErrorResult.getPluginName(string, throwable));
        this.mThrowable = throwable instanceof ToolchainExceptionWrapper ? throwable.getCause() : throwable;
    }

    private static String getPluginName(String string, Throwable throwable) {
        if (throwable instanceof ToolchainExceptionWrapper) {
            return ((ToolchainExceptionWrapper)throwable).getPluginId();
        }
        return string;
    }

    public String getShortDescription() {
        return this.mThrowable.getClass().getSimpleName() + ": " + this.mThrowable.getMessage();
    }

    public String getLongDescription() {
        StackTraceElement[] stackTraceElementArray = this.mThrowable.getStackTrace();
        StringBuilder stringBuilder = new StringBuilder().append(this.getPlugin()).append(": ").append(this.getShortDescription());
        if (stackTraceElementArray != null && stackTraceElementArray.length > 0) {
            stringBuilder.append(": ").append(stackTraceElementArray[0].toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return this.getLongDescription();
    }
}

