/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.Context;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTask;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPusher;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class QuantifierPushUtilsForLocalEliminatees {
    public static Term pushLocalEliminateesOverCorrespondingFiniteJunction(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, boolean bl, QuantifierPusher.PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, EliminationTask eliminationTask, QuantifierUtils.IQuantifierEliminator iQuantifierEliminator) {
        Term[] termArray = QuantifierUtils.getDualFiniteJuncts(eliminationTask.getQuantifier(), eliminationTask.getTerm());
        if (termArray.length <= 1) {
            throw new AssertionError((Object)"not dual finite connective");
        }
        Pair<Term, Set<TermVariable>> pair = QuantifierPushUtilsForLocalEliminatees.findSomePushableLocalEliminateeSet(eliminationTask);
        EliminationTask eliminationTask2 = eliminationTask;
        int n = 0;
        while (pair != null) {
            Set set = (Set)pair.getSecond();
            LinkedHashSet<TermVariable> linkedHashSet = new LinkedHashSet<TermVariable>(eliminationTask2.getEliminatees());
            linkedHashSet.removeAll(set);
            Context context = eliminationTask2.getContext().constructChildContextForQuantifiedFormula(managedScript.getScript(), new ArrayList<TermVariable>(linkedHashSet));
            Term term = QuantifierPushUtilsForLocalEliminatees.pushLocalEliminateeSetToDualJunct(iUltimateServiceProvider, managedScript, bl, pqeTechniques, simplificationTechnique, eliminationTask2.getQuantifier(), eliminationTask2.getTerm(), pair, context, iQuantifierEliminator);
            linkedHashSet.retainAll(Arrays.asList(term.getFreeVars()));
            if (linkedHashSet.isEmpty()) {
                return term;
            }
            termArray = QuantifierUtils.getDualFiniteJuncts((eliminationTask2 = new EliminationTask(eliminationTask2.getQuantifier(), linkedHashSet, term, eliminationTask2.getContext())).getQuantifier(), term);
            if (termArray.length <= 1) {
                return eliminationTask2.toTerm(managedScript.getScript());
            }
            pair = QuantifierPushUtilsForLocalEliminatees.findSomePushableLocalEliminateeSet(eliminationTask2);
            ++n;
        }
        if (n == 0) {
            return null;
        }
        return eliminationTask2.toTerm(managedScript.getScript());
    }

    private static Term pushLocalEliminateeSetToDualJunct(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, boolean bl, QuantifierPusher.PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, int n, Term term, Pair<Term, Set<TermVariable>> pair, Context context, QuantifierUtils.IQuantifierEliminator iQuantifierEliminator) {
        Term[] termArray = QuantifierUtils.getDualFiniteJuncts(n, term);
        if (termArray.length <= 1) {
            throw new AssertionError((Object)"not dual finite connective");
        }
        int n2 = Arrays.asList(termArray).indexOf(pair.getFirst());
        Term term2 = SmtUtils.quantifier(managedScript.getScript(), n, (Collection)pair.getSecond(), (Term)pair.getFirst());
        Context context2 = context.constructChildContextForConDis(iUltimateServiceProvider, managedScript, ((ApplicationTerm)term).getFunction(), Arrays.asList(termArray), n2);
        Term term3 = iQuantifierEliminator.eliminate(iUltimateServiceProvider, managedScript, bl, pqeTechniques, simplificationTechnique, context2, term2);
        ArrayList<Term> arrayList = new ArrayList<Term>(Arrays.asList(termArray));
        arrayList.set(n2, term3);
        return QuantifierUtils.applyDualFiniteConnective(managedScript.getScript(), n, arrayList);
    }

    static Pair<Term, Set<TermVariable>> findSomePushableLocalEliminateeSet(EliminationTask eliminationTask) {
        Term term;
        HashRelation hashRelation;
        Term term2 = QuantifierUtils.getDualFiniteJuncts(eliminationTask.getQuantifier(), eliminationTask.getTerm());
        assert (((Term[])term2).length > 1) : "not dual finite connective";
        HashRelation hashRelation2 = new HashRelation();
        Object object2 = term2;
        int n = ((Term[])object2).length;
        int n2 = 0;
        while (n2 < n) {
            hashRelation = object2[n2];
            term = new HashSet(Arrays.asList(hashRelation.getFreeVars()));
            for (TermVariable object3 : eliminationTask.getEliminatees()) {
                if (!term.contains(object3)) continue;
                hashRelation2.addPair((Object)object3, (Object)hashRelation);
            }
            ++n2;
        }
        hashRelation = new HashRelation();
        for (TermVariable termVariable : eliminationTask.getEliminatees()) {
            object2 = hashRelation2.getImage((Object)termVariable);
            assert (!object2.isEmpty());
            if (object2.size() != 1) continue;
            term = (Term)object2.iterator().next();
            QuantifierPusher.FormulaClassification formulaClassification = QuantifierPusher.classify(eliminationTask.getQuantifier(), term);
            switch (formulaClassification) {
                case ATOM: {
                    break;
                }
                case CORRESPONDING_FINITE_CONNECTIVE: {
                    hashRelation.addPair((Object)term, (Object)termVariable);
                    break;
                }
                case DUAL_FINITE_CONNECTIVE: {
                    throw new AssertionError((Object)"Dual finite connective not flattened");
                }
                case DUAL_QUANTIFIER: {
                    break;
                }
                case NOT_QUANTIFIED: {
                    throw new AssertionError((Object)"Illegal for the call above");
                }
                case SAME_QUANTIFIER: {
                    throw new AssertionError((Object)"Quantifier not flattened");
                }
                default: {
                    throw new AssertionError((Object)("Unknown value: " + String.valueOf((Object)formulaClassification)));
                }
            }
        }
        if (hashRelation.isEmpty()) {
            return null;
        }
        term = term2;
        int n3 = ((Term[])term).length;
        int n4 = 0;
        while (n4 < n3) {
            Term term3 = term[n4];
            Set set = hashRelation.getImage((Object)term3);
            if (!set.isEmpty()) {
                return new Pair((Object)term3, (Object)set);
            }
            ++n4;
        }
        throw new AssertionError((Object)"HashRelation must contain at least one element.");
    }
}

