/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.syntaxchecker;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.DefaultLocation;
import de.uni_freiburg.informatik.ultimate.core.lib.results.GenericResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.SyntaxCheckerSyntaxErrorResult;
import de.uni_freiburg.informatik.ultimate.core.lib.util.MonitoredProcess;
import de.uni_freiburg.informatik.ultimate.core.model.IAnalysis;
import de.uni_freiburg.informatik.ultimate.core.model.ITool;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IObserver;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithSeverity;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.syntaxchecker.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.syntaxchecker.FilenameExtractionObserver;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.syntaxchecker.PreferenceInitializer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SyntaxChecker
implements IAnalysis {
    private static final int SYNTAX_CHECKER_TIMEOUT_MS = 20000;
    protected String[] mFileTypes;
    protected ILogger mLogger;
    protected List<String> mFileNames;
    protected Unit mPreludeUnit;
    private IUltimateServiceProvider mServices;
    private FilenameExtractionObserver mFilenameExtractionObserver;

    public ModelType getOutputDefinition() {
        return null;
    }

    public boolean isGuiRequired() {
        return false;
    }

    public ITool.ModelQuery getModelQuery() {
        return ITool.ModelQuery.SOURCE;
    }

    public List<String> getDesiredToolIds() {
        return Collections.emptyList();
    }

    public void setInputDefinition(ModelType modelType) {
    }

    public List<IObserver> getObservers() {
        return Arrays.asList(new IObserver[]{this.mFilenameExtractionObserver});
    }

    public void setServices(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
    }

    public void init() {
        this.mFilenameExtractionObserver = new FilenameExtractionObserver(this.mLogger);
    }

    public void finish() {
        try {
            this.doSyntaxCheck();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private void doSyntaxCheck() throws IOException {
        boolean bl;
        Object object;
        Object object2;
        String string = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getString("Command for syntax error check");
        String string2 = this.mFilenameExtractionObserver.getFilename();
        boolean bl2 = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getBoolean("remove filename from checker output");
        String string3 = this.callSyntaxCheckerAndReturnStderrOutput(string, string2);
        if (string3 != null) {
            String string4 = SyntaxChecker.generateLongDescription(string, string3, string2, bl2);
            object2 = new DummyLocation();
            object = new SyntaxCheckerSyntaxErrorResult(Activator.PLUGIN_ID, (ILocation)object2, string4);
            this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)object);
            this.mServices.getProgressMonitorService().cancelToolchain();
        }
        if ((bl = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getBoolean("Do additional syntax warning check")) && (object = Objects.equals(string, object2 = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getString("Command for syntax warning check")) ? string3 : this.callSyntaxCheckerAndReturnStderrOutput((String)object2, string2)) != null) {
            String string5 = SyntaxChecker.generateLongDescription((String)object2, (String)object, string2, bl2);
            IResultWithSeverity.Severity severity = IResultWithSeverity.Severity.WARNING;
            GenericResult genericResult = new GenericResult(Activator.PLUGIN_ID, "Syntax checker warnings", string5, severity);
            this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)genericResult);
        }
    }

    private static String generateLongDescription(String string, String string2, String string3, boolean bl) {
        String string4 = bl ? string2.replace(string3 + ":", "").strip() : string2;
        return "Syntax check with command \"" + string + "\" returned the following output. " + System.lineSeparator() + string4;
    }

    private String callSyntaxCheckerAndReturnStderrOutput(String string, String string2) throws IOException {
        String string3 = string + " " + string2;
        Throwable throwable = null;
        Object var5_6 = null;
        try (MonitoredProcess monitoredProcess = MonitoredProcess.exec((String)string3, null, (IUltimateServiceProvider)this.mServices);){
            if (monitoredProcess == null) {
                this.mLogger.fatal((Object)" Could not create process, terminating... ");
                throw new IllegalStateException(" Could not create process, terminating... ");
            }
            monitoredProcess.setTerminationAfterTimeout(20000L);
            return SyntaxChecker.convert(monitoredProcess.getErrorStream());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String convert(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string = bufferedReader.readLine();
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        string = bufferedReader.readLine();
        while (string != null) {
            stringBuilder.append(System.lineSeparator());
            stringBuilder.append(string);
            string = bufferedReader.readLine();
        }
        return stringBuilder.toString();
    }

    public String getPluginName() {
        return "SyntaxChecker";
    }

    public String getPluginID() {
        return this.getClass().getPackage().getName();
    }

    public IPreferenceInitializer getPreferences() {
        return new PreferenceInitializer();
    }

    private final class DummyLocation
    extends DefaultLocation {
        private static final long serialVersionUID = 1L;

        public DummyLocation() {
            super(SyntaxChecker.this.mFilenameExtractionObserver.getFilename(), -1, 0, 0, 0);
        }
    }
}

