/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa.cfgpreprocessing;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgSummaryTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.sifa.cfgpreprocessing.CallReturnSummary;
import de.uni_freiburg.informatik.ultimate.lib.sifa.cfgpreprocessing.ProcedureGraph;
import de.uni_freiburg.informatik.ultimate.lib.sifa.statistics.SifaStats;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;

public class ProcedureGraphBuilder {
    private final SifaStats mStats;
    private final IIcfg<IcfgLocation> mIcfg;
    private ProcedureGraph mCurrentProcedureGraph;
    private final Queue<IcfgLocation> mWork = new ArrayDeque<IcfgLocation>();
    private final Set<IcfgLocation> mVisited = new HashSet<IcfgLocation>();

    public ProcedureGraphBuilder(SifaStats sifaStats, IIcfg<IcfgLocation> iIcfg) {
        this.mStats = sifaStats;
        this.mIcfg = iIcfg;
    }

    public ProcedureGraph graphOfProcedure(String string, Collection<IcfgLocation> collection, Collection<String> collection2) {
        this.mStats.start(SifaStats.Key.PROCEDURE_GRAPH_BUILDER_TIME);
        this.mCurrentProcedureGraph = new ProcedureGraph(this.mIcfg, string);
        collection.forEach(arg_0 -> ((ProcedureGraph)this.mCurrentProcedureGraph).addNode(arg_0));
        collection2.forEach(string2 -> this.copyEnterCallEdges(string, (String)string2));
        this.mCurrentProcedureGraph.getExitNode().ifPresent(this.mWork::add);
        this.mWork.addAll(collection);
        while (!this.mWork.isEmpty()) {
            for (IcfgEdge icfgEdge : this.mWork.remove().getIncomingEdges()) {
                this.processBottomUp(icfgEdge);
            }
        }
        this.mVisited.clear();
        this.mWork.clear();
        this.mStats.stop(SifaStats.Key.PROCEDURE_GRAPH_BUILDER_TIME);
        return this.mCurrentProcedureGraph;
    }

    private void copyEnterCallEdges(String string, String string2) {
        ((IcfgLocation)this.mIcfg.getProcedureEntryNodes().get(string2)).getIncomingEdges().stream().filter(icfgEdge -> icfgEdge instanceof IIcfgCallTransition).map(icfgEdge -> (IIcfgCallTransition)icfgEdge).filter(iIcfgCallTransition -> string.equals(iIcfgCallTransition.getPrecedingProcedure())).peek(this::copyEdge).map(IIcfgTransition::getSource).forEach(this::addToWorklistIfNew);
    }

    private void processBottomUp(IcfgEdge icfgEdge) {
        if (icfgEdge instanceof IIcfgReturnTransition) {
            this.processReturn((IIcfgReturnTransition<IcfgLocation, IIcfgCallTransition<IcfgLocation>>)((IIcfgReturnTransition)icfgEdge));
        } else if (icfgEdge instanceof IIcfgCallTransition) {
            this.processCall((IIcfgCallTransition<IcfgLocation>)((IIcfgCallTransition)icfgEdge));
        } else if (icfgEdge instanceof IIcfgSummaryTransition) {
            this.processCallSummary((IIcfgSummaryTransition<IcfgLocation>)((IIcfgSummaryTransition)icfgEdge));
        } else {
            this.addToWorklistIfNew((IcfgLocation)icfgEdge.getSource());
            this.copyEdge((IIcfgTransition<IcfgLocation>)icfgEdge);
        }
    }

    private void processReturn(IIcfgReturnTransition<IcfgLocation, IIcfgCallTransition<IcfgLocation>> iIcfgReturnTransition) {
        IIcfgCallTransition iIcfgCallTransition = iIcfgReturnTransition.getCorrespondingCall();
        IcfgLocation icfgLocation = iIcfgCallTransition.getSource();
        this.addToWorklistIfNew(icfgLocation);
        this.mCurrentProcedureGraph.addEdge(icfgLocation, new CallReturnSummary(iIcfgReturnTransition), iIcfgReturnTransition.getTarget());
    }

    private void processCall(IIcfgCallTransition<IcfgLocation> iIcfgCallTransition) {
        assert (iIcfgCallTransition.getTarget() == this.mCurrentProcedureGraph.getEntryNode()) : "Builder entered return (backwards) but should have skipped body of sub-procedure.";
    }

    private void processCallSummary(IIcfgSummaryTransition<IcfgLocation> iIcfgSummaryTransition) {
        if (iIcfgSummaryTransition.calledProcedureHasImplementation()) {
            return;
        }
        this.mCurrentProcedureGraph.addEdge(iIcfgSummaryTransition.getSource(), iIcfgSummaryTransition, iIcfgSummaryTransition.getTarget());
        this.addToWorklistIfNew(iIcfgSummaryTransition.getSource());
    }

    private void addToWorklistIfNew(IcfgLocation icfgLocation) {
        if (!this.mVisited.contains(icfgLocation)) {
            this.mVisited.add(icfgLocation);
            this.mWork.add(icfgLocation);
        }
    }

    private void copyEdge(IIcfgTransition<IcfgLocation> iIcfgTransition) {
        this.mCurrentProcedureGraph.addEdge(iIcfgTransition.getSource(), iIcfgTransition, iIcfgTransition.getTarget());
    }
}

