/*
 * Decompiled with CFR 0.152.
 */
package ap.util;

import java.io.Serializable;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ArrayStack;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;
import scala.util.Sorting$;

public final class Timer$ {
    public static Timer$ MODULE$;
    private long startTime;
    private final ArrayStack<String> runningOps;
    private final HashMap<String, Object> accumulatedTimes;
    private final HashMap<String, Object> callCounters;
    private Thread lastThread;
    private boolean timerDisabled;

    static {
        new Timer$();
    }

    private long startTime() {
        return this.startTime;
    }

    private void startTime_$eq(long x$1) {
        this.startTime = x$1;
    }

    private ArrayStack<String> runningOps() {
        return this.runningOps;
    }

    private HashMap<String, Object> accumulatedTimes() {
        return this.accumulatedTimes;
    }

    private HashMap<String, Object> callCounters() {
        return this.callCounters;
    }

    private void addTime() {
        BoxedUnit boxedUnit;
        long now = System.nanoTime();
        if (!this.runningOps().isEmpty()) {
            String op = (String)this.runningOps().top();
            boxedUnit = this.accumulatedTimes().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)op), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.accumulatedTimes().apply((Object)op)) + now - this.startTime()))));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.startTime_$eq(now);
    }

    private Thread lastThread() {
        return this.lastThread;
    }

    private void lastThread_$eq(Thread x$1) {
        this.lastThread = x$1;
    }

    private boolean timerDisabled() {
        return this.timerDisabled;
    }

    private void timerDisabled_$eq(boolean x$1) {
        this.timerDisabled = x$1;
    }

    public <A> A measure(String op, Function0<A> comp) {
        Object object;
        if (this.timerDisabled()) {
            Timer$ timer$ = this;
            synchronized (timer$) {
                this.callCounters().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)op), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.callCounters().apply((Object)op)) + 1))));
            }
            return (A)comp.apply();
        }
        if (this.lastThread() == null) {
            this.lastThread_$eq(Thread.currentThread());
        } else if (this.lastThread() != Thread.currentThread()) {
            Console$.MODULE$.err().println("Warning: disabling ap.util.Timer due to multi-threading");
            this.timerDisabled_$eq(true);
            return this.measure(op, comp);
        }
        this.addTime();
        this.callCounters().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)op), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.callCounters().apply((Object)op)) + 1))));
        this.runningOps().push((Object)op);
        try {
            object = comp.apply();
        }
        finally {
            if (!this.timerDisabled()) {
                this.addTime();
                this.runningOps().pop();
            }
        }
        return (A)object;
    }

    public void reset() {
        this.accumulatedTimes().clear();
        this.callCounters().clear();
        this.runningOps().clear();
        this.lastThread_$eq(null);
        this.timerDisabled_$eq(false);
    }

    public String toString() {
        long l;
        ArrayBuilder resBuf = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(Tuple3.class));
        this.accumulatedTimes().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Timer$.$anonfun$toString$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String op = (String)tuple2._1();
                long time = tuple2._2$mcJ$sp();
                return (ArrayBuilder)resBuf.$plus$eq((Object)new Tuple3((Object)op, MODULE$.callCounters().apply((Object)op), (Object)(MODULE$.timerDisabled() ? BoxesRunTime.boxToLong((long)0L) : BoxesRunTime.boxToLong((long)time))));
            }
            throw new MatchError((Object)tuple2);
        });
        Tuple3[] resAr = (Tuple3[])resBuf.result();
        Sorting$.MODULE$.stableSort((Object)resAr, ClassTag$.MODULE$.apply(Tuple3.class), Ordering$.MODULE$.Tuple3((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Long$.MODULE$));
        String table = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resAr)).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)Timer$.$anonfun$toString$3(check$ifrefutable$2))).map((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple3 tuple3 = x$2;
            if (tuple3 != null) {
                String op = (String)tuple3._1();
                int count = BoxesRunTime.unboxToInt((Object)tuple3._2());
                long time = BoxesRunTime.unboxToLong((Object)tuple3._3());
                String paddedOp = op;
                while (new StringOps(Predef$.MODULE$.augmentString(paddedOp)).size() < 40) {
                    paddedOp = new StringBuilder(1).append(paddedOp).append(" ").toString();
                }
                double timeInMS = (double)time / 1000000.0;
                return new StringBuilder(4).append(paddedOp).append("\t").append(count).append("\t").append(timeInMS).append("ms").toString();
            }
            throw new MatchError((Object)tuple3);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n");
        if (this.timerDisabled()) {
            l = 0L;
        } else {
            long l2 = 0L;
            l = BoxesRunTime.unboxToLong((Object)this.accumulatedTimes().valuesIterator().$div$colon((Object)BoxesRunTime.boxToLong((long)l2), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x$4, x$5) -> x$4 + x$5));
        }
        long totalTime = l;
        double totalTimeInMS = (double)totalTime / 1000000.0;
        int n = 0;
        int totalCalls = BoxesRunTime.unboxToInt((Object)this.callCounters().valuesIterator().$div$colon((Object)BoxesRunTime.boxToInteger((int)n), (Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$7, x$8) -> x$7 + x$8));
        String total = new StringBuilder(11).append("Total: ").append(totalCalls).append(", ").append(totalTimeInMS).append("ms").toString();
        return new StringBuilder(1).append(table).append("\n").append(total).toString();
    }

    public static final /* synthetic */ boolean $anonfun$toString$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$toString$3(Tuple3 check$ifrefutable$2) {
        Tuple3 tuple3 = check$ifrefutable$2;
        return tuple3 != null;
    }

    private Timer$() {
        MODULE$ = this;
        this.runningOps = new ArrayStack();
        this.accumulatedTimes = new HashMap<String, Object>(){

            public long default(String op) {
                return 0L;
            }
        };
        this.callCounters = new HashMap<String, Object>(){

            public int default(String op) {
                return 0;
            }
        };
        this.lastThread = null;
        this.timerDisabled = false;
    }
}

