/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class PowersetIterator<E>
implements Iterator<Set<E>> {
    private final List<E> mList;
    private final long mPowersetSize;
    private long mCurrentElement;

    public PowersetIterator(Collection<E> collection) {
        this.mList = new ArrayList<E>(collection);
        if (collection.size() >= 64) {
            throw new IllegalArgumentException("Powerset for " + collection.size() + " elements is too large.");
        }
        this.mPowersetSize = 1L << collection.size();
        this.mCurrentElement = 0L;
    }

    @Override
    public boolean hasNext() {
        return this.mCurrentElement != this.mPowersetSize;
    }

    public <C extends Collection<E>> C next(C c) {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int n = 0;
        while (n < this.mList.size()) {
            if (PowersetIterator.isBitSet(this.mCurrentElement, n)) {
                c.add(this.mList.get(n));
            }
            ++n;
        }
        ++this.mCurrentElement;
        return c;
    }

    private static boolean isBitSet(long l, int n) {
        return n < 64 && (l & 1L << n) != 0L;
    }

    @Override
    public Set<E> next() {
        return this.next(new HashSet());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("modification not supported");
    }
}

