/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.graph;

import de.uni_freiburg.informatik.ultimate.automata.tree.IRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeRun;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcHeadVar;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClause;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.PureSubstitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.graph.HcSsaTreeFlattener;
import de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.graph.SsaInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HCSSABuilder {
    private final TreeRun<HornClause, IPredicate> mInputTreeRun;
    private final ManagedScript mScript;
    private final PredicateUnifier mPredicateUnifier;
    private final HcSsaTreeFlattener mResult;
    private int mIndexCounter = -1;
    private final Map<String, Term> mIndexedConstants = new HashMap<String, Term>();
    private final Map<TreeRun<HornClause, IPredicate>, TreeRun<HornClause, SsaInfo>> mInputSubTreeToSsaSubtree = new HashMap<TreeRun<HornClause, IPredicate>, TreeRun<HornClause, SsaInfo>>();
    final HcSymbolTable mSymbolTable;

    public HCSSABuilder(TreeRun<HornClause, IPredicate> treeRun, IPredicate iPredicate, IPredicate iPredicate2, ManagedScript managedScript, PredicateUnifier predicateUnifier, HcSymbolTable hcSymbolTable) {
        this.mInputTreeRun = treeRun;
        this.mScript = managedScript;
        this.mSymbolTable = hcSymbolTable;
        this.mPredicateUnifier = predicateUnifier;
        this.mResult = this.buildSSA();
    }

    private HcSsaTreeFlattener buildSSA() {
        assert (this.mInputTreeRun.getRootSymbol() != null);
        assert (this.mInputTreeRun.getRoot() != null);
        TreeRun<HornClause, SsaInfo> treeRun = this.buildSSArec(this.mInputTreeRun, Collections.emptyList());
        return new HcSsaTreeFlattener(treeRun);
    }

    private TreeRun<HornClause, SsaInfo> buildSSArec(TreeRun<HornClause, IPredicate> treeRun, List<Term> list) {
        HornClause hornClause = (HornClause)treeRun.getRootSymbol();
        SsaInfo ssaInfo = this.buildSsaInfo((HornClause)treeRun.getRootSymbol(), list);
        assert (ssaInfo.getSubstitutionSize() == hornClause.getNoBodyPredicates());
        ArrayList<TreeRun<HornClause, SsaInfo>> arrayList = new ArrayList<TreeRun<HornClause, SsaInfo>>();
        int n = 0;
        while (n < hornClause.getNoBodyPredicates()) {
            TreeRun<HornClause, SsaInfo> treeRun2 = this.buildSSArec((TreeRun<HornClause, IPredicate>)((TreeRun)treeRun.getChildren().get(n)), ssaInfo.getSubstitution(n));
            arrayList.add(treeRun2);
            ++n;
        }
        TreeRun treeRun3 = new TreeRun((Object)ssaInfo, (IRankedLetter)hornClause, arrayList);
        this.mInputSubTreeToSsaSubtree.put(treeRun, (TreeRun<HornClause, SsaInfo>)treeRun3);
        return treeRun3;
    }

    private SsaInfo buildSsaInfo(HornClause hornClause, List<Term> list) {
        Term term;
        Object object;
        Object object2;
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        HashMap<Term, Term> hashMap2 = new HashMap<Term, Term>();
        int n = 0;
        while (n < hornClause.getTermVariablesForHeadPred().size()) {
            object2 = (HcHeadVar)hornClause.getTermVariablesForHeadPred().get(n);
            TermVariable termVariable = object2.getTermVariable();
            object = list.get(n);
            hashMap.put((Term)termVariable, (Term)object);
            hashMap2.put((Term)object, (Term)termVariable);
            ++n;
        }
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(hornClause.getConstraintFormula());
        object2 = new ArrayList();
        int n2 = 0;
        while (n2 < hornClause.getBodyPredicates().size()) {
            object = new ArrayList();
            int n3 = 0;
            while (n3 < ((List)hornClause.getBodyPredToArgs().get(n2)).size()) {
                term = (Term)((List)hornClause.getBodyPredToArgs().get(n2)).get(n3);
                ApplicationTerm applicationTerm = this.getFreshConstant(term, "ssa");
                arrayList.add(this.mScript.getScript().term("=", new Term[]{applicationTerm, term}));
                object.add(applicationTerm);
                ++n3;
            }
            object2.add(Collections.unmodifiableList(object));
            ++n2;
        }
        Term term2 = SmtUtils.and((Script)this.mScript.getScript(), arrayList);
        object = PureSubstitution.apply((ManagedScript)this.mScript, hashMap, (Term)term2);
        HashMap<Term, ApplicationTerm> hashMap3 = new HashMap<Term, ApplicationTerm>();
        TermVariable[] termVariableArray = object.getFreeVars();
        int n4 = termVariableArray.length;
        int n5 = 0;
        while (n5 < n4) {
            term = termVariableArray[n5];
            hashMap3.put(term, this.getFreshConstant(term, "hbv"));
            ++n5;
        }
        term = PureSubstitution.apply((ManagedScript)this.mScript, hashMap3, (Term)object);
        return new SsaInfo(this.mScript.getScript(), hornClause, hashMap, term, (List<List<Term>>)object2, hashMap2);
    }

    private ApplicationTerm getFreshConstant(Term term, String string) {
        Term term2 = PredicateUtils.getIndexedConstant((String)string, (Sort)term.getSort(), (int)this.getFreshIndex(term), this.mIndexedConstants, (Script)this.mScript.getScript());
        return (ApplicationTerm)term2;
    }

    private int getFreshIndex(Term term) {
        return ++this.mIndexCounter;
    }

    public TreeRun<HornClause, IPredicate> buildTreeRunWithBackVersionedInterpolants(Map<TreeRun<HornClause, IPredicate>, Term> map) {
        return this.buildBackVersionedTreeRunRec(this.mInputTreeRun, map);
    }

    private TreeRun<HornClause, IPredicate> buildBackVersionedTreeRunRec(TreeRun<HornClause, IPredicate> treeRun, Map<TreeRun<HornClause, IPredicate>, Term> map) {
        TreeRun<HornClause, SsaInfo> treeRun2 = this.mInputSubTreeToSsaSubtree.get(treeRun);
        if (treeRun2 == null) {
            return new TreeRun((Object)this.mPredicateUnifier.getTruePredicate());
        }
        Term term = map.get(treeRun);
        HornClause hornClause = (HornClause)treeRun.getRootSymbol();
        Term term2 = PureSubstitution.apply((ManagedScript)this.mScript, ((SsaInfo)treeRun2.getRoot()).getBackSubstitution(), (Term)term);
        IPredicate iPredicate = this.mPredicateUnifier.getOrConstructPredicate(term2);
        ArrayList<TreeRun<HornClause, IPredicate>> arrayList = new ArrayList<TreeRun<HornClause, IPredicate>>();
        int n = 0;
        while (n < treeRun.getChildren().size()) {
            arrayList.add(this.buildBackVersionedTreeRunRec((TreeRun<HornClause, IPredicate>)((TreeRun)treeRun.getChildren().get(n)), map));
            ++n;
        }
        return new TreeRun((Object)iPredicate, (IRankedLetter)hornClause, arrayList);
    }

    public HcSsaTreeFlattener getSSA() {
        return this.mResult;
    }
}

