/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.boogie.symboltable.BoogieSymbolTable;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractPostOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SMT;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Expression2Term;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.IBoogieSymbolTableVariableProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.MappedTerm2Expression;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.AbsIntBenchmark;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.rcfg.RcfgStatementExtractor;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.ITermProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.BooleanValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalEvaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalStatementProcessor;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalUtils;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.IEvaluationResult;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.util.typeutils.TypeUtils;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.CallInfoCache;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.TemporaryBoogieVar;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Call;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Return;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class NonrelationalPostOperator<STATE extends NonrelationalState<STATE, V>, V extends INonrelationalValue<V>>
implements IAbstractPostOperator<STATE, IcfgEdge> {
    private final ILogger mLogger;
    private final RcfgStatementExtractor mStatementExtractor;
    private final NonrelationalStatementProcessor<STATE, V> mStatementProcessor;
    private final BoogieSymbolTable mSymbolTable;
    private final int mParallelStates;
    private final IBoogieSymbolTableVariableProvider mBoogie2SmtSymbolTable;
    private final Boogie2SMT mBoogie2Smt;
    private final CallInfoCache mCallInfoCache;
    private AbsIntBenchmark<IcfgEdge> mAbsIntBenchmark = null;
    private final MappedTerm2Expression mMappedTerm2Expression;
    private final NonrelationalEvaluator<STATE, V> mEvaluator;

    protected NonrelationalPostOperator(ILogger iLogger, BoogieSymbolTable boogieSymbolTable, IBoogieSymbolTableVariableProvider iBoogieSymbolTableVariableProvider, int n, Boogie2SMT boogie2SMT, CfgSmtToolkit cfgSmtToolkit, NonrelationalEvaluator<STATE, V> nonrelationalEvaluator) {
        this.mLogger = iLogger;
        this.mStatementExtractor = new RcfgStatementExtractor();
        this.mBoogie2SmtSymbolTable = iBoogieSymbolTableVariableProvider;
        this.mStatementProcessor = new NonrelationalStatementProcessor<STATE, V>(iLogger, (IBoogieSymbolTableVariableProvider)boogie2SMT.getBoogie2SmtSymbolTable(), nonrelationalEvaluator);
        this.mEvaluator = nonrelationalEvaluator;
        this.mSymbolTable = boogieSymbolTable;
        this.mParallelStates = n;
        this.mBoogie2Smt = boogie2SMT;
        this.mCallInfoCache = new CallInfoCache(cfgSmtToolkit, boogieSymbolTable);
        this.mMappedTerm2Expression = new MappedTerm2Expression(this.mBoogie2Smt.getTypeSortTranslator(), this.mBoogie2Smt.getBoogie2SmtSymbolTable(), this.mBoogie2Smt.getManagedScript());
    }

    public List<STATE> apply(STATE STATE, IcfgEdge icfgEdge) {
        assert (STATE != null);
        assert (!((NonrelationalState)STATE).isBottom()) : "You should not need to calculate post of a bottom state";
        assert (icfgEdge != null);
        IcfgEdge icfgEdge2 = icfgEdge.getLabel();
        if (icfgEdge2 instanceof Summary) {
            if (!((Summary)icfgEdge2).calledProcedureHasImplementation()) {
                throw new UnsupportedOperationException("Summary for procedure without implementation: " + BoogiePrettyPrinter.print((Statement)((Summary)icfgEdge2).getCallStatement()));
            }
            return this.handleReturnTransition(STATE, STATE, icfgEdge2);
        }
        if (icfgEdge2 instanceof IIcfgInternalTransition) {
            return this.handleInternalTransition(STATE, icfgEdge2);
        }
        if (icfgEdge2 instanceof Call) {
            return this.handleCallTransition(STATE, STATE, (Call)icfgEdge2);
        }
        if (icfgEdge2 instanceof Return) {
            return this.handleReturnTransition(STATE, STATE, icfgEdge2);
        }
        throw new UnsupportedOperationException("Unknown transition type: " + String.valueOf(icfgEdge2.getClass()));
    }

    public List<STATE> apply(STATE STATE, STATE STATE2, IcfgEdge icfgEdge) {
        assert (STATE != null);
        assert (!((NonrelationalState)STATE).isBottom()) : "You should not need to calculate post of a bottom state (BL)";
        assert (STATE2 != null);
        assert (!((NonrelationalState)STATE2).isBottom()) : "You should not need to calculate post of a bottom state (AL)";
        assert (icfgEdge != null);
        IcfgEdge icfgEdge2 = icfgEdge.getLabel();
        assert (icfgEdge2 instanceof Call || icfgEdge2 instanceof Return || icfgEdge2 instanceof Summary) : "Cannot calculate hierachical post for non-hierachical transition";
        if (icfgEdge2 instanceof Call) {
            Call call = (Call)icfgEdge2;
            return this.handleCallTransition(STATE, STATE2, call);
        }
        if (icfgEdge2 instanceof Return || icfgEdge2 instanceof Summary) {
            return this.handleReturnTransition(STATE, STATE2, icfgEdge2);
        }
        throw new UnsupportedOperationException("Nonrelational domains do not support context switches other than Call and Return (yet)");
    }

    private Expression getExpression(Term term, STATE STATE) {
        Map<TermVariable, String> map = ((NonrelationalState)STATE).getVariables().stream().filter(iProgramVarOrConst -> iProgramVarOrConst instanceof TemporaryBoogieVar).map(iProgramVarOrConst -> (TemporaryBoogieVar)iProgramVarOrConst).collect(Collectors.toMap(TemporaryBoogieVar::getTermVariable, TemporaryBoogieVar::getGloballyUniqueId));
        return this.mMappedTerm2Expression.translate(term, Collections.emptySet(), map);
    }

    public IAbstractPostOperator.EvalResult evaluate(STATE STATE, Term term, Script script) {
        if (((NonrelationalState)STATE).isBottom()) {
            return IAbstractPostOperator.EvalResult.TRUE;
        }
        Expression expression = this.getExpression(term, STATE);
        Collection<IEvaluationResult<V>> collection = this.mEvaluator.evaluate(STATE, expression);
        boolean bl = true;
        boolean bl2 = true;
        for (IEvaluationResult<V> iEvaluationResult : collection) {
            switch (iEvaluationResult.getBooleanValue()) {
                case FALSE: 
                case BOTTOM: {
                    bl = false;
                    break;
                }
                case TOP: {
                    bl = false;
                    bl2 = false;
                    break;
                }
                case TRUE: {
                    bl2 = false;
                    break;
                }
            }
        }
        return IAbstractPostOperator.EvalResult.selectTF((boolean)bl, (boolean)bl2);
    }

    public void setAbsIntBenchmark(AbsIntBenchmark<IcfgEdge> absIntBenchmark) {
        this.mAbsIntBenchmark = absIntBenchmark;
    }

    private List<STATE> handleCallTransition(STATE STATE, STATE STATE2, Call call) {
        CallStatement callStatement = call.getCallStatement();
        CallInfoCache.CallInfo callInfo = this.mCallInfoCache.getCallInfo(callStatement);
        if (callInfo.getInParamAssign() == null) {
            return this.addOldvars(Collections.singletonList(STATE2), (Statement)callInfo.getOldVarAssign((Set<IProgramVarOrConst>)((NonrelationalState)STATE2).getVariables()));
        }
        IAbstractState iAbstractState = ((NonrelationalState)STATE).addVariables(callInfo.getTempInParams());
        List<IAbstractState> list = this.mStatementProcessor.process(iAbstractState, (Statement)callInfo.getInParamAssign(), callInfo.getLhs2TmpVar(), this.mAbsIntBenchmark);
        if (list.isEmpty()) {
            throw new AssertionError((Object)"The assignment operation resulted in 0 states.");
        }
        List<IProgramVarOrConst> list2 = callInfo.getRealInParams();
        ArrayList<STATE> arrayList = new ArrayList<STATE>();
        for (NonrelationalState nonrelationalState : list) {
            Object object = STATE2;
            int n = 0;
            while (n < list2.size()) {
                IProgramVarOrConst iProgramVarOrConst = callInfo.getTempInParams().get(n);
                IProgramVarOrConst iProgramVarOrConst4 = list2.get(n);
                Object STATE3 = object;
                Function<IProgramVarOrConst, NonrelationalState> function = iProgramVarOrConst2 -> STATE3.setValue(iProgramVarOrConst4, nonrelationalState.getValue((IProgramVarOrConst)iProgramVarOrConst2));
                Function<IProgramVarOrConst, NonrelationalState> function2 = iProgramVarOrConst3 -> STATE3.setBooleanValue(iProgramVarOrConst4, nonrelationalState.getBooleanValue(iProgramVarOrConst));
                object = TypeUtils.applyVariableFunction(function, function2, null, iProgramVarOrConst);
                ++n;
            }
            arrayList.add(object);
        }
        return this.addOldvars(new ArrayList(NonrelationalUtils.mergeStatesIfNecessary(arrayList, this.mParallelStates)), (Statement)callInfo.getOldVarAssign((Set<IProgramVarOrConst>)((NonrelationalState)STATE2).getVariables()));
    }

    private List<STATE> handleReturnTransition(STATE STATE, STATE STATE2, IcfgEdge icfgEdge) {
        Object object;
        BooleanValue[] booleanValueArray;
        Expression2Term.IIdentifierTranslator[] iIdentifierTranslatorArray;
        INonrelationalValue[] iNonrelationalValueArray;
        IProgramVar[] iProgramVarArray;
        VariableLHS variableLHS;
        CallStatement callStatement = NonrelationalPostOperator.getCorrespondingCall(icfgEdge);
        Procedure procedure = this.getProcedure(callStatement.getMethodName());
        Pair<Deque<V>, Deque<BooleanValue>> pair = this.getOutParamValues(procedure, STATE);
        VariableLHS[] variableLHSArray = callStatement.getLhs();
        if (((Deque)pair.getFirst()).size() + ((Deque)pair.getSecond()).size() != variableLHSArray.length) {
            throw new UnsupportedOperationException("The expected number of return variables (" + variableLHSArray.length + ") is different from the function's number of return variables (" + ((Deque)pair.getFirst()).size() + " vals, " + ((Deque)pair.getSecond()).size() + " bools).");
        }
        List<ITermProvider> list = this.getInParamValues(procedure, STATE);
        Expression[] expressionArray = callStatement.getArguments();
        if (list.size() != expressionArray.length) {
            throw new UnsupportedOperationException("The expected number of input expressions (" + expressionArray.length + ") is different from the function's number of input parameters (" + list.size() + ").");
        }
        ArrayList<IProgramVar> arrayList = new ArrayList<IProgramVar>();
        Object object3 = variableLHSArray;
        int n = variableLHSArray.length;
        int n2 = 0;
        while (n2 < n) {
            variableLHS = object3[n2];
            IProgramVar object22 = this.mBoogie2SmtSymbolTable.getBoogieVar(variableLHS.getIdentifier(), variableLHS.getDeclarationInformation(), false);
            assert (object22 != null);
            arrayList.add(object22);
            ++n2;
        }
        variableLHS = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Consumer<IProgramVar> consumer = arg_0 -> NonrelationalPostOperator.lambda$6((List)variableLHS, pair, arg_0);
        object3 = iProgramVar -> {
            boolean bl = arrayList2.add(new Pair(iProgramVar, (Object)((BooleanValue)((Deque)pair.getSecond()).removeFirst())));
        };
        for (IProgramVar iProgramVar2 : arrayList) {
            TypeUtils.consumeVariable(consumer, object3, null, iProgramVar2);
        }
        assert (((Deque)pair.getFirst()).isEmpty());
        assert (((Deque)pair.getSecond()).isEmpty());
        ArrayList<Expression> arrayList3 = new ArrayList<Expression>();
        int n3 = 0;
        while (n3 < list.size()) {
            iProgramVarArray = list.get(n3);
            iNonrelationalValueArray = expressionArray[n3];
            iIdentifierTranslatorArray = new Expression2Term.IIdentifierTranslator[]{new SimpleTranslator(), this.mBoogie2Smt.createConstOnlyIdentifierTranslator()};
            booleanValueArray = this.mBoogie2Smt.getExpression2Term().translateToTerm(iIdentifierTranslatorArray, (Expression)iNonrelationalValueArray).term();
            object = iProgramVarArray.getTerm(this.mBoogie2Smt.getScript(), booleanValueArray.getSort(), (Term)booleanValueArray);
            Object object2 = this.mBoogie2Smt.getTerm2Expression().translate((Term)object);
            assert (object2.getType() == BoogieType.TYPE_BOOL);
            arrayList3.add((Expression)object2);
            ++n3;
        }
        ArrayList<STATE> arrayList4 = new ArrayList<STATE>();
        if (!arrayList3.isEmpty()) {
            iProgramVarArray = this.applyInputParamExpressions(STATE2, callStatement, arrayList3);
            arrayList4.addAll((Collection<STATE>)iProgramVarArray);
        }
        if (arrayList4.isEmpty()) {
            arrayList4.add(STATE2);
        }
        iProgramVarArray = variableLHS.stream().map(Pair::getFirst).collect(Collectors.toList()).toArray(new IProgramVar[variableLHS.size()]);
        iNonrelationalValueArray = variableLHS.stream().map(Pair::getSecond).collect(Collectors.toList()).toArray(STATE2.getArray(variableLHS.size()));
        iIdentifierTranslatorArray = arrayList2.stream().map(Pair::getFirst).collect(Collectors.toList()).toArray(new IProgramVar[arrayList2.size()]);
        booleanValueArray = arrayList2.stream().map(Pair::getSecond).collect(Collectors.toList()).toArray(new BooleanValue[arrayList2.size()]);
        object = new ArrayList();
        for (Object object2 : arrayList4) {
            object.add(object2.setMixedValues((IProgramVarOrConst[])iProgramVarArray, iNonrelationalValueArray, (IProgramVarOrConst[])iIdentifierTranslatorArray, booleanValueArray, (IProgramVarOrConst[])new IProgramVar[0], STATE2.getArray(0)));
        }
        return new ArrayList(NonrelationalUtils.mergeStatesIfNecessary(object, this.mParallelStates));
    }

    private List<STATE> applyInputParamExpressions(STATE STATE, CallStatement callStatement, List<Expression> list) {
        Expression expression = list.get(0);
        int n = 1;
        while (n < list.size()) {
            expression = new BinaryExpression(callStatement.getLocation(), BinaryExpression.Operator.LOGICAND, expression, list.get(n));
            if (expression.getType() == null) {
                expression.setType((IBoogieType)BoogieType.TYPE_BOOL);
            }
            ++n;
        }
        AssumeStatement assumeStatement = new AssumeStatement(callStatement.getLocation(), expression);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("    Computing post after return for arguments with statement: " + BoogiePrettyPrinter.print((Statement)assumeStatement)));
        }
        List<STATE> list2 = this.handleInternalTransition(STATE, Collections.singletonList(assumeStatement));
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("    Resulting post states: " + String.valueOf(list2.stream().map(NonrelationalState::toLogString).collect(Collectors.toList()))));
        }
        return list2;
    }

    private List<STATE> handleInternalTransition(STATE STATE, IcfgEdge icfgEdge) {
        List<Statement> list = this.mStatementExtractor.process(icfgEdge.getLabel());
        return this.handleInternalTransition(STATE, list);
    }

    private List<STATE> handleInternalTransition(STATE STATE, List<Statement> list) {
        ArrayList arrayList = new ArrayList();
        arrayList.add(STATE);
        for (Statement statement : list) {
            ArrayList<NonrelationalState> arrayList2 = new ArrayList<NonrelationalState>();
            for (NonrelationalState nonrelationalState : arrayList) {
                List<NonrelationalState> list2 = this.mStatementProcessor.process(nonrelationalState, statement, this.mAbsIntBenchmark);
                for (NonrelationalState nonrelationalState2 : list2) {
                    if (nonrelationalState2.isBottom()) continue;
                    arrayList2.add(nonrelationalState2);
                }
            }
            arrayList = arrayList2;
        }
        if (arrayList.isEmpty()) {
            if (!((NonrelationalState)STATE).getVariables().isEmpty()) {
                arrayList.add(((NonrelationalState)STATE).bottomState());
            }
            return arrayList;
        }
        return new ArrayList(NonrelationalUtils.mergeStatesIfNecessary(arrayList, this.mParallelStates));
    }

    private static CallStatement getCorrespondingCall(IcfgEdge icfgEdge) {
        if (icfgEdge instanceof Return) {
            return ((Return)icfgEdge).getCallStatement();
        }
        if (icfgEdge instanceof Summary) {
            return ((Summary)icfgEdge).getCallStatement();
        }
        throw new IllegalArgumentException("Transition " + String.valueOf(icfgEdge.getClass()) + " has no corresponding call");
    }

    private List<STATE> addOldvars(List<STATE> list, Statement statement) {
        if (statement == null) {
            return list;
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("   Adding oldvars via " + BoogiePrettyPrinter.print((Statement)statement)));
        }
        ArrayList<NonrelationalState> arrayList = new ArrayList<NonrelationalState>();
        for (NonrelationalState nonrelationalState : list) {
            arrayList.addAll(this.mStatementProcessor.process(nonrelationalState, statement, this.mAbsIntBenchmark));
        }
        return new ArrayList(NonrelationalUtils.mergeStatesIfNecessary(arrayList, this.mParallelStates));
    }

    private Procedure getProcedure(String string) {
        return this.mSymbolTable.getFunctionOrProcedureDeclaration(string).stream().filter(declaration -> declaration instanceof Procedure).map(declaration -> (Procedure)declaration).filter(procedure -> procedure.getBody() != null).findFirst().orElseThrow(() -> new UnsupportedOperationException("Only uninterpreted functions available for " + string));
    }

    private Pair<Deque<V>, Deque<BooleanValue>> getOutParamValues(Procedure procedure, STATE STATE) {
        ArrayDeque arrayDeque = new ArrayDeque();
        ArrayDeque arrayDeque2 = new ArrayDeque();
        Consumer<IProgramVar> consumer = iProgramVar -> {
            boolean bl = arrayDeque.add(STATE.getValue((IProgramVarOrConst)iProgramVar));
        };
        Consumer<IProgramVar> consumer2 = iProgramVar -> {
            boolean bl = arrayDeque2.add(STATE.getBooleanValue((IProgramVarOrConst)iProgramVar));
        };
        VarList[] varListArray = procedure.getOutParams();
        int n = varListArray.length;
        int n2 = 0;
        while (n2 < n) {
            VarList varList = varListArray[n2];
            String[] stringArray = varList.getIdentifiers();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String string = stringArray[n4];
                IProgramVar iProgramVar2 = this.mBoogie2SmtSymbolTable.getBoogieVar(string, procedure.getIdentifier(), false);
                assert (iProgramVar2 != null);
                TypeUtils.consumeVariable(consumer, consumer2, null, iProgramVar2);
                ++n4;
            }
            ++n2;
        }
        return new Pair(arrayDeque, arrayDeque2);
    }

    private List<ITermProvider> getInParamValues(Procedure procedure, STATE STATE) {
        ArrayList<ITermProvider> arrayList = new ArrayList<ITermProvider>();
        Consumer<IProgramVar> consumer = iProgramVar -> {
            boolean bl = arrayList.add((ITermProvider)STATE.getValue((IProgramVarOrConst)iProgramVar));
        };
        Consumer<IProgramVar> consumer2 = iProgramVar -> {
            boolean bl = arrayList.add(STATE.getBooleanValue((IProgramVarOrConst)iProgramVar));
        };
        VarList[] varListArray = procedure.getInParams();
        int n = varListArray.length;
        int n2 = 0;
        while (n2 < n) {
            VarList varList = varListArray[n2];
            String[] stringArray = varList.getIdentifiers();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String string = stringArray[n4];
                IProgramVar iProgramVar2 = this.mBoogie2SmtSymbolTable.getBoogieVar(string, new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, procedure.getIdentifier()), false);
                assert (iProgramVar2 != null);
                TypeUtils.consumeVariable(consumer, consumer2, null, iProgramVar2);
                ++n4;
            }
            ++n2;
        }
        return arrayList;
    }

    private static /* synthetic */ void lambda$6(List list, Pair pair, IProgramVar iProgramVar) {
        boolean bl = list.add(new Pair((Object)iProgramVar, (Object)((INonrelationalValue)((Deque)pair.getFirst()).removeFirst())));
    }

    private class SimpleTranslator
    implements Expression2Term.IIdentifierTranslator {
        private SimpleTranslator() {
        }

        public Term getSmtIdentifier(String string, DeclarationInformation declarationInformation, boolean bl, BoogieASTNode boogieASTNode) {
            IProgramVar iProgramVar = NonrelationalPostOperator.this.mBoogie2SmtSymbolTable.getBoogieVar(string, declarationInformation, bl);
            if (iProgramVar == null) {
                iProgramVar = NonrelationalPostOperator.this.mBoogie2SmtSymbolTable.getBoogieConst(string);
            }
            assert (iProgramVar != null) : "Unknown symbol: " + string;
            return iProgramVar.getTerm();
        }
    }
}

